/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.repackage.cglib.transform.impl;

import org.hibernate.repackage.cglib.asm.Attribute;
import org.hibernate.repackage.cglib.asm.Type;
import org.hibernate.repackage.cglib.core.CodeEmitter;
import org.hibernate.repackage.cglib.core.Constants;
import org.hibernate.repackage.cglib.core.Signature;
import org.hibernate.repackage.cglib.core.TypeUtils;
import org.hibernate.repackage.cglib.transform.ClassEmitterTransformer;

public class AccessFieldTransformer
extends ClassEmitterTransformer {
    private Callback callback;

    public AccessFieldTransformer(Callback callback) {
        this.callback = callback;
    }

    public void declare_field(int access, String name, Type type, Object value, Attribute attrs) {
        super.declare_field(access, name, type, value, attrs);
        String property = TypeUtils.upperFirst(this.callback.getPropertyName(this.getClassType(), name));
        if (property != null) {
            CodeEmitter e = this.begin_method(1, new Signature("get" + property, type, Constants.TYPES_EMPTY), null, null);
            e.load_this();
            e.getfield(name);
            e.return_value();
            e.end_method();
            e = this.begin_method(1, new Signature("set" + property, Type.VOID_TYPE, new Type[]{type}), null, null);
            e.load_this();
            e.load_arg(0);
            e.putfield(name);
            e.return_value();
            e.end_method();
        }
    }

    public static interface Callback {
        public String getPropertyName(Type var1, String var2);
    }
}

