/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.mbeanserver;

import com.sun.jmx.trace.Trace;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.NotCompliantMBeanException;

public class Introspector {
    private static Vector attributes;
    private static Vector operations;
    private static String className;
    private static Class baseClass;
    private static final String attributeDescription = "Attribute exposed for management";
    private static final String operationDescription = "Operation exposed for management";
    private static final String constructorDescription = "Public constructor of the MBean";
    private static final String mbeanInfoDescription = "Information on the management interface of the MBean";
    static /* synthetic */ Class class$javax$management$DynamicMBean;
    static /* synthetic */ Class class$java$lang$Boolean;

    private Introspector() {
    }

    public static final boolean isDynamic(Class clazz) {
        return (class$javax$management$DynamicMBean == null ? (class$javax$management$DynamicMBean = Introspector.class$("javax.management.DynamicMBean")) : class$javax$management$DynamicMBean).isAssignableFrom(clazz);
    }

    public static void testCreation(Class clazz) throws NotCompliantMBeanException {
        int n = clazz.getModifiers();
        if (Modifier.isAbstract(n) || Modifier.isInterface(n)) {
            throw new NotCompliantMBeanException("The MBean must have a concrete class in order to be created remotely.");
        }
        Constructor<?>[] constructorArray = clazz.getConstructors();
        if (constructorArray.length == 0) {
            throw new NotCompliantMBeanException("The MBean must have a public constructor in order to be created remotely");
        }
    }

    public static synchronized MBeanInfo testCompliance(Class clazz) throws NotCompliantMBeanException {
        if (Introspector.isDynamic(clazz)) {
            return null;
        }
        return Introspector.testCompliance(clazz, null);
    }

    static synchronized MBeanInfo testCompliance(Class clazz, Class clazz2) throws NotCompliantMBeanException {
        if (clazz.isInterface()) {
            throw new NotCompliantMBeanException(clazz.getName() + " must be a class.");
        }
        baseClass = clazz;
        className = clazz.getName();
        if (clazz2 == null) {
            clazz2 = Introspector.getStandardMBeanInterface(clazz);
        } else {
            if (!clazz2.isAssignableFrom(clazz)) {
                throw new NotCompliantMBeanException(clazz.getName() + " does not implement the " + clazz2.getName() + " interface");
            }
            if (!clazz2.isInterface()) {
                throw new NotCompliantMBeanException(clazz.getName() + ": " + clazz2.getName() + " is not an interface");
            }
        }
        if (clazz2 == null) {
            throw new NotCompliantMBeanException(clazz.getName() + " does not implement the " + clazz.getName() + "MBean interface " + "or the DynamicMBean interface");
        }
        int n = clazz2.getModifiers();
        if (!Modifier.isPublic(n)) {
            throw new NotCompliantMBeanException(clazz2.getName() + " implemented by " + clazz.getName() + " must be public.");
        }
        return Introspector.introspect(clazz2);
    }

    public static synchronized Class getMBeanInterface(Class clazz) {
        if (Introspector.isDynamic(clazz)) {
            return null;
        }
        return Introspector.getStandardMBeanInterface(clazz);
    }

    static synchronized Class getStandardMBeanInterface(Class clazz) {
        Class clazz2 = null;
        for (Class clazz3 = clazz; clazz3 != null && (clazz2 = Introspector.findMBeanInterface(clazz3, clazz3.getName())) == null; clazz3 = clazz3.getSuperclass()) {
        }
        return clazz2;
    }

    private static final Class findMBeanInterface(Class clazz, String string) {
        for (Class clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            Class<?>[] classArray = clazz2.getInterfaces();
            int n = classArray.length;
            for (int i = 0; i < n; ++i) {
                Class clazz3 = Introspector.implementsMBean(classArray[i], string);
                if (clazz3 == null) continue;
                return clazz3;
            }
        }
        return null;
    }

    private static MBeanInfo introspect(Class clazz) throws NotCompliantMBeanException {
        attributes = new Vector();
        operations = new Vector();
        Method[] methodArray = null;
        methodArray = clazz.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            if (method == null) continue;
            String string = method.getName();
            Class<?>[] classArray = method.getParameterTypes();
            Class<?> clazz2 = method.getReturnType();
            int n = classArray.length;
            MBeanAttributeInfo mBeanAttributeInfo = null;
            MBeanOperationInfo mBeanOperationInfo = null;
            if (string.equals("get") || string.equals("is") || string.equals("set")) {
                try {
                    mBeanOperationInfo = new MBeanOperationInfo(operationDescription, method);
                }
                catch (Exception exception) {
                    Introspector.error("introspect", exception);
                }
                operations.addElement(mBeanOperationInfo);
                continue;
            }
            if (!(string.startsWith("get") || string.startsWith("set") || string.startsWith("is"))) {
                try {
                    mBeanOperationInfo = new MBeanOperationInfo(operationDescription, method);
                }
                catch (Exception exception) {
                    Introspector.error("introspect", exception);
                }
                operations.addElement(mBeanOperationInfo);
                continue;
            }
            if (n == 0) {
                if (string.startsWith("get")) {
                    if (clazz2 == Void.TYPE) {
                        try {
                            mBeanOperationInfo = new MBeanOperationInfo(operationDescription, method);
                        }
                        catch (Exception exception) {
                            Introspector.error("introspect", exception);
                        }
                        operations.addElement(mBeanOperationInfo);
                        continue;
                    }
                    try {
                        mBeanAttributeInfo = new MBeanAttributeInfo(string.substring(3), attributeDescription, method, null);
                    }
                    catch (Exception exception) {
                        Introspector.error("introspect", exception);
                    }
                    if (!Introspector.testConsistency(mBeanAttributeInfo)) continue;
                    attributes.addElement(mBeanAttributeInfo);
                    continue;
                }
                if ((clazz2 == (class$java$lang$Boolean == null ? Introspector.class$("java.lang.Boolean") : class$java$lang$Boolean) || clazz2 == Boolean.TYPE) && string.startsWith("is")) {
                    try {
                        mBeanAttributeInfo = new MBeanAttributeInfo(string.substring(2), attributeDescription, method, null);
                    }
                    catch (Exception exception) {
                        Introspector.error("introspect", exception);
                    }
                    if (!Introspector.testConsistency(mBeanAttributeInfo)) continue;
                    attributes.addElement(mBeanAttributeInfo);
                    continue;
                }
                if (string.startsWith("set")) {
                    try {
                        mBeanOperationInfo = new MBeanOperationInfo(operationDescription, method);
                    }
                    catch (Exception exception) {
                        Introspector.error("introspect", exception);
                    }
                    operations.addElement(mBeanOperationInfo);
                    continue;
                }
            }
            if (n == 1) {
                if (clazz2 == Void.TYPE && string.startsWith("set")) {
                    try {
                        mBeanAttributeInfo = new MBeanAttributeInfo(string.substring(3), attributeDescription, null, method);
                    }
                    catch (Exception exception) {
                        Introspector.error("introspect", exception);
                    }
                    if (!Introspector.testConsistency(mBeanAttributeInfo)) continue;
                    attributes.addElement(mBeanAttributeInfo);
                    continue;
                }
                try {
                    mBeanOperationInfo = new MBeanOperationInfo(operationDescription, method);
                }
                catch (Exception exception) {
                    Introspector.error("introspect", exception);
                }
                operations.addElement(mBeanOperationInfo);
                continue;
            }
            if (n <= 1) continue;
            try {
                mBeanOperationInfo = new MBeanOperationInfo(operationDescription, method);
            }
            catch (Exception exception) {
                Introspector.error("introspect", exception);
            }
            operations.addElement(mBeanOperationInfo);
        }
        return Introspector.constructResult();
    }

    private static boolean testConsistency(MBeanAttributeInfo mBeanAttributeInfo) throws NotCompliantMBeanException {
        Enumeration enumeration = attributes.elements();
        while (enumeration.hasMoreElements()) {
            MBeanAttributeInfo mBeanAttributeInfo2 = (MBeanAttributeInfo)enumeration.nextElement();
            if (mBeanAttributeInfo2.getName().compareTo(mBeanAttributeInfo.getName()) != 0) continue;
            if (mBeanAttributeInfo.isReadable() && mBeanAttributeInfo2.isReadable() && mBeanAttributeInfo.isIs() != mBeanAttributeInfo2.isIs()) {
                throw new NotCompliantMBeanException("Getter is" + mBeanAttributeInfo2.getName() + " cannot co-exist with getter get" + mBeanAttributeInfo.getName());
            }
            if (mBeanAttributeInfo2.getType().compareTo(mBeanAttributeInfo.getType()) != 0) {
                if (mBeanAttributeInfo2.isWritable() && mBeanAttributeInfo.isWritable()) {
                    throw new NotCompliantMBeanException("Type mismatch between parameters of set" + mBeanAttributeInfo2.getName() + " methods");
                }
                throw new NotCompliantMBeanException("Type mismatch between parameters of get or is" + mBeanAttributeInfo2.getName() + ", set" + mBeanAttributeInfo2.getName() + " methods");
            }
            if (mBeanAttributeInfo.isReadable() && mBeanAttributeInfo2.isReadable()) {
                return false;
            }
            if (!mBeanAttributeInfo.isWritable() || !mBeanAttributeInfo2.isWritable()) continue;
            return false;
        }
        return true;
    }

    static MBeanConstructorInfo[] getConstructors() {
        int n;
        Constructor<?>[] constructorArray = baseClass.getConstructors();
        Vector<MBeanConstructorInfo> vector = new Vector<MBeanConstructorInfo>();
        for (n = 0; n < constructorArray.length; ++n) {
            Constructor<?> constructor = constructorArray[n];
            MBeanConstructorInfo mBeanConstructorInfo = null;
            try {
                mBeanConstructorInfo = new MBeanConstructorInfo(constructorDescription, constructor);
            }
            catch (Exception exception) {
                mBeanConstructorInfo = null;
            }
            if (mBeanConstructorInfo == null) continue;
            vector.addElement(mBeanConstructorInfo);
        }
        MBeanConstructorInfo[] mBeanConstructorInfoArray = new MBeanConstructorInfo[vector.size()];
        for (n = 0; n < mBeanConstructorInfoArray.length; ++n) {
            mBeanConstructorInfoArray[n] = (MBeanConstructorInfo)vector.elementAt(n);
        }
        return mBeanConstructorInfoArray;
    }

    private static MBeanInfo constructResult() {
        Object object;
        MBeanOperationInfo[] mBeanOperationInfoArray;
        int n = attributes.size();
        MBeanAttributeInfo[] mBeanAttributeInfoArray = new MBeanAttributeInfo[n];
        attributes.toArray(mBeanAttributeInfoArray);
        ArrayList<MBeanOperationInfo[]> arrayList = new ArrayList<MBeanOperationInfo[]>();
        for (int i = 0; i < n; ++i) {
            mBeanOperationInfoArray = mBeanAttributeInfoArray[i];
            if (mBeanOperationInfoArray == null) continue;
            object = mBeanOperationInfoArray;
            for (int j = i + 1; j < n; ++j) {
                MBeanAttributeInfo mBeanAttributeInfo = mBeanAttributeInfoArray[j];
                if (mBeanAttributeInfo == null || mBeanAttributeInfo.getName().compareTo(mBeanOperationInfoArray.getName()) != 0) continue;
                mBeanAttributeInfoArray[j] = null;
                object = new MBeanAttributeInfo(mBeanOperationInfoArray.getName(), mBeanOperationInfoArray.getType(), attributeDescription, true, true, mBeanOperationInfoArray.isIs());
            }
            arrayList.add((MBeanOperationInfo[])object);
        }
        MBeanAttributeInfo[] mBeanAttributeInfoArray2 = new MBeanAttributeInfo[arrayList.size()];
        arrayList.toArray(mBeanAttributeInfoArray2);
        mBeanOperationInfoArray = new MBeanOperationInfo[operations.size()];
        operations.toArray(mBeanOperationInfoArray);
        object = Introspector.getConstructors();
        MBeanInfo mBeanInfo = new MBeanInfo(className, mbeanInfoDescription, mBeanAttributeInfoArray2, (MBeanConstructorInfo[])object, mBeanOperationInfoArray, null);
        return mBeanInfo;
    }

    static Class implementsMBean(Class clazz, String string) {
        if (clazz.getName().compareTo(string + "MBean") == 0) {
            return clazz;
        }
        Class clazz2 = clazz;
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            try {
                if (classArray[i].getName().compareTo(string + "MBean") != 0) continue;
                return classArray[i];
            }
            catch (Exception exception) {
                return null;
            }
        }
        return null;
    }

    private static void error(String string, Throwable throwable) {
        Trace.send(0, 1, "Introspector", string, throwable);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        className = null;
        baseClass = null;
    }
}

