/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.log.internal;

import java.text.MessageFormat;
import net.sourceforge.pmd.util.StringUtil;
import net.sourceforge.pmd.util.log.MessageReporter;
import org.apache.commons.lang3.exception.ExceptionUtils;

abstract class MessageReporterBase
implements MessageReporter {
    private int numErrors;
    private MessageReporter.Level minLevel = MessageReporter.Level.TRACE;

    MessageReporterBase() {
    }

    public final void setLevel(MessageReporter.Level minLevel) {
        this.minLevel = minLevel;
    }

    @Override
    public final boolean isLoggable(MessageReporter.Level level) {
        return this.minLevel != null && this.minLevel.compareTo(level) >= 0 && this.isLoggableImpl(level);
    }

    protected boolean isLoggableImpl(MessageReporter.Level level) {
        return true;
    }

    @Override
    public void logEx(MessageReporter.Level level, String message, Object[] formatArgs, Throwable error) {
        if (this.isLoggable(level)) {
            message = MessageFormat.format(message, formatArgs);
            String errorMessage = error.getMessage();
            if (errorMessage == null) {
                errorMessage = error.getClass().getSimpleName();
            }
            errorMessage = StringUtil.quoteMessageFormat(errorMessage);
            this.log(level, message + ": " + errorMessage, new Object[0]);
            if (this.isLoggable(MessageReporter.Level.DEBUG)) {
                String stackTrace = StringUtil.quoteMessageFormat(ExceptionUtils.getStackTrace((Throwable)error));
                this.log(MessageReporter.Level.DEBUG, stackTrace, new Object[0]);
            }
        }
    }

    @Override
    public final void log(MessageReporter.Level level, String message, Object ... formatArgs) {
        if (level == MessageReporter.Level.ERROR) {
            ++this.numErrors;
        }
        if (this.isLoggable(level)) {
            this.logImpl(level, message, formatArgs);
        }
    }

    protected abstract void logImpl(MessageReporter.Level var1, String var2, Object[] var3);

    @Override
    public void trace(String message, Object ... formatArgs) {
        this.log(MessageReporter.Level.TRACE, message, formatArgs);
    }

    @Override
    public void info(String message, Object ... formatArgs) {
        this.log(MessageReporter.Level.INFO, message, formatArgs);
    }

    @Override
    public void warn(String message, Object ... formatArgs) {
        this.log(MessageReporter.Level.WARN, message, formatArgs);
    }

    @Override
    public final void warnEx(String message, Throwable error) {
        this.warnEx(message, new Object[0], error);
    }

    @Override
    public void warnEx(String message, Object[] formatArgs, Throwable error) {
        this.logEx(MessageReporter.Level.WARN, message, formatArgs, error);
    }

    @Override
    public void error(String message, Object ... formatArgs) {
        this.log(MessageReporter.Level.ERROR, message, formatArgs);
    }

    @Override
    public final void errorEx(String message, Throwable error) {
        this.errorEx(message, new Object[0], error);
    }

    @Override
    public void errorEx(String message, Object[] formatArgs, Throwable error) {
        this.logEx(MessageReporter.Level.ERROR, message, formatArgs, error);
    }

    @Override
    public int numErrors() {
        return this.numErrors;
    }
}

