/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.visitor;

import apex.common.base.Result;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.compilation.UserInterface;
import apex.jorje.semantic.exception.Errors;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.method.StandardMethodTable;
import apex.jorje.semantic.symbol.type.TypeInfo;

class InterfaceHierarchyValidator {
    private static final InterfaceHierarchyValidator INSTANCE = new InterfaceHierarchyValidator();

    private InterfaceHierarchyValidator() {
    }

    static InterfaceHierarchyValidator get() {
        return INSTANCE;
    }

    void validate(UserInterface node, Errors errors) {
        TypeInfo interfaceType = node.getDefiningType();
        StandardMethodTable implementedMethods = new StandardMethodTable();
        for (MethodInfo method : interfaceType.methods().all()) {
            implementedMethods.addDuplicatesAllowed(method);
        }
        interfaceType.parents().allInterfaces().forEach(parentInterface -> parentInterface.methods().all().forEach(parentInterfaceMethod -> {
            Result<Void> result = implementedMethods.addDuplicatesAllowed((MethodInfo)parentInterfaceMethod);
            if (result.hasError()) {
                errors.markInvalid((AstNode)node, result.getError());
            }
        }));
    }
}

