/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.statement;

import apex.jorje.data.Location;
import apex.jorje.data.ast.Stmnt;
import apex.jorje.data.soql.FieldIdentifier;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.AstNodes;
import apex.jorje.semantic.ast.ProfilingType;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.statement.Statement;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.bcl.DatabaseEmitMethods;
import apex.jorje.semantic.bcl.DmlOperation;
import apex.jorje.semantic.compiler.Namespace;
import apex.jorje.semantic.symbol.member.variable.FieldInfo;
import apex.jorje.semantic.symbol.member.variable.FieldTable;
import apex.jorje.semantic.symbol.member.variable.SObjectFieldInfo;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.BasicType;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.common.CollectionTypeInfoUtil;
import apex.jorje.semantic.symbol.type.common.SObjectTypeInfoUtil;
import apex.jorje.semantic.symbol.type.common.TypeInfoUtil;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.printers.PrintContexts;
import apex.jorje.services.printers.PrinterUtil;
import java.util.Optional;

public class DmlUpsertStatement
extends Statement {
    private static final DmlOperation OP = DmlOperation.UPSERT;
    private final Location loc;
    private final Expression expression;
    private final Optional<FieldIdentifier> fieldIdentifier;
    private Optional<FieldInfo> fieldIdentifierFieldInfo;

    public DmlUpsertStatement(AstNode definingNode, Stmnt.DmlUpsertStmnt x) {
        super(definingNode);
        this.loc = x.loc;
        this.expression = AstNodes.get().create((AstNode)this, x.expr);
        this.fieldIdentifier = x.id;
        this.fieldIdentifierFieldInfo = Optional.empty();
    }

    private static String buildFieldName(SObjectFieldInfo field) {
        if (Namespace.isEmptyOrNull(field.getNamespace())) {
            return field.getName();
        }
        return SObjectTypeInfoUtil.isQualifiedField(field.getNamespace(), field.getName()) ? field.getName() : field.getNamespace() + "__" + field.getName();
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        if (visitor.visit(this, scope)) {
            this.expression.traverse(visitor, scope);
        }
        visitor.visitEnd(this, scope);
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        this.expression.validate(symbols, scope);
        if (scope.getErrors().isInvalid(this.expression)) {
            scope.getErrors().markInvalid(this);
            return;
        }
        TypeInfo typeToCheck = TypeInfoUtil.peelType(this.expression.getType());
        if (typeToCheck.getBasicType() != BasicType.SOBJECT) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.dml.type", this.expression.getType()));
            return;
        }
        if (!SObjectTypeInfoUtil.isDmlOperationAllowedStatically(this.getDefiningType(), DmlOperation.UPSERT, typeToCheck)) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("dml.operation.not.allowed", DmlOperation.UPSERT.getApexName(), this.expression.getType()));
            return;
        }
        this.fieldIdentifier.ifPresent(value -> {
            if (!SObjectTypeInfoUtil.isConcreteSObject(typeToCheck)) {
                scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("upsert.requires.concrete.type"));
                return;
            }
            if (!SObjectTypeInfoUtil.isLookupField(typeToCheck, value.field.getValue(), this.getDefiningType())) {
                scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("upsert.invalid.field", PrinterUtil.get().getFactory().fieldIdentifierPrinter().print((FieldIdentifier)value, PrintContexts.empty())));
                return;
            }
            this.fieldIdentifierFieldInfo = Optional.of(typeToCheck.fields().get(symbols, this.getDefiningType(), value.field.getValue(), FieldTable.LookupMode.INSTANCE_VARIABLE));
        });
    }

    @Override
    public void emit(Emitter emitter) {
        emitter.emitStatementExecuted(this.loc, true, false);
        this.expression.emit(emitter);
        if (this.fieldIdentifierFieldInfo.isPresent()) {
            SObjectFieldInfo fieldInfo = (SObjectFieldInfo)this.fieldIdentifierFieldInfo.get();
            TypeInfo type = TypeInfoUtil.peelType(this.expression.getType());
            emitter.push(this.loc, type.getApexName());
            emitter.push(this.loc, DmlUpsertStatement.buildFieldName(fieldInfo));
            emitter.push(this.loc, fieldInfo.getNamespace().toString());
        } else {
            emitter.emit(this.loc, 1);
            emitter.emit(this.loc, 1);
            emitter.emit(this.loc, 1);
        }
        ProfilingType.DML.emit(emitter, this.loc, OP.getName(this.expression.getType()));
        emitter.emit(this.loc, CollectionTypeInfoUtil.isList(this.expression.getType()) ? DatabaseEmitMethods.DML_UPSERT_LIST : DatabaseEmitMethods.DML_UPSERT);
        emitter.emit(this.loc, 87);
    }

    @Override
    public Location getLoc() {
        return this.loc;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public Optional<FieldIdentifier> getFieldIdentifier() {
        return this.fieldIdentifier;
    }
}

