/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.workspace;

import apex.jorje.lsp.api.workspace.DependentCompilationTracker;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Singleton;

@Singleton
public class StandardDependentCompilationTracker
implements DependentCompilationTracker {
    final Map<String, Set<String>> dependents = Maps.newConcurrentMap();

    @Override
    public synchronized void addForIndexing(String documentUri, List<String> dependentUris) {
        if (this.dependents.containsKey(documentUri)) {
            this.dependents.get(documentUri).addAll(dependentUris);
        } else {
            this.dependents.put(documentUri, new HashSet<String>(dependentUris));
        }
    }

    @Override
    public synchronized List<String> removeForIndexing(String documentUri) {
        if (this.dependents.containsKey(documentUri)) {
            ImmutableList<String> dependentURIs = ImmutableList.copyOf((Collection)this.dependents.get(documentUri));
            this.dependents.remove(documentUri);
            return dependentURIs;
        }
        return ImmutableList.of();
    }
}

