/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.html.rule.bestpractices;

import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.html.ast.ASTHtmlElement;
import net.sourceforge.pmd.lang.html.rule.AbstractHtmlRule;

public class UnnecessaryTypeAttributeRule
extends AbstractHtmlRule {
    @Override
    public Object visit(ASTHtmlElement node, Object data) {
        if ("link".equalsIgnoreCase(node.getNodeName())) {
            this.checkLink(node, data);
        } else if ("script".equalsIgnoreCase(node.getNodeName())) {
            this.checkScript(node, data);
        }
        return super.visit(node, data);
    }

    private void checkScript(ASTHtmlElement node, Object data) {
        if (node.hasAttribute("type")) {
            this.addViolation(node, data);
        }
    }

    private void checkLink(ASTHtmlElement node, Object data) {
        String rel = node.getAttribute("rel");
        if (node.hasAttribute("type") && "stylesheet".equalsIgnoreCase(rel)) {
            this.addViolation(node, data);
        }
    }

    private void addViolation(ASTHtmlElement node, Object data) {
        RuleContext ctx = (RuleContext)data;
        ctx.addViolation((Node)node);
    }
}

