/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.renderers;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sourceforge.pmd.properties.StringProperty;
import net.sourceforge.pmd.renderers.XMLRenderer;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XSLTRenderer
extends XMLRenderer {
    public static final String NAME = "xslt";
    public static final StringProperty XSLT_FILENAME = new StringProperty("xsltFilename", "The XSLT file name.", null, 0.0f);
    private Transformer transformer;
    private String xsltFilename = "/pmd-nicerhtml.xsl";
    private Writer outputWriter;
    private StringWriter stringWriter;

    public XSLTRenderer() {
        this.setName(NAME);
        this.setDescription("XML with a XSL Transformation applied.");
        this.definePropertyDescriptor(XSLT_FILENAME);
    }

    @Override
    public String defaultFileExtension() {
        return "xsl";
    }

    @Override
    public void start() throws IOException {
        File file;
        String xsltFilenameProperty = this.getProperty(XSLT_FILENAME);
        if (xsltFilenameProperty != null && (file = new File(xsltFilenameProperty)).exists() && file.canRead()) {
            this.xsltFilename = xsltFilenameProperty;
        }
        this.outputWriter = this.getWriter();
        this.stringWriter = new StringWriter();
        this.setWriter(this.stringWriter);
        InputStream xslt = null;
        File file2 = new File(this.xsltFilename);
        xslt = file2.exists() && file2.canRead() ? Files.newInputStream(file2.toPath(), new OpenOption[0]) : this.getClass().getResourceAsStream(this.xsltFilename);
        if (xslt == null) {
            throw new FileNotFoundException("Can't find XSLT file: " + this.xsltFilename);
        }
        try (InputStream stream = xslt;){
            this.prepareTransformer(stream);
        }
        super.start();
    }

    private void prepareTransformer(InputStream xslt) {
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            StreamSource src = new StreamSource(xslt);
            this.transformer = factory.newTransformer(src);
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void end() throws IOException {
        super.end();
        Document doc = this.getDocument(this.stringWriter.toString());
        this.transform(doc);
    }

    private void transform(Document doc) {
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(this.outputWriter);
        try {
            this.transformer.transform(source, result);
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
    }

    private Document getDocument(String xml) {
        try {
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            return parser.parse(new InputSource(new StringReader(xml)));
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new RuntimeException(e);
        }
    }
}

