/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.bcl;

import apex.jorje.semantic.symbol.type.GenericTypeInfoFactory;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableSet;
import java.util.EnumSet;
import java.util.Set;

public enum DmlOperation {
    DELETE("deleteFromDML", InternalTypeInfos.DATABASE_DELETE_RESULT),
    INSERT("insertFromDML", InternalTypeInfos.DATABASE_SAVE_RESULT),
    MERGE("mergeFromDML", InternalTypeInfos.DATABASE_MERGE_RESULT),
    UNDELETE("undeleteFromDML", InternalTypeInfos.DATABASE_UNDELETE_RESULT),
    UPDATE("updateFromDML", InternalTypeInfos.DATABASE_SAVE_RESULT),
    UPSERT("upsertFromDML", InternalTypeInfos.DATABASE_UPSERT_RESULT),
    EDIT,
    LEAD_CONVERT,
    NONE;

    public static final Set<DmlOperation> ALL;
    public static final Set<DmlOperation> EMPTY;
    private final String function;
    private final TypeInfo type;
    private final TypeInfo listType;
    private final String apexName;

    private DmlOperation() {
        this.apexName = null;
        this.function = null;
        this.type = null;
        this.listType = null;
    }

    private DmlOperation(String function, TypeInfo type) {
        this.apexName = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.name());
        this.function = function;
        this.type = type;
        this.listType = GenericTypeInfoFactory.createList(type);
    }

    public String getApexName() {
        return this.apexName;
    }

    public String getName(TypeInfo type) {
        return this.apexName + ": " + type.getApexName();
    }

    public String getFunction() {
        return this.function;
    }

    public TypeInfo getType() {
        return this.type;
    }

    public TypeInfo getListType() {
        return this.listType;
    }

    static {
        ALL = ImmutableSet.copyOf(EnumSet.complementOf(EnumSet.of(NONE)));
        EMPTY = ImmutableSet.copyOf(EnumSet.noneOf(DmlOperation.class));
    }
}

