/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.modelica.resolver;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.pmd.lang.modelica.ast.ASTClassDefinition;
import net.sourceforge.pmd.lang.modelica.ast.InternalModelicaNodeApi;
import net.sourceforge.pmd.lang.modelica.ast.ModelicaClassSpecifierNode;
import net.sourceforge.pmd.lang.modelica.ast.ModelicaImportClause;
import net.sourceforge.pmd.lang.modelica.ast.Visibility;
import net.sourceforge.pmd.lang.modelica.resolver.AbstractModelicaDeclaration;
import net.sourceforge.pmd.lang.modelica.resolver.AbstractModelicaScope;
import net.sourceforge.pmd.lang.modelica.resolver.CompositeName;
import net.sourceforge.pmd.lang.modelica.resolver.ModelicaClassScope;
import net.sourceforge.pmd.lang.modelica.resolver.ModelicaClassSpecialization;
import net.sourceforge.pmd.lang.modelica.resolver.ModelicaClassType;
import net.sourceforge.pmd.lang.modelica.resolver.ModelicaComponentDeclaration;
import net.sourceforge.pmd.lang.modelica.resolver.ModelicaDeclaration;
import net.sourceforge.pmd.lang.modelica.resolver.ModelicaScope;
import net.sourceforge.pmd.lang.modelica.resolver.ModelicaType;
import net.sourceforge.pmd.lang.modelica.resolver.ResolutionContext;
import net.sourceforge.pmd.lang.modelica.resolver.ResolutionResult;
import net.sourceforge.pmd.lang.modelica.resolver.ResolutionState;
import net.sourceforge.pmd.lang.modelica.resolver.ResolvableEntity;
import net.sourceforge.pmd.lang.modelica.resolver.Watchdog;

class ModelicaClassDeclaration
extends AbstractModelicaDeclaration
implements ModelicaClassType {
    private ModelicaClassScope ownScope;
    private boolean encapsulated;
    private boolean partial;
    private ModelicaClassSpecialization specialization;
    private String simpleName;
    private final List<ModelicaImportClause> imports = new ArrayList<ModelicaImportClause>();
    private final List<CompositeName> extendedClasses = new ArrayList<CompositeName>();
    private List<ModelicaClassScope> resolvedExtends;

    ModelicaClassDeclaration(ASTClassDefinition node) {
        this.encapsulated = node.isEncapsulated();
        this.partial = node.isPartial();
        this.specialization = node.getSpecialization();
        ModelicaClassSpecifierNode classNode = node.getClassSpecifier();
        this.simpleName = classNode.getSimpleClassName();
        InternalModelicaNodeApi.populateExtendsAndImports(classNode, this);
    }

    void addImport(Visibility visibility, ModelicaImportClause clause) {
        this.imports.add(clause);
    }

    void addExtends(Visibility visibility, CompositeName extendedClass) {
        assert (this.resolvedExtends == null);
        this.extendedClasses.add(extendedClass);
    }

    private List<ModelicaClassScope> getResolvedExtends(ResolutionState lazyInitState) {
        if (this.resolvedExtends == null) {
            ResolutionContext ctx = lazyInitState.createContext();
            try {
                for (CompositeName name : this.extendedClasses) {
                    ctx.watchdogTick();
                    ((AbstractModelicaScope)this.ownScope.getParent()).resolveLexically(ctx, name);
                }
            }
            catch (Watchdog.CountdownException e) {
                ctx.markTtlExceeded();
            }
            this.resolvedExtends = new ArrayList<ModelicaClassScope>();
            for (ModelicaType decl : ctx.getTypes().getBestCandidates()) {
                if (!(decl instanceof ModelicaClassDeclaration)) continue;
                this.resolvedExtends.add(((ModelicaClassDeclaration)decl).getClassScope());
            }
        }
        return this.resolvedExtends;
    }

    @Override
    public <T extends ResolvableEntity> ResolutionResult<T> safeResolveComponent(Class<T> clazz, ResolutionState state, CompositeName name) {
        ResolutionContext result = state.createContext();
        try {
            this.lookupInInstanceScope(result, name);
        }
        catch (Watchdog.CountdownException e) {
            result.markTtlExceeded();
        }
        return result.get(clazz);
    }

    private ResolutionResult<ModelicaDeclaration> lookupImported(ResolutionState state, String firstName, boolean qualified) throws Watchdog.CountdownException {
        state.tick();
        ResolutionContext result = state.createContext();
        for (ModelicaImportClause importClause : this.imports) {
            ResolutionContext subResult = state.createContext();
            if (InternalModelicaNodeApi.isQualifiedImport(importClause) == qualified) {
                InternalModelicaNodeApi.resolveImportedSimpleName(importClause, subResult, firstName);
            }
            result.accumulate(subResult.getDeclaration());
        }
        return result.getDeclaration();
    }

    void lookupInInstanceScope(ResolutionContext result, CompositeName name) throws Watchdog.CountdownException {
        if (name.isEmpty()) {
            result.addCandidate(this);
            return;
        }
        String firstName = name.getHead();
        CompositeName furtherParts = name.getTail();
        result.watchdogTick();
        for (ModelicaDeclaration modelicaDeclaration : this.ownScope.getDirectlyDeclared(firstName)) {
            this.lookupInInstanceScopeFurtherParts(result, modelicaDeclaration, furtherParts);
        }
        result.markHidingPoint();
        for (ModelicaClassScope modelicaClassScope : this.getResolvedExtends(result.getState())) {
            for (ModelicaDeclaration inheritedDecl : modelicaClassScope.getDirectlyDeclared(firstName)) {
                this.lookupInInstanceScopeFurtherParts(result, inheritedDecl, furtherParts);
            }
        }
        result.markHidingPoint();
        ResolutionResult<ModelicaDeclaration> qualifiedImports = this.lookupImported(result.getState(), firstName, true);
        for (ModelicaDeclaration importedDecl : qualifiedImports.getBestCandidates()) {
            this.lookupInInstanceScopeFurtherParts(result, importedDecl, furtherParts);
        }
        result.markHidingPoint();
        for (ModelicaDeclaration importedDecl : qualifiedImports.getHiddenCandidates()) {
            this.lookupInInstanceScopeFurtherParts(result, importedDecl, furtherParts);
        }
        result.markHidingPoint();
        ResolutionResult<ModelicaDeclaration> resolutionResult = this.lookupImported(result.getState(), firstName, false);
        for (ModelicaDeclaration importedDecl : resolutionResult.getBestCandidates()) {
            this.lookupInInstanceScopeFurtherParts(result, importedDecl, furtherParts);
        }
        result.markHidingPoint();
        for (ModelicaDeclaration importedDecl : resolutionResult.getHiddenCandidates()) {
            this.lookupInInstanceScopeFurtherParts(result, importedDecl, furtherParts);
        }
    }

    private void lookupInInstanceScopeFurtherParts(ResolutionContext result, ModelicaDeclaration resolvedSimpleName, CompositeName furtherParts) throws Watchdog.CountdownException {
        result.watchdogTick();
        if (furtherParts.isEmpty()) {
            result.addCandidate(resolvedSimpleName);
            return;
        }
        if (resolvedSimpleName instanceof ModelicaComponentDeclaration) {
            ModelicaComponentDeclaration component = (ModelicaComponentDeclaration)resolvedSimpleName;
            if (result.getState().needRecurseInto(component)) {
                ResolutionResult<ModelicaType> componentTypes = component.getTypeCandidates();
                for (ModelicaType tpe : componentTypes.getBestCandidates()) {
                    if (!(tpe instanceof ModelicaClassDeclaration)) continue;
                    ((ModelicaClassDeclaration)tpe).lookupInInstanceScope(result, furtherParts);
                }
                result.markHidingPoint();
                for (ModelicaType tpe : componentTypes.getHiddenCandidates()) {
                    if (!(tpe instanceof ModelicaClassDeclaration)) continue;
                    ((ModelicaClassDeclaration)tpe).lookupInInstanceScope(result, furtherParts);
                }
            }
        } else if (resolvedSimpleName instanceof ModelicaClassDeclaration) {
            ModelicaClassDeclaration classDecl = (ModelicaClassDeclaration)resolvedSimpleName;
            classDecl.lookupInInstanceScope(result, furtherParts);
        } else {
            throw new IllegalArgumentException("Can recurse into class or component only");
        }
    }

    void setOwnScope(ModelicaClassScope scope) {
        this.ownScope = scope;
    }

    @Override
    public ModelicaClassSpecialization getSpecialization() {
        return this.specialization;
    }

    @Override
    public boolean isConnectorLike() {
        return this.specialization == ModelicaClassSpecialization.CONNECTOR || this.specialization == ModelicaClassSpecialization.EXPANDABLE_CONNECTOR;
    }

    @Override
    public boolean isEncapsulated() {
        return this.encapsulated;
    }

    @Override
    public boolean isPartial() {
        return this.partial;
    }

    @Override
    public ModelicaScope getContainingScope() {
        return this.ownScope.getParent();
    }

    @Override
    public ModelicaClassScope getClassScope() {
        return this.ownScope;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.encapsulated) {
            sb.append("encapsulated ");
        }
        if (this.partial) {
            sb.append("partial ");
        }
        sb.append(this.specialization.toString());
        sb.append(' ');
        sb.append(this.simpleName);
        return sb.toString();
    }

    @Override
    void resolveFurtherNameComponents(ResolutionContext result, CompositeName name) throws Watchdog.CountdownException {
        this.lookupInInstanceScope(result, name);
    }

    @Override
    public String getSimpleDeclarationName() {
        return this.simpleName;
    }

    @Override
    public String getSimpleTypeName() {
        return this.simpleName;
    }

    @Override
    public String getFullTypeName() {
        return this.ownScope.getFullyQualifiedClassName();
    }

    @Override
    public String getDescriptiveName() {
        return this.getFullTypeName();
    }
}

