/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.visitors.codeActions;

import apex.jorje.data.TypeRefBuilder;
import apex.jorje.lsp.impl.visitors.codeActions.MissingMethodScope;
import apex.jorje.semantic.ast.expression.ArrayLoadExpression;
import apex.jorje.semantic.ast.expression.BinaryExpression;
import apex.jorje.semantic.ast.expression.BooleanExpression;
import apex.jorje.semantic.ast.expression.CastExpression;
import apex.jorje.semantic.ast.expression.ClassRefExpression;
import apex.jorje.semantic.ast.expression.InstanceOfExpression;
import apex.jorje.semantic.ast.expression.JavaMethodCallExpression;
import apex.jorje.semantic.ast.expression.JavaVariableExpression;
import apex.jorje.semantic.ast.expression.LiteralExpression;
import apex.jorje.semantic.ast.expression.MethodCallExpression;
import apex.jorje.semantic.ast.expression.NewKeyValueObjectExpression;
import apex.jorje.semantic.ast.expression.NewListInitExpression;
import apex.jorje.semantic.ast.expression.NewListLiteralExpression;
import apex.jorje.semantic.ast.expression.NewMapInitExpression;
import apex.jorje.semantic.ast.expression.NewMapLiteralExpression;
import apex.jorje.semantic.ast.expression.NewObjectExpression;
import apex.jorje.semantic.ast.expression.NewSetInitExpression;
import apex.jorje.semantic.ast.expression.NewSetLiteralExpression;
import apex.jorje.semantic.ast.expression.ReferenceExpression;
import apex.jorje.semantic.ast.expression.SoqlExpression;
import apex.jorje.semantic.ast.expression.SoslExpression;
import apex.jorje.semantic.ast.expression.TernaryExpression;
import apex.jorje.semantic.ast.expression.TriggerVariableExpression;
import apex.jorje.semantic.ast.expression.VariableExpression;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.symbol.type.BasicType;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;

public class ParameterPlaceholderVisitor
extends AstVisitor<MissingMethodScope> {
    @Override
    public void visitEnd(ArrayLoadExpression node, MissingMethodScope scope) {
        this.setTypeRef(node.getType(), scope);
    }

    @Override
    public void visitEnd(BinaryExpression node, MissingMethodScope scope) {
        this.setTypeRef(node.getType(), scope);
    }

    @Override
    public void visitEnd(BooleanExpression node, MissingMethodScope scope) {
        this.setTypeRef(node.getType(), scope);
    }

    @Override
    public void visitEnd(CastExpression node, MissingMethodScope scope) {
        this.setTypeRef(node.getType(), scope);
    }

    @Override
    public void visitEnd(ClassRefExpression node, MissingMethodScope scope) {
        this.setTypeRef(node.getType(), scope);
    }

    @Override
    public void visitEnd(InstanceOfExpression node, MissingMethodScope scope) {
        this.setTypeRef(TypeInfos.BOOLEAN, scope);
    }

    @Override
    public void visitEnd(JavaMethodCallExpression node, MissingMethodScope scope) {
        this.setTypeRef(node.getType(), scope);
    }

    @Override
    public void visitEnd(JavaVariableExpression node, MissingMethodScope scope) {
        this.setTypeRef(node.getType(), scope);
    }

    @Override
    public void visitEnd(LiteralExpression node, MissingMethodScope scope) {
        String name;
        TypeInfo typeInfo = node.getType();
        if (typeInfo.getBasicType() == BasicType.STRING && (name = this.getSanitizedName(node.getLiteral().toString())) != null) {
            this.setTypeRef(typeInfo, scope, name);
            return;
        }
        this.setTypeRef(typeInfo, scope);
    }

    @Override
    public void visitEnd(MethodCallExpression node, MissingMethodScope scope) {
        String name = this.getSanitizedName(node.getMethodName());
        if (name != null) {
            this.setTypeRef(node.getType(), scope, name);
            return;
        }
        this.setTypeRef(node.getType(), scope);
    }

    @Override
    public void visitEnd(NewKeyValueObjectExpression node, MissingMethodScope scope) {
        this.setTypeRef(node.getType(), scope);
    }

    @Override
    public void visitEnd(NewListInitExpression node, MissingMethodScope scope) {
        this.setTypeRef(node.getType(), scope);
    }

    @Override
    public void visitEnd(NewListLiteralExpression node, MissingMethodScope scope) {
        this.setTypeRef(node.getType(), scope);
    }

    @Override
    public void visitEnd(NewMapInitExpression node, MissingMethodScope scope) {
        this.setTypeRef(node.getType(), scope);
    }

    @Override
    public void visitEnd(NewMapLiteralExpression node, MissingMethodScope scope) {
        this.setTypeRef(node.getType(), scope);
    }

    @Override
    public void visitEnd(NewObjectExpression node, MissingMethodScope scope) {
        this.setTypeRef(node.getType(), scope);
    }

    @Override
    public void visitEnd(NewSetInitExpression node, MissingMethodScope scope) {
        this.setTypeRef(node.getType(), scope);
    }

    @Override
    public void visitEnd(NewSetLiteralExpression node, MissingMethodScope scope) {
        this.setTypeRef(node.getType(), scope);
    }

    @Override
    public void visitEnd(ReferenceExpression node, MissingMethodScope scope) {
        this.setTypeRef(node.getType(), scope);
    }

    @Override
    public void visitEnd(SoqlExpression node, MissingMethodScope scope) {
        this.setTypeRef(node.getType(), scope);
    }

    @Override
    public void visitEnd(SoslExpression node, MissingMethodScope scope) {
        this.setTypeRef(node.getType(), scope);
    }

    @Override
    public void visitEnd(TernaryExpression node, MissingMethodScope scope) {
        this.setTypeRef(node.getType(), scope);
    }

    @Override
    public void visitEnd(TriggerVariableExpression node, MissingMethodScope scope) {
        this.setTypeRef(node.getType(), scope);
    }

    @Override
    public void visitEnd(VariableExpression node, MissingMethodScope scope) {
        this.setTypeRef(node.getType(), scope, node.getIdentifier().getValue());
    }

    private void setTypeRef(TypeInfo typeInfo, MissingMethodScope scope) {
        String name = typeInfo.getApexName();
        if (name.contains(".")) {
            String[] parts = name.split("\\.");
            name = parts[parts.length - 1];
        } else if (!typeInfo.isResolved()) {
            name = "o";
        }
        this.setTypeRef(typeInfo, scope, name.toLowerCase().substring(0, 1));
    }

    private void setTypeRef(TypeInfo typeInfo, MissingMethodScope scope, String placeholderName) {
        assert (typeInfo.isResolved()) : "Parameter type is not resolved";
        scope.addPlaceholder(TypeRefBuilder.withNames(typeInfo.getApexName().split("\\.")).build(), placeholderName);
    }

    private String getSanitizedName(String name) {
        if (name.matches("^[a-zA-Z][a-zA-Z0-9\\s]*$")) {
            return name.replaceAll("\\s", "_");
        }
        return null;
    }
}

