/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.completions;

import apex.jorje.lsp.api.completions.CompletionStrategy;
import apex.jorje.lsp.api.document.Document;
import apex.jorje.lsp.api.services.ApexCompilerService;
import apex.jorje.lsp.api.services.DocumentationService;
import apex.jorje.lsp.api.workspace.ApexDocumentService;
import apex.jorje.lsp.impl.completions.CompletionActivationFactory;
import apex.jorje.lsp.impl.completions.CompletionItemTransformer;
import apex.jorje.lsp.impl.document.BadLocationException;
import apex.jorje.lsp.impl.utils.Locations;
import apex.jorje.lsp.impl.utils.NamesCompletionStrategies;
import apex.jorje.semantic.common.TestAccessEvaluator;
import apex.jorje.semantic.symbol.member.Member;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.visibility.Visibility;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MethodNamesCompletionStrategy
implements CompletionStrategy {
    private static final Logger logger = LoggerFactory.getLogger(MethodNamesCompletionStrategy.class);
    private final ApexCompilerService compilerService;
    private final ApexDocumentService documentService;
    private final CompletionActivationFactory factory;
    private final DocumentationService documentation;

    @Inject
    public MethodNamesCompletionStrategy(ApexCompilerService compilerService, ApexDocumentService documentService, CompletionActivationFactory factory, DocumentationService documentation) {
        this.compilerService = compilerService;
        this.documentService = documentService;
        this.factory = factory;
        this.documentation = documentation;
    }

    @Override
    public List<CompletionItem> provideCompletions(TextDocumentPositionParams params) {
        return NamesCompletionStrategies.provideCompletions(params, this.documentService, this.compilerService, this.factory, new MethodProcessor(this.documentService.retrieve(URI.create(params.getTextDocument().getUri())), params.getPosition()));
    }

    private class MethodProcessor
    implements NamesCompletionStrategies.NameProcessor {
        private final Document doc;
        private final Position position;

        MethodProcessor(Optional<Document> doc, Position position) {
            this.position = position;
            this.doc = doc.orElse(null);
        }

        @Override
        public void processClass(TypeInfo compiledType, List<CompletionItem> items) {
            if (this.isVirtualMethodOverride().booleanValue()) {
                items.addAll(compiledType.virtualMethods().getInstance().stream().filter(m -> !NamesCompletionStrategies.isFilteredOutMethod(m, compiledType)).filter(NamesCompletionStrategies::isOverridableMethod).filter(m -> Visibility.isMemberVisibleThroughModifiers(new TestAccessEvaluator(), compiledType, m.getDefiningType(), m.getModifiers(), false)).map(m -> CompletionItemTransformer.transformMethodDeclaration(m, MethodNamesCompletionStrategy.this.documentation.getDocumentation((Member)m))).collect(Collectors.toList()));
            } else {
                items.addAll(compiledType.methods().getStatics().stream().filter(m -> !NamesCompletionStrategies.isFilteredOutMethod(m, compiledType)).map(m -> CompletionItemTransformer.transform(m, MethodNamesCompletionStrategy.this.documentation.getDocumentation((Member)m))).collect(Collectors.toList()));
                items.addAll(compiledType.virtualMethods().getInstance().stream().filter(m -> !NamesCompletionStrategies.isFilteredOutMethod(m, compiledType)).filter(m -> Visibility.isMemberVisibleThroughModifiers(new TestAccessEvaluator(), compiledType, m.getDefiningType(), m.getModifiers(), false)).map(m -> CompletionItemTransformer.transform(m, "05/", MethodNamesCompletionStrategy.this.documentation.getDocumentation((Member)m))).collect(Collectors.toList()));
            }
        }

        private Boolean isVirtualMethodOverride() {
            boolean isOverridable = false;
            if (this.doc != null && this.position != null) {
                try {
                    int endOffset = Locations.getOffset(this.doc, this.position);
                    int lineNumber = this.doc.getLineNumberOfOffset(endOffset);
                    int startOffset = this.doc.getLineOffset(lineNumber);
                    String lineText = this.doc.getSource().substring(startOffset, endOffset);
                    isOverridable = lineText.matches("^\\s*([a-z]+)\\s+override $");
                }
                catch (BadLocationException e) {
                    logger.error("Encountered a bad location while building method autocompletions.", (Throwable)e);
                }
            }
            return isOverridable;
        }
    }
}

