/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.codestyle;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import net.sourceforge.pmd.lang.java.ast.ASTAnnotationTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTAnyTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTEnumDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclarator;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.ast.AccessNode;
import net.sourceforge.pmd.lang.java.ast.Annotatable;
import net.sourceforge.pmd.lang.java.ast.Comment;
import net.sourceforge.pmd.lang.java.rule.AbstractIgnoredAnnotationRule;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;

public class CommentDefaultAccessModifierRule
extends AbstractIgnoredAnnotationRule {
    private static final PropertyDescriptor<Pattern> REGEX_DESCRIPTOR = ((PropertyBuilder.RegexPropertyBuilder)PropertyFactory.regexProperty((String)"regex").desc("Regular expression")).defaultValue("\\/\\*\\s+(default|package)\\s+\\*\\/").build();
    private static final PropertyDescriptor<Boolean> TOP_LEVEL_TYPES = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"checkTopLevelTypes").desc("Check for default access modifier in top-level classes, annotations, and enums")).defaultValue((Object)false)).build();
    private static final String MESSAGE = "To avoid mistakes add a comment at the beginning of the %s %s if you want a default access modifier";
    private final Set<Integer> interestingLineNumberComments = new HashSet<Integer>();

    public CommentDefaultAccessModifierRule() {
        this.definePropertyDescriptor(REGEX_DESCRIPTOR);
        this.definePropertyDescriptor(TOP_LEVEL_TYPES);
    }

    @Override
    protected Collection<String> defaultSuppressionAnnotations() {
        ArrayList<String> ignoredStrings = new ArrayList<String>();
        ignoredStrings.add("com.google.common.annotations.VisibleForTesting");
        ignoredStrings.add("android.support.annotation.VisibleForTesting");
        return ignoredStrings;
    }

    @Override
    public Object visit(ASTCompilationUnit node, Object data) {
        this.interestingLineNumberComments.clear();
        List<Comment> comments = node.getComments();
        for (Comment comment : comments) {
            if (!((Pattern)this.getProperty(REGEX_DESCRIPTOR)).matcher(comment.getImage()).matches()) continue;
            this.interestingLineNumberComments.add(comment.getBeginLine());
        }
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTMethodDeclaration decl, Object data) {
        if (this.shouldReport(decl)) {
            this.addViolationWithMessage(data, decl, String.format(MESSAGE, ((ASTMethodDeclarator)decl.getFirstChildOfType(ASTMethodDeclarator.class)).getImage(), "method"));
        }
        return super.visit(decl, data);
    }

    @Override
    public Object visit(ASTFieldDeclaration decl, Object data) {
        if (this.shouldReport(decl)) {
            this.addViolationWithMessage(data, decl, String.format(MESSAGE, ((ASTVariableDeclaratorId)decl.getFirstDescendantOfType(ASTVariableDeclaratorId.class)).getImage(), "field"));
        }
        return super.visit(decl, data);
    }

    @Override
    public Object visit(ASTAnnotationTypeDeclaration decl, Object data) {
        if (!decl.isNested() && this.shouldReportTypeDeclaration(decl)) {
            this.addViolationWithMessage(data, decl, String.format(MESSAGE, decl.getImage(), "top-level annotation"));
        }
        return super.visit(decl, data);
    }

    @Override
    public Object visit(ASTEnumDeclaration decl, Object data) {
        if (!decl.isNested() && this.shouldReportTypeDeclaration(decl)) {
            this.addViolationWithMessage(data, decl, String.format(MESSAGE, decl.getImage(), "top-level enum"));
        }
        return super.visit(decl, data);
    }

    @Override
    public Object visit(ASTClassOrInterfaceDeclaration decl, Object data) {
        if (decl.isNested() && this.shouldReport(decl)) {
            this.addViolationWithMessage(data, decl, String.format(MESSAGE, decl.getImage(), "nested class"));
        } else if (!decl.isNested() && this.shouldReportTypeDeclaration(decl)) {
            this.addViolationWithMessage(data, decl, String.format(MESSAGE, decl.getImage(), "top-level class"));
        }
        return super.visit(decl, data);
    }

    @Override
    public Object visit(ASTConstructorDeclaration decl, Object data) {
        if (this.shouldReport(decl)) {
            this.addViolationWithMessage(data, decl, String.format(MESSAGE, decl.getImage(), "constructor"));
        }
        return super.visit(decl, data);
    }

    private boolean shouldReport(AccessNode decl) {
        ASTAnyTypeDeclaration parentClassOrInterface = (ASTAnyTypeDeclaration)decl.getFirstParentOfType(ASTAnyTypeDeclaration.class);
        boolean isConcreteClass = parentClassOrInterface.getTypeKind() == ASTAnyTypeDeclaration.TypeKind.CLASS;
        return isConcreteClass && this.isMissingComment(decl);
    }

    protected boolean hasIgnoredAnnotation(AccessNode node) {
        if (node instanceof Annotatable) {
            return this.hasIgnoredAnnotation((Annotatable)((Object)node));
        }
        return false;
    }

    private boolean isMissingComment(AccessNode decl) {
        return decl.isPackagePrivate() && !this.interestingLineNumberComments.contains(decl.getBeginLine()) && !this.hasIgnoredAnnotation(decl);
    }

    private boolean shouldReportTypeDeclaration(ASTAnyTypeDeclaration decl) {
        return decl.getTypeKind() != ASTAnyTypeDeclaration.TypeKind.INTERFACE && this.isMissingComment(decl) && (decl.isNested() || (Boolean)this.getProperty(TOP_LEVEL_TYPES) != false);
    }
}

