/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.statement;

import apex.jorje.data.Identifier;
import apex.jorje.data.Location;
import apex.jorje.data.Locations;
import apex.jorje.data.ast.TypeRef;
import apex.jorje.data.ast.WhenBlock;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.AstNodes;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.ast.statement.Statement;
import apex.jorje.semantic.ast.statement.SwitchStatement;
import apex.jorje.semantic.ast.statement.WhenBlock;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.bcl.SystemEmitMethods;
import apex.jorje.semantic.exception.Errors;
import apex.jorje.semantic.symbol.member.variable.LocalInfo;
import apex.jorje.semantic.symbol.member.variable.LocalVariableScope;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.UnresolvedErrorCalculator;
import apex.jorje.semantic.symbol.type.naming.TypeEraser;
import org.objectweb.asm.Label;

public class TypeWhenBlock
implements WhenBlock {
    private final TypeRef typeRef;
    private final Identifier name;
    private final Statement statement;
    private final Location loc;
    private final LocalVariableScope locals;
    private final SwitchStatement switchStatement;
    private TypeInfo type;
    private LocalInfo variable;

    TypeWhenBlock(SwitchStatement switchStatement, WhenBlock.TypeWhen type) {
        this.switchStatement = switchStatement;
        this.typeRef = type.typeRef;
        this.name = type.name;
        this.statement = AstNodes.get().create((AstNode)switchStatement, type.stmnt);
        this.loc = Locations.from(this.name);
        this.locals = new LocalVariableScope();
    }

    public LocalVariableScope getLocals() {
        return this.locals;
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        if (visitor.visit(this, scope)) {
            this.statement.traverse(visitor, scope);
        }
        visitor.visitEnd(this, scope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        scope.push(this);
        try {
            Errors errors = scope.getErrors();
            this.type = symbols.lookupTypeInfo(this.getDefiningType(), this.typeRef);
            if (!this.type.isResolved()) {
                errors.markInvalid((AstNode)this, UnresolvedErrorCalculator.getErrors(this.type));
                return;
            }
            ModifierGroup modifiers = ModifierGroup.builder().setLoc(this.name.getLoc()).addModifiers(ModifierTypeInfos.EXPLICIT_STATEMENT_EXECUTED).build();
            this.variable = LocalInfo.builder().setName(this.name).setDefiningType(this.getDefiningType()).setType(this.type).setModifiers(modifiers).build();
            scope.getErrors().addIfError((AstNode)this, this.name.getLoc(), scope.getSymbols().variables().add(this.variable));
            this.statement.validate(symbols, scope);
            if (errors.isInvalid(this.statement)) {
                errors.markInvalid(this);
            }
        }
        finally {
            scope.pop(this);
        }
    }

    @Override
    public void emit(Emitter emitter) {
        Label falseLabel = new Label();
        emitter.emitVar(this.loc, 25, this.switchStatement.getVarIndex());
        emitter.emit(this.loc, 89);
        emitter.push(this.loc, TypeEraser.eraseBytecodeName(this.type));
        emitter.emit(this.loc, SystemEmitMethods.INSTANCE_OF);
        emitter.unbox(TypeInfos.BOOLEAN);
        emitter.emitJump(this.loc, 153, falseLabel);
        emitter.emitVar(this.loc, 58, this.variable.getPosition(emitter));
        this.statement.emit(emitter);
        if (!this.statement.isReturnable()) {
            emitter.emitJump(this.switchStatement.getLoc(), 167, this.switchStatement.getExit());
        }
        emitter.emit(falseLabel);
        emitter.emit(this.loc, 87);
    }

    @Override
    public TypeInfo getDefiningType() {
        return this.switchStatement.getDefiningType();
    }

    @Override
    public Location getLoc() {
        return this.name.getLoc();
    }

    public TypeInfo getType() {
        return this.type;
    }

    @Override
    public Statement getBlock() {
        return this.statement;
    }

    public TypeRef getTypeRef() {
        return this.typeRef;
    }

    public LocalInfo getVariable() {
        return this.variable;
    }
}

