/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang;

import java.util.Locale;
import java.util.Objects;
import net.sourceforge.pmd.properties.AbstractPropertySource;
import net.sourceforge.pmd.properties.PropertyDescriptor;

public class ParserOptions {
    @Deprecated
    protected String suppressMarker;
    private final String languageId;
    private final ParserOptionsProperties parserOptionsProperties;

    public ParserOptions() {
        this.languageId = null;
        this.parserOptionsProperties = new ParserOptionsProperties();
    }

    public ParserOptions(String languageId) {
        this.languageId = Objects.requireNonNull(languageId);
        this.parserOptionsProperties = new ParserOptionsProperties();
    }

    public String getSuppressMarker() {
        return this.suppressMarker;
    }

    public void setSuppressMarker(String suppressMarker) {
        this.suppressMarker = suppressMarker;
    }

    protected final void defineProperty(PropertyDescriptor<?> propertyDescriptor) {
        this.parserOptionsProperties.definePropertyDescriptor(propertyDescriptor);
    }

    protected final <T> void defineProperty(PropertyDescriptor<T> propertyDescriptor, T initialValue) {
        this.defineProperty(propertyDescriptor);
        this.setProperty(propertyDescriptor, initialValue);
    }

    protected final <T> void setProperty(PropertyDescriptor<T> propertyDescriptor, T initialValue) {
        this.parserOptionsProperties.setProperty(propertyDescriptor, initialValue);
    }

    public final <T> T getProperty(PropertyDescriptor<T> propertyDescriptor) {
        return this.parserOptionsProperties.getProperty(propertyDescriptor);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ParserOptions that = (ParserOptions)obj;
        return Objects.equals(this.suppressMarker, that.suppressMarker) && Objects.equals(this.languageId, that.languageId) && Objects.equals(this.parserOptionsProperties, that.parserOptionsProperties);
    }

    public int hashCode() {
        return Objects.hash(this.suppressMarker, this.languageId, this.parserOptionsProperties);
    }

    String getEnvironmentVariableName(PropertyDescriptor<?> propertyDescriptor) {
        if (this.languageId == null) {
            throw new IllegalStateException("Language is null");
        }
        return "PMD_" + this.languageId.toUpperCase(Locale.ROOT) + "_" + propertyDescriptor.name().toUpperCase(Locale.ROOT);
    }

    String getEnvValue(PropertyDescriptor<?> propertyDescriptor) {
        return System.getenv(this.getEnvironmentVariableName(propertyDescriptor));
    }

    protected final void overridePropertiesFromEnv() {
        for (PropertyDescriptor<?> propertyDescriptor : this.parserOptionsProperties.getPropertyDescriptors()) {
            String propertyValue = this.getEnvValue(propertyDescriptor);
            if (propertyValue == null) continue;
            this.setPropertyCapture(propertyDescriptor, propertyValue);
        }
    }

    private <T> void setPropertyCapture(PropertyDescriptor<T> propertyDescriptor, String propertyValue) {
        T value = propertyDescriptor.valueFrom(propertyValue);
        this.parserOptionsProperties.setProperty(propertyDescriptor, value);
    }

    private final class ParserOptionsProperties
    extends AbstractPropertySource {
        private ParserOptionsProperties() {
        }

        @Override
        protected String getPropertySourceType() {
            return "ParserOptions";
        }

        @Override
        public String getName() {
            return ParserOptions.this.getClass().getSimpleName();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ParserOptionsProperties)) {
                return false;
            }
            ParserOptionsProperties that = (ParserOptionsProperties)obj;
            return Objects.equals(this.getPropertiesByPropertyDescriptor(), that.getPropertiesByPropertyDescriptor());
        }

        public int hashCode() {
            return this.getPropertiesByPropertyDescriptor().hashCode();
        }
    }
}

