/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class TokenEntry
implements Comparable<TokenEntry> {
    public static final TokenEntry EOF = new TokenEntry();
    private String tokenSrcID;
    private final int beginLine;
    private final int beginColumn;
    private final int endColumn;
    private int index;
    private int identifier;
    private int hashCode;
    private static final ThreadLocal<Map<String, Integer>> TOKENS = new ThreadLocal<Map<String, Integer>>(){

        @Override
        protected Map<String, Integer> initialValue() {
            return new HashMap<String, Integer>();
        }
    };
    private static final ThreadLocal<AtomicInteger> TOKEN_COUNT = new ThreadLocal<AtomicInteger>(){

        @Override
        protected AtomicInteger initialValue() {
            return new AtomicInteger(0);
        }
    };

    private TokenEntry() {
        this.identifier = 0;
        this.tokenSrcID = "EOFMarker";
        this.beginLine = -1;
        this.beginColumn = -1;
        this.endColumn = -1;
    }

    @Deprecated
    public TokenEntry(String image, String tokenSrcID, int beginLine) {
        this(image, tokenSrcID, beginLine, -1, -1);
    }

    public TokenEntry(String image, String tokenSrcID, int beginLine, int beginColumn, int endColumn) {
        assert (this.isOk(beginLine) && this.isOk(beginColumn) && this.isOk(endColumn)) : "Coordinates are 1-based";
        this.setImage(image);
        this.tokenSrcID = tokenSrcID;
        this.beginLine = beginLine;
        this.beginColumn = beginColumn;
        this.endColumn = endColumn;
        this.index = TOKEN_COUNT.get().getAndIncrement();
    }

    private boolean isOk(int coord) {
        return coord >= 1 || coord == -1;
    }

    public static TokenEntry getEOF() {
        TOKEN_COUNT.get().getAndIncrement();
        return EOF;
    }

    public static void clearImages() {
        TOKENS.get().clear();
        TOKENS.remove();
        TOKEN_COUNT.remove();
    }

    public String getTokenSrcID() {
        return this.tokenSrcID;
    }

    public int getBeginLine() {
        return this.beginLine;
    }

    public int getBeginColumn() {
        return this.beginColumn;
    }

    public int getEndColumn() {
        return this.endColumn;
    }

    public int getIdentifier() {
        return this.identifier;
    }

    public int getIndex() {
        return this.index;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public void setHashCode(int hashCode) {
        this.hashCode = hashCode;
    }

    public boolean equals(Object o) {
        if (this == EOF) {
            return o == EOF;
        }
        if (o == EOF) {
            return this == EOF;
        }
        if (!(o instanceof TokenEntry)) {
            return false;
        }
        TokenEntry other = (TokenEntry)o;
        return other.hashCode == this.hashCode;
    }

    @Override
    public int compareTo(TokenEntry other) {
        return this.getIndex() - other.getIndex();
    }

    public String toString() {
        if (EOF.equals(this)) {
            return "EOF";
        }
        for (Map.Entry<String, Integer> e : TOKENS.get().entrySet()) {
            if (e.getValue() != this.identifier) continue;
            return e.getKey();
        }
        return "--unknown--";
    }

    final void setImage(String image) {
        Integer i = TOKENS.get().get(image);
        if (i == null) {
            i = TOKENS.get().size() + 1;
            TOKENS.get().put(image, i);
        }
        this.identifier = i;
    }

    public static class State {
        private int tokenCount = ((AtomicInteger)TokenEntry.access$000().get()).intValue();
        private Map<String, Integer> tokens = new HashMap<String, Integer>((Map)TokenEntry.access$100().get());
        private List<TokenEntry> entries;

        public State(List<TokenEntry> entries) {
            this.entries = new ArrayList<TokenEntry>(entries);
        }

        public List<TokenEntry> restore() {
            ((AtomicInteger)TOKEN_COUNT.get()).set(this.tokenCount);
            ((Map)TOKENS.get()).clear();
            ((Map)TOKENS.get()).putAll(this.tokens);
            return this.entries;
        }
    }
}

