/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang;

import net.sourceforge.pmd.annotation.InternalApi;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.LanguageVersionHandler;

public class LanguageVersion
implements Comparable<LanguageVersion> {
    private final Language language;
    private final String version;
    private final LanguageVersionHandler languageVersionHandler;

    @Deprecated
    @InternalApi
    public LanguageVersion(Language language, String version, LanguageVersionHandler languageVersionHandler) {
        this.language = language;
        this.version = version;
        this.languageVersionHandler = languageVersionHandler;
    }

    public Language getLanguage() {
        return this.language;
    }

    public String getVersion() {
        return this.version;
    }

    public LanguageVersionHandler getLanguageVersionHandler() {
        return this.languageVersionHandler;
    }

    public String getName() {
        return this.version.length() > 0 ? this.language.getName() + ' ' + this.version : this.language.getName();
    }

    public String getShortName() {
        return this.version.length() > 0 ? this.language.getShortName() + ' ' + this.version : this.language.getShortName();
    }

    public String getTerseName() {
        return this.version.length() > 0 ? this.language.getTerseName() + ' ' + this.version : this.language.getTerseName();
    }

    @Override
    public int compareTo(LanguageVersion o) {
        int i;
        if (o == null) {
            return 1;
        }
        int comp = this.getName().compareTo(o.getName());
        if (comp != 0) {
            return comp;
        }
        String[] vals1 = this.getName().split("\\.");
        String[] vals2 = o.getName().split("\\.");
        for (i = 0; i < vals1.length && i < vals2.length && vals1[i].equals(vals2[i]); ++i) {
        }
        if (i < vals1.length && i < vals2.length) {
            int diff = Integer.valueOf(vals1[i]).compareTo(Integer.valueOf(vals2[i]));
            return Integer.signum(diff);
        }
        return Integer.signum(vals1.length - vals2.length);
    }

    public String toString() {
        return this.language.toString() + "+version:" + this.version;
    }
}

