/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.codeActions;

import apex.jorje.lsp.api.codeActions.CodeActionsProvider;
import apex.jorje.lsp.api.document.Document;
import apex.jorje.lsp.api.services.ApexCompilerService;
import apex.jorje.lsp.api.visitors.VisitorFactory;
import apex.jorje.lsp.api.workspace.ApexDocumentService;
import apex.jorje.lsp.impl.document.BadLocationException;
import apex.jorje.lsp.impl.telemetry.TelemetryData;
import apex.jorje.semantic.ast.compilation.Compilation;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import com.google.common.base.Stopwatch;
import com.google.inject.Inject;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.jsonrpc.validation.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseCodeActionsProvider
implements CodeActionsProvider {
    protected final VisitorFactory visitorFactory;
    protected final ApexDocumentService docService;
    protected final ApexCompilerService compilerService;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Inject
    public BaseCodeActionsProvider(ApexCompilerService compilerService, ApexDocumentService docService, VisitorFactory visitorFactory) {
        this.compilerService = compilerService;
        this.docService = docService;
        this.visitorFactory = visitorFactory;
    }

    @Override
    public final List<Either<Command, CodeAction>> provideCodeActions(CodeActionParams codeActionParams, TelemetryData telemetryData) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        ArrayList<Either<Command, CodeAction>> codeActions = new ArrayList<Either<Command, CodeAction>>();
        URI docUri = URI.create(codeActionParams.getTextDocument().getUri());
        Optional<Document> optDoc = this.docService.retrieve(docUri);
        optDoc.ifPresent(doc -> {
            try {
                codeActions.addAll(this.getCodeActions((Document)doc, codeActionParams.getRange(), telemetryData));
            }
            catch (BadLocationException exception) {
                this.logger.error("Encountered a bad location while getting code actions", (Throwable)exception);
            }
        });
        this.printTime(codeActionParams, stopwatch);
        return codeActions;
    }

    protected final void compileAndTraverse(Document doc, AstVisitor visitor, Scope scope) {
        Compilation codeUnitNode = this.compilerService.compile(doc).getNode();
        codeUnitNode.traverse(visitor, scope);
    }

    protected abstract List<Either<Command, CodeAction>> getCodeActions(Document var1, Range var2, TelemetryData var3) throws BadLocationException;

    private void printTime(@NonNull CodeActionParams params, @NonNull Stopwatch stopwatch) {
        stopwatch.stop();
        this.logger.info("CodeActions for {} took {} ms.", (Object)params.getTextDocument().getUri(), (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
    }
}

