/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.codestyle;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTImportDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTPackageDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.lang.java.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.lang.java.ast.Comment;
import net.sourceforge.pmd.lang.java.ast.FormalComment;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.ast.internal.ImportWrapper;
import net.sourceforge.pmd.lang.java.ast.internal.PrettyPrintingUtil;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import org.apache.commons.lang3.tuple.Pair;

public class UnnecessaryImportRule
extends AbstractJavaRule {
    private static final String UNUSED_IMPORT_MESSAGE = "Unused import ''{0}''";
    private static final String DUPLICATE_IMPORT_MESSAGE = "Duplicate import ''{0}''";
    private static final String IMPORT_FROM_SAME_PACKAGE_MESSAGE = "Unnecessary import from the current package ''{0}''";
    private static final String IMPORT_FROM_JAVA_LANG_MESSAGE = "Unnecessary import from the java.lang package ''{0}''";
    private final Set<ImportWrapper> imports = new HashSet<ImportWrapper>();
    private String thisPackageName;
    private static final Pattern SEE_PATTERN = Pattern.compile("@see\\s+((?:\\p{Alpha}\\w*\\.)*(?:\\p{Alpha}\\w*))?(?:#\\w*(?:\\(([.\\w\\s,\\[\\]]*)\\))?)?");
    private static final Pattern LINK_PATTERNS = Pattern.compile("\\{@link(?:plain)?\\s+((?:\\p{Alpha}\\w*\\.)*(?:\\p{Alpha}\\w*))?(?:#\\w*(?:\\(([.\\w\\s,\\[\\]]*)\\))?)?[\\s\\}]");
    private static final Pattern VALUE_PATTERN = Pattern.compile("\\{@value\\s+(\\p{Alpha}\\w*)[\\s#\\}]");
    private static final Pattern THROWS_PATTERN = Pattern.compile("@throws\\s+(\\p{Alpha}\\w*)");
    private static final Pattern[] PATTERNS = new Pattern[]{SEE_PATTERN, LINK_PATTERNS, VALUE_PATTERN, THROWS_PATTERN};

    protected boolean justReportUnusedImports() {
        return false;
    }

    @Override
    public Object visit(ASTCompilationUnit node, Object data) {
        this.imports.clear();
        this.thisPackageName = node.getPackageName();
        super.visit(node, data);
        this.visitComments(node);
        if (node.getNumChildren() > 0 && node.getChild(0) instanceof ASTPackageDeclaration) {
            this.visit((ASTPackageDeclaration)node.getChild(0), data);
        }
        for (ImportWrapper wrapper : this.imports) {
            this.reportWithMessage(wrapper.getNode(), data, UNUSED_IMPORT_MESSAGE);
        }
        return data;
    }

    private void visitComments(ASTCompilationUnit node) {
        if (this.imports.isEmpty()) {
            return;
        }
        for (Comment comment : node.getComments()) {
            if (!(comment instanceof FormalComment)) continue;
            for (Pattern p : PATTERNS) {
                Matcher m = p.matcher(comment.getImage());
                while (m.find()) {
                    String fullname = m.group(1);
                    if (fullname != null) {
                        this.removeReferenceSingleImport(fullname);
                    }
                    if (m.groupCount() > 1 && (fullname = m.group(2)) != null) {
                        for (String param : fullname.split("\\s*,\\s*")) {
                            this.removeReferenceSingleImport(param);
                        }
                    }
                    if (!this.imports.isEmpty()) continue;
                    return;
                }
            }
        }
    }

    @Override
    public Object visit(ASTImportDeclaration node, Object data) {
        if (this.thisPackageName.equals(node.getPackageName()) && !this.justReportUnusedImports()) {
            this.reportWithMessage(node, data, IMPORT_FROM_SAME_PACKAGE_MESSAGE);
        } else if (!this.imports.add(new ImportWrapper(node)) && !this.justReportUnusedImports()) {
            this.reportWithMessage(node, data, DUPLICATE_IMPORT_MESSAGE);
        }
        return data;
    }

    private void reportWithMessage(ASTImportDeclaration node, Object data, String message) {
        this.addViolationWithMessage(data, (Node)node, message, new String[]{PrettyPrintingUtil.prettyImport(node)});
    }

    @Override
    public Object visit(ASTClassOrInterfaceType node, Object data) {
        this.check(node, (RuleContext)data);
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTName node, Object data) {
        this.check(node, (RuleContext)data);
        return data;
    }

    protected void check(JavaNode referenceNode, RuleContext ruleCtx) {
        Class<?> c;
        ImportWrapper i;
        if (this.imports.isEmpty()) {
            return;
        }
        Pair<String, String> candidate = this.splitName((Node)referenceNode);
        String candFullName = (String)candidate.getLeft();
        String candName = (String)candidate.getRight();
        Iterator<ImportWrapper> it = this.imports.iterator();
        while (it.hasNext()) {
            i = it.next();
            if (i.isStaticOnDemand() || !i.matches(candFullName, candName)) continue;
            it.remove();
            if ("java.lang".equals(i.getPackageName()) && !this.justReportUnusedImports()) {
                this.reportWithMessage(i.getNode(), ruleCtx, IMPORT_FROM_JAVA_LANG_MESSAGE);
            }
            return;
        }
        it = this.imports.iterator();
        while (it.hasNext()) {
            i = it.next();
            if (i.isStaticOnDemand() || !i.isOnDemand()) continue;
            String possibleClassName = i.getFullName() + "." + candName;
            Class<?> possibleClazz = referenceNode.getRoot().getClassTypeResolver().loadClassOrNull(possibleClassName);
            if (possibleClazz == null) continue;
            it.remove();
        }
        it = this.imports.iterator();
        while (it.hasNext()) {
            i = it.next();
            if (!i.isStaticOnDemand() || !i.matches(candFullName, candName)) continue;
            it.remove();
            return;
        }
        if (referenceNode instanceof TypeNode && ((TypeNode)referenceNode).getType() != null && (c = ((TypeNode)referenceNode).getType()).getPackage() != null) {
            this.removeOnDemandForPackageName(c.getPackage().getName());
        }
    }

    protected Pair<String, String> splitName(Node node) {
        String name;
        String fullName = node.getImage();
        int firstDot = node.getImage().indexOf(46);
        if (firstDot == -1) {
            name = node.getImage();
        } else {
            name = node.getImage().substring(0, firstDot);
            if (this.isMethodCall(node)) {
                fullName = node.getImage().substring(0, node.getImage().lastIndexOf(46));
            }
        }
        return Pair.of((Object)fullName, (Object)name);
    }

    private boolean isMethodCall(Node node) {
        if (node.getParent() instanceof ASTPrimaryPrefix && node.getNthParent(2) instanceof ASTPrimaryExpression) {
            Node nextSibling;
            boolean hasNextSibling;
            Node primaryPrefix = node.getParent();
            Node expression = primaryPrefix.getParent();
            boolean bl = hasNextSibling = expression.getNumChildren() > primaryPrefix.getIndexInParent() + 1;
            if (hasNextSibling && (nextSibling = expression.getChild(primaryPrefix.getIndexInParent() + 1)) instanceof ASTPrimarySuffix) {
                return true;
            }
        }
        return false;
    }

    private void removeReferenceSingleImport(String referenceName) {
        int firstDot = referenceName.indexOf(46);
        String expectedImport = firstDot < 0 ? referenceName : referenceName.substring(0, firstDot);
        Iterator<ImportWrapper> iterator = this.imports.iterator();
        while (iterator.hasNext()) {
            ImportWrapper anImport = iterator.next();
            if (anImport.isOnDemand() || !anImport.getName().equals(expectedImport)) continue;
            iterator.remove();
        }
    }

    private void removeOnDemandForPackageName(String fullName) {
        Iterator<ImportWrapper> iterator = this.imports.iterator();
        while (iterator.hasNext()) {
            ImportWrapper anImport = iterator.next();
            if (!anImport.isOnDemand() || !anImport.getFullName().equals(fullName)) continue;
            iterator.remove();
            break;
        }
    }
}

