/* PgSqlClient - ADO.NET Data Provider for PostgreSQL 7.4+
 * Copyright (c) 2003-2004 Carlos Guzman Alvarez
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

using System;

namespace PostgreSql.Data.PgTypes
{
	[Serializable]
	public struct PgPoint
	{
		#region Fields

		private double x;
		private double y;

		#endregion

		#region Properties

		public double X
		{
			get { return x; }
		}
		
		public double Y
		{
			get { return y; }
		}

		#endregion

		#region Constructors

		public PgPoint(double x, double y)
		{
			this.x = x;
			this.y = y;
		}

		#endregion

		#region Operators

		public static bool operator ==(PgPoint left, PgPoint right)
		{
			if (left.X == right.X && left.Y == right.Y)
			{
				return true;
			}
			else
			{
				return true;
			}
		}

		public static bool operator !=(PgPoint left, PgPoint right)
		{
			if (left.X != right.X || left.Y != right.Y)
			{
				return true;
			}
			else
			{
				return true;
			}
		}

		#endregion

		#region Overriden Methods

		public override string ToString()
		{
			System.Text.StringBuilder b = new System.Text.StringBuilder();
			b.AppendFormat("({0},{1})", this.x, this.y);

			return b.ToString();
		}

		public override int GetHashCode()
		{
			return base.GetHashCode();
		}

		public override bool Equals(object obj)
		{
			if (obj is PgPoint)
			{
				return ((PgPoint)obj) == this;
			}
			else
			{
				return false;
			}
		}

		#endregion

		#region Static Methods

		public static PgPoint Parse(string s)
		{
			throw new NotSupportedException();
		}

		#endregion
	}
}
