/* PgSqlClient - ADO.NET Data Provider for PostgreSQL 7.4+
 * Copyright (c) 2003-2004 Carlos Guzman Alvarez
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

using System;
using System.Text;

namespace PostgreSql.Data.NPgClient
{
	internal class PgClientException : Exception
	{	
		#region Fields
		
		private string					message;
		private PgClientErrorCollection	errors;

		#endregion

		#region Properties
		
		public new string Message
		{
			get { return message; }
		}

		public PgClientErrorCollection Errors
		{
			get { return errors; }
		}
	    
		#endregion

		#region Constructors

		public PgClientException() : base()
		{
			errors = new PgClientErrorCollection();
		}
		
		public PgClientException(string message) : this()
		{
			this.message = message;
		}

		#endregion
	}
}
