/*
 * Decompiled with CFR 0.152.
 */
package gnu.mapping;

import gnu.mapping.ConstantConstraint;
import gnu.mapping.Constraint;
import gnu.mapping.Environment;
import gnu.mapping.Location;
import gnu.mapping.Procedure;
import gnu.mapping.SFormat;
import gnu.mapping.TrivialConstraint;
import gnu.mapping.UnboundSymbol;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.io.PrintWriter;

public class Binding
extends Location
implements Externalizable {
    Object value;
    Constraint constraint;
    public static final String UNBOUND = new String("(unbound)");
    static final String FUNCTION = new String("(function).");
    public static final Binding hashDELETED = new Binding(new String("<Deleted>"));

    public final Object get() {
        return this.constraint.get(this);
    }

    public final Object get(Object defaultValue) {
        return this.constraint.get(this, defaultValue);
    }

    public Procedure getProcedure() {
        try {
            return this.constraint.getProcedure(this);
        }
        catch (UnboundSymbol ex) {
            Object f = this.getFunctionValue(UNBOUND);
            if (f != UNBOUND) {
                return (Procedure)f;
            }
            throw ex;
        }
    }

    public final void defineValue(Object value) {
        Environment env = this.constraint.getEnvironment(this);
        if (env.locked) {
            this.set(value);
        } else {
            this.constraint = TrivialConstraint.getInstance(this);
            this.value = value;
        }
    }

    public final void defineConstant(Object value) {
        Environment env = this.constraint.getEnvironment(this);
        if (env.locked) {
            this.set(value);
        } else {
            this.constraint = ConstantConstraint.getInstance(env);
            this.value = value;
        }
    }

    public final void set(Object value) {
        this.constraint.set(this, value);
    }

    public final Constraint getConstraint() {
        return this.constraint;
    }

    public final void setConstraint(Constraint constraint) {
        this.constraint = constraint;
    }

    public boolean isBound() {
        return this.constraint.isBound(this);
    }

    public Binding() {
    }

    public Binding(String name) {
        this.setName(name);
    }

    public static Binding make(Object init, String name) {
        Binding binding = new Binding(name);
        binding.value = init;
        binding.constraint = TrivialConstraint.getInstance((Environment)null);
        return binding;
    }

    public static Binding make(String name, Environment env) {
        if (env == null) {
            return new Binding(name);
        }
        return env.getBinding(name);
    }

    public void print(PrintWriter ps) {
        ps.print("#<binding ");
        String name = this.getName();
        if (name != null) {
            ps.print(name);
        }
        if (this.isBound()) {
            ps.print(" -> ");
            SFormat.print(this.get(), ps);
        } else {
            ps.print("(unbound)");
        }
        ps.print('>');
    }

    public final Object getKey() {
        return this.getName();
    }

    public final Object getValue() {
        return this.constraint.get(this);
    }

    public final Object setValue(Object value) {
        Object old = this.constraint.get(this);
        this.constraint.set(this, value);
        return old;
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    public static int hashSearch(Binding[] table, int log2Size, int mask, String key, int hash) {
        int index = hash & mask;
        Binding element = table[index];
        if (element == null || element.getName() == key) {
            return index;
        }
        int avail = -1;
        int step = ((hash >> log2Size ^ index) << 1) + 1;
        do {
            if (element == hashDELETED && avail < 0) {
                avail = index;
            }
            if ((element = table[index = index + step & mask]) != null) continue;
            return avail < 0 ? index : avail;
        } while (element.getName() != key);
        return index;
    }

    public static int hashSearch(Binding[] table, int log2Size, String key) {
        return Binding.hashSearch(table, log2Size, (1 << log2Size) - 1, key, System.identityHashCode(key));
    }

    public static Binding hashGet(Binding[] table, int log2Size, String key) {
        int index = Binding.hashSearch(table, log2Size, (1 << log2Size) - 1, key, System.identityHashCode(key));
        Binding element = table[index];
        if (element == null || element == hashDELETED) {
            return null;
        }
        return element;
    }

    public static Binding hashSet(Binding[] table, int log2Size, Binding value) {
        String key = value.getName();
        int index = Binding.hashSearch(table, log2Size, (1 << log2Size) - 1, key, System.identityHashCode(key));
        Binding element = table[index];
        table[index] = value;
        return element == hashDELETED ? null : element;
    }

    public static Binding hashDelete(Binding[] table, int log2Size, String key) {
        int index = Binding.hashSearch(table, log2Size, (1 << log2Size) - 1, key, System.identityHashCode(key));
        Binding element = table[index];
        table[index] = hashDELETED;
        return element == hashDELETED ? null : element;
    }

    public static int hashInsertAll(Binding[] tableDst, int log2SizeDst, Binding[] tableSrc, int log2SizeSrc) {
        int countInserted = 0;
        int sizeSrc = 1 << log2SizeSrc;
        int sizeDst = 1 << log2SizeDst;
        int maskDst = (1 << log2SizeDst) - 1;
        int i = sizeSrc;
        while (--i >= 0) {
            Binding element = tableSrc[i];
            if (element == null || element == hashDELETED) continue;
            String key = element.getName();
            int index = Binding.hashSearch(tableDst, log2SizeDst, maskDst, key, System.identityHashCode(key));
            Binding oldElement = tableDst[index];
            if (oldElement != null && oldElement != hashDELETED) {
                ++countInserted;
            }
            tableDst[index] = element;
        }
        return countInserted;
    }

    public final Object getFunctionValue() {
        Object value = this.constraint.getFunctionValue(this);
        if (value == UNBOUND) {
            throw new UnboundSymbol(this.getName());
        }
        return value;
    }

    public final Object getFunctionValue(Object defaultValue) {
        Object value = this.constraint.getFunctionValue(this);
        return value == UNBOUND ? defaultValue : value;
    }

    public boolean hasFunctionValue() {
        Object value = this.constraint.getFunctionValue(this);
        return value != UNBOUND;
    }

    public void setFunctionValue(Object value) {
        this.constraint.setFunctionValue(this, value);
    }

    public void removeFunctionValue() {
        this.constraint.setFunctionValue(this, UNBOUND);
    }

    public final Environment getEnvironment() {
        return this.constraint.getEnvironment(this);
    }

    public String toString() {
        return this.getName();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.getName());
        out.writeObject(this.getEnvironment());
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        String name = (String)in.readObject();
        Environment env = (Environment)in.readObject();
        if (env != null) {
            this.constraint = env.unboundConstraint;
        }
        this.setName(name);
    }

    public Object readResolve() throws ObjectStreamException {
        if (this.constraint == null) {
            return this;
        }
        Environment env = this.constraint.getEnvironment(this);
        if (env == null) {
            return this;
        }
        return Binding.make(env, this.getName());
    }
}

