/*
 * Decompiled with CFR 0.152.
 */
package org.mvndaemon.mvnd.sync;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PreDestroy;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.SyncContext;
import org.eclipse.aether.spi.synccontext.SyncContextFactory;
import org.eclipse.sisu.Priority;
import org.mvndaemon.mvnd.common.BuildProperties;
import org.mvndaemon.mvnd.common.Environment;
import org.mvndaemon.mvnd.sync.IpcClient;
import org.mvndaemon.mvnd.sync.IpcSyncContext;

@Named
@Priority(value=10)
@Singleton
public class IpcSyncContextFactory
implements SyncContextFactory {
    private final Map<Path, IpcClient> clients = new ConcurrentHashMap<Path, IpcClient>();

    public SyncContext newInstance(RepositorySystemSession session, boolean shared) {
        Path repository = session.getLocalRepository().getBasedir().toPath();
        Path logPath = Optional.ofNullable(System.getProperty(Environment.MVND_DAEMON_STORAGE.getProperty())).map(x$0 -> Paths.get(x$0, new String[0])).orElseGet(() -> Environment.USER_HOME.asPath().resolve(".m2/mvnd/registry/" + BuildProperties.getInstance().getVersion()));
        String mvndHome = Environment.MVND_HOME.asString();
        Path syncPath = mvndHome != null ? Paths.get(mvndHome, new String[0]).resolve("bin") : null;
        IpcClient client = this.clients.computeIfAbsent(repository, r -> new IpcClient((Path)r, logPath, syncPath));
        return new IpcSyncContext(client, shared);
    }

    @PreDestroy
    void close() {
        this.clients.values().forEach(IpcClient::close);
    }

    public String toString() {
        return "IpcSyncContextFactory{clients=" + this.clients + '}';
    }
}

