/*
 * Decompiled with CFR 0.152.
 */
package org.mvndaemon.mvnd.execution;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import java.util.stream.Stream;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.project.MavenProject;
import org.mvndaemon.mvnd.execution.BuildResumptionData;
import org.mvndaemon.mvnd.execution.BuildResumptionDataRepository;
import org.mvndaemon.mvnd.execution.BuildResumptionPersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public class DefaultBuildResumptionDataRepository
implements BuildResumptionDataRepository {
    private static final String RESUME_PROPERTIES_FILENAME = "resume.properties";
    private static final String REMAINING_PROJECTS = "remainingProjects";
    private static final String PROPERTY_DELIMITER = ", ";
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultBuildResumptionDataRepository.class);

    @Override
    public void persistResumptionData(MavenProject rootProject, BuildResumptionData buildResumptionData) throws BuildResumptionPersistenceException {
        Path directory = Paths.get(rootProject.getBuild().getDirectory(), new String[0]);
        this.persistResumptionData(directory, buildResumptionData);
    }

    public void persistResumptionData(Path directory, BuildResumptionData buildResumptionData) throws BuildResumptionPersistenceException {
        Properties properties = this.convertToProperties(buildResumptionData);
        Path resumeProperties = directory.resolve(RESUME_PROPERTIES_FILENAME);
        try {
            Files.createDirectories(resumeProperties.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(resumeProperties, new OpenOption[0]);){
                properties.store(writer, null);
            }
        }
        catch (IOException e) {
            String message = "Could not create resume.properties file.";
            throw new BuildResumptionPersistenceException(message, e);
        }
    }

    private Properties convertToProperties(BuildResumptionData buildResumptionData) {
        Properties properties = new Properties();
        String value = String.join((CharSequence)PROPERTY_DELIMITER, buildResumptionData.getRemainingProjects());
        properties.setProperty(REMAINING_PROJECTS, value);
        return properties;
    }

    @Override
    public void applyResumptionData(MavenExecutionRequest request, MavenProject rootProject) {
        Path directory = Paths.get(rootProject.getBuild().getDirectory(), new String[0]);
        this.applyResumptionData(request, directory);
    }

    public void applyResumptionData(MavenExecutionRequest request, Path directory) {
        Properties properties = this.loadResumptionFile(directory);
        this.applyResumptionProperties(request, properties);
    }

    @Override
    public void removeResumptionData(MavenProject rootProject) {
        Path directory = Paths.get(rootProject.getBuild().getDirectory(), new String[0]);
        this.removeResumptionData(directory);
    }

    public void removeResumptionData(Path directory) {
        Path resumeProperties = directory.resolve(RESUME_PROPERTIES_FILENAME);
        try {
            Files.deleteIfExists(resumeProperties);
        }
        catch (IOException e) {
            LOGGER.warn("Could not delete {} file. ", (Object)RESUME_PROPERTIES_FILENAME, (Object)e);
        }
    }

    private Properties loadResumptionFile(Path rootBuildDirectory) {
        Properties properties = new Properties();
        Path path = rootBuildDirectory.resolve(RESUME_PROPERTIES_FILENAME);
        if (!Files.exists(path, new LinkOption[0])) {
            LOGGER.warn("The {} file does not exist. The --resume / -r feature will not work.", (Object)path);
            return properties;
        }
        try (BufferedReader reader = Files.newBufferedReader(path);){
            properties.load(reader);
        }
        catch (IOException e) {
            LOGGER.warn("Unable to read {}. The --resume / -r feature will not work.", (Object)path);
        }
        return properties;
    }

    void applyResumptionProperties(MavenExecutionRequest request, Properties properties) {
        if (properties.containsKey(REMAINING_PROJECTS) && StringUtils.isEmpty((CharSequence)request.getResumeFrom())) {
            String propertyValue = properties.getProperty(REMAINING_PROJECTS);
            Stream.of(propertyValue.split(PROPERTY_DELIMITER)).filter(StringUtils::isNotEmpty).forEach(request.getSelectedProjects()::add);
            LOGGER.info("Resuming from {} due to the --resume / -r feature.", (Object)propertyValue);
        }
    }
}

