/*
 * Decompiled with CFR 0.152.
 */
package org.mvndaemon.mvnd.logging.internal;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.pattern.ThrowableProxyConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.CoreConstants;
import org.apache.maven.shared.utils.logging.MessageUtils;

public class SimpleAppender
extends AppenderBase<ILoggingEvent> {
    protected void append(ILoggingEvent eventObject) {
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        buf.append(this.renderLevel(eventObject.getLevel()));
        buf.append(']');
        buf.append(' ');
        buf.append(eventObject.getFormattedMessage());
        buf.append(CoreConstants.LINE_SEPARATOR);
        IThrowableProxy tp = eventObject.getThrowableProxy();
        if (tp != null) {
            buf.append(CoreConstants.LINE_SEPARATOR);
            buf.append(new ThrowableProxyConverter().convert(eventObject));
        }
        System.out.print(buf.toString());
    }

    private String renderLevel(Level level) {
        switch (level.toInt()) {
            case 5000: {
                return MessageUtils.level().debug("TRACE");
            }
            case 10000: {
                return MessageUtils.level().debug("DEBUG");
            }
            case 20000: {
                return MessageUtils.level().info("INFO");
            }
            case 30000: {
                return MessageUtils.level().warning("WARNING");
            }
            case 40000: {
                return MessageUtils.level().error("ERROR");
            }
        }
        throw new IllegalStateException("Level " + level + " is unknown.");
    }
}

