/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cli.compiler;

import groovy.lang.Grab;
import groovy.lang.GroovyClassLoader;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.springframework.boot.cli.compiler.dependencies.ArtifactCoordinatesResolver;
import org.springframework.boot.cli.compiler.grape.DependencyResolutionContext;

public class DependencyCustomizer {
    private final GroovyClassLoader loader;
    private final ClassNode classNode;
    private final DependencyResolutionContext dependencyResolutionContext;

    public DependencyCustomizer(GroovyClassLoader loader, ModuleNode moduleNode, DependencyResolutionContext dependencyResolutionContext) {
        this.loader = loader;
        this.classNode = moduleNode.getClasses().get(0);
        this.dependencyResolutionContext = dependencyResolutionContext;
    }

    protected DependencyCustomizer(DependencyCustomizer parent) {
        this.loader = parent.loader;
        this.classNode = parent.classNode;
        this.dependencyResolutionContext = parent.dependencyResolutionContext;
    }

    public String getVersion(String artifactId) {
        return this.getVersion(artifactId, "");
    }

    public String getVersion(String artifactId, String defaultVersion) {
        String version = this.dependencyResolutionContext.getArtifactCoordinatesResolver().getVersion(artifactId);
        if (version == null) {
            version = defaultVersion;
        }
        return version;
    }

    public DependencyCustomizer ifAnyMissingClasses(final String ... classNames) {
        return new DependencyCustomizer(this){

            @Override
            protected boolean canAdd() {
                for (String className : classNames) {
                    try {
                        DependencyCustomizer.this.loader.loadClass(className);
                    }
                    catch (Exception ex) {
                        return true;
                    }
                }
                return false;
            }
        };
    }

    public DependencyCustomizer ifAllMissingClasses(final String ... classNames) {
        return new DependencyCustomizer(this){

            @Override
            protected boolean canAdd() {
                for (String className : classNames) {
                    try {
                        DependencyCustomizer.this.loader.loadClass(className);
                        return false;
                    }
                    catch (Exception exception) {
                    }
                }
                return DependencyCustomizer.this.canAdd();
            }
        };
    }

    public DependencyCustomizer ifAllResourcesPresent(final String ... paths) {
        return new DependencyCustomizer(this){

            @Override
            protected boolean canAdd() {
                for (String path : paths) {
                    try {
                        return DependencyCustomizer.this.loader.getResource(path) != null;
                    }
                    catch (Exception exception) {
                    }
                }
                return DependencyCustomizer.this.canAdd();
            }
        };
    }

    public DependencyCustomizer ifAnyResourcesPresent(final String ... paths) {
        return new DependencyCustomizer(this){

            @Override
            protected boolean canAdd() {
                for (String path : paths) {
                    try {
                        return DependencyCustomizer.this.loader.getResource(path) != null;
                    }
                    catch (Exception exception) {
                    }
                }
                return DependencyCustomizer.this.canAdd();
            }
        };
    }

    public DependencyCustomizer add(String ... modules) {
        for (String module : modules) {
            this.add(module, null, null, true);
        }
        return this;
    }

    public DependencyCustomizer add(String module, boolean transitive) {
        return this.add(module, null, null, transitive);
    }

    public DependencyCustomizer add(String module, String classifier, String type, boolean transitive) {
        if (this.canAdd()) {
            ArtifactCoordinatesResolver artifactCoordinatesResolver = this.dependencyResolutionContext.getArtifactCoordinatesResolver();
            this.classNode.addAnnotation(this.createGrabAnnotation(artifactCoordinatesResolver.getGroupId(module), artifactCoordinatesResolver.getArtifactId(module), artifactCoordinatesResolver.getVersion(module), classifier, type, transitive));
        }
        return this;
    }

    private AnnotationNode createGrabAnnotation(String group, String module, String version, String classifier, String type, boolean transitive) {
        AnnotationNode annotationNode = new AnnotationNode(new ClassNode(Grab.class));
        annotationNode.addMember("group", new ConstantExpression(group));
        annotationNode.addMember("module", new ConstantExpression(module));
        annotationNode.addMember("version", new ConstantExpression(version));
        if (classifier != null) {
            annotationNode.addMember("classifier", new ConstantExpression(classifier));
        }
        if (type != null) {
            annotationNode.addMember("type", new ConstantExpression(type));
        }
        annotationNode.addMember("transitive", new ConstantExpression(transitive));
        annotationNode.addMember("initClass", new ConstantExpression(false));
        return annotationNode;
    }

    protected boolean canAdd() {
        return true;
    }

    public DependencyResolutionContext getDependencyResolutionContext() {
        return this.dependencyResolutionContext;
    }
}

