///////////////////////////////////////////////////////////////////////////
// mathex 0.2 (beta) - Copyright (C) 2000-2003, by Sadao Massago         //
// file: curvetest.cpp (parametric curve table making)                   //
// requires: mathex.h, mathex.cpp                                        //
// project web page: http://sourceforge.net/projects/sscilib/            //
// ----------------------------------------------------------------------//
// The mathex library and related files is licenced under the term of    //
// GNU LGPL (Lesser General Public License) version 2.1 or latter        //
// with exceptions that allow for static linking.                        //
// See license.txt for detail.                                           //
// For GNU LGPL, see lesser.txt.                                         //
// For information over GNU or GNU compatible license, visit the site    //
// http://www.gnu.org.                                                   //
///////////////////////////////////////////////////////////////////////////

#include <iostream>
#include <iomanip>
#include <string>

// #define _DEBUG_

#include "mathex.h"

using namespace std;

int main()
{
   // for variable sharing/setting example
      double x;  // x, y are used to table example too
      string xstr, ystr;
   // for table example
      int i, n;
      double a, b, h;
      smlib::mathex xexpr, yexpr;
      bool xparsed, yparsed;
     
   // sharing with internal variables ...
   // table making example
      cout << "function table example\n";
      // expr.delvar();
   // sharing with internal variables ... 
      if(!xexpr.addvar("t", &x) || !yexpr.addvar("t", &x)) {
         cout << "Error adding internal variable x as name \"t\"n";
         return 1;
      }
      do {
      
         cout << "x(t) = ";
      
         do { 
			   xstr.erase();
            getline(cin, xstr); // getline delete '\n'character?
         } while(xstr.empty());
      
         cout << "y(t) = ";
      
         do { 
			   ystr.erase();
            getline(cin, ystr); // getline delete '\n'character?
         } while(ystr.empty());
         cout << "now parsing the expressions \"" << xstr << "\" and \""<< ystr << "\"" << endl;
			xparsed = yparsed = false;
         try {
            xexpr.expression(xstr); // setting expression string
            xexpr.parse(); // parse
            xparsed = true; // parse sucessfull
            yexpr.expression(ystr); // setting expression string
            yexpr.parse(); // parse
            yparsed = true; // parse sucessfull
         }
             catch(smlib::mathex::error e) { // mathex exception
               cout << e.what() << endl; // erroer message
					// show expression and error position
					if(!xparsed) {
                 cout << xstr << endl;
                 cout << setw(xexpr.stopposition()) << "^" << endl;
					}
					if(!yparsed) {
                 cout << ystr << endl;
                 cout << setw(yexpr.stopposition()) << "^" << endl;
					}
            } // catch
             catch(exception e) { // unknow exception
               cout << e.what() << endl; // erroer message
            }
      } while(!xparsed || !yparsed);
   
	   // get the interval
      cout << "t[0]= "; cin >> a;
      cout << "t[n]= "; cin >> b;
      cout << "n= "; cin >> n;
      // calculate h
      h = (b-a)/n;
      x = a;
      cout << "t        x(t)        y(t)\n";
      for(i=0; i<=n; i++) {
         try {
             cout << x << "    " << xexpr.eval() << "    " << yexpr.eval() << endl;
         }
         catch(smlib::mathex::error e) { // mathex exception
            cout << e.what() << endl;
         }	 
         catch(exception e) { // unknow exception
            cout << e.what() << endl;
         }	 
         x = x + h;
      } // for
      
      return 0;
   } // main()

// end of tabletest.cpp
