/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.type;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LighterASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtLightSourceElement;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.KtPsiSourceElement;
import org.jetbrains.kotlin.KtRealPsiSourceElement;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.diagnostics.LightTreePositioningStrategiesKt;
import org.jetbrains.kotlin.fir.FirFunctionTypeParameter;
import org.jetbrains.kotlin.fir.analysis.checkers.FirKeywordUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirModifier;
import org.jetbrains.kotlin.fir.analysis.checkers.FirModifierList;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.type.FirFunctionalTypeParameterSyntaxChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.psi.KtValVarKeywordOwner;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.util.LightTreeUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u000e\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u0011\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/type/FirUnsupportedModifiersInFunctionTypeParameterChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/type/FirFunctionalTypeParameterSyntaxChecker;", "<init>", "()V", "checkPsiOrLightTree", "", "element", "Lorg/jetbrains/kotlin/fir/FirFunctionTypeParameter;", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkValOrVarKeyword", "checkModifiers", "", "checkAnnotations", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirUnsupportedModifiersInFunctionTypeParameterChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirUnsupportedModifiersInFunctionTypeParameterChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/type/FirUnsupportedModifiersInFunctionTypeParameterChecker\n+ 2 KtSourceElement.kt\norg/jetbrains/kotlin/KtSourceElementKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,90:1\n802#2,5:91\n808#2,7:96\n808#2,7:109\n774#3:103\n865#3,2:104\n1557#3:106\n1628#3,2:107\n1630#3:116\n*S KotlinDebug\n*F\n+ 1 FirUnsupportedModifiersInFunctionTypeParameterChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/type/FirUnsupportedModifiersInFunctionTypeParameterChecker\n*L\n39#1:91,5\n42#1:96,7\n73#1:109,7\n73#1:103\n73#1:104,2\n73#1:106\n73#1:107,2\n73#1:116\n*E\n"})
public final class FirUnsupportedModifiersInFunctionTypeParameterChecker
extends FirFunctionalTypeParameterSyntaxChecker {
    @NotNull
    public static final FirUnsupportedModifiersInFunctionTypeParameterChecker INSTANCE = new FirUnsupportedModifiersInFunctionTypeParameterChecker();

    private FirUnsupportedModifiersInFunctionTypeParameterChecker() {
    }

    @Override
    public void checkPsiOrLightTree(@NotNull FirFunctionTypeParameter element, @NotNull KtSourceElement source, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(element, "element");
        Intrinsics.checkNotNullParameter(source, "source");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        this.checkModifiers(source, reporter, context);
        this.checkAnnotations(source, reporter, context);
        this.checkValOrVarKeyword(source, reporter, context);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void checkValOrVarKeyword(KtSourceElement source, DiagnosticReporter reporter, CheckerContext context) {
        KtSourceElement ktSourceElement;
        KtSourceElement ktSourceElement2 = source;
        if (ktSourceElement2 instanceof KtPsiSourceElement) {
            KtPsiSourceElement ktPsiSourceElement;
            PsiElement psiElement = ((KtPsiSourceElement)source).getPsi();
            PsiElement psiElement2 = psiElement instanceof KtValVarKeywordOwner ? (KtValVarKeywordOwner)psiElement : null;
            if (psiElement2 != null && (psiElement2 = psiElement2.getValOrVarKeyword()) != null) {
                PsiElement psiElement3 = psiElement2;
                KtSourceElementKind kind$iv = KtRealSourceElementKind.INSTANCE;
                boolean $i$f$toKtPsiSourceElement = false;
                KtSourceElementKind ktSourceElementKind = kind$iv;
                if (ktSourceElementKind instanceof KtRealSourceElementKind) {
                    ktPsiSourceElement = new KtRealPsiSourceElement(psiElement3);
                } else {
                    if (!(ktSourceElementKind instanceof KtFakeSourceElementKind)) throw new NoWhenBranchMatchedException();
                    ktPsiSourceElement = new KtFakeSourceElement(psiElement3, (KtFakeSourceElementKind)kind$iv);
                }
            } else {
                ktPsiSourceElement = null;
            }
            ktSourceElement = ktPsiSourceElement;
        } else {
            KtLightSourceElement ktLightSourceElement;
            if (!(ktSourceElement2 instanceof KtLightSourceElement)) throw new NoWhenBranchMatchedException();
            LighterASTNode lighterASTNode = LightTreePositioningStrategiesKt.valOrVarKeyword(((KtLightSourceElement)source).getTreeStructure(), ((KtLightSourceElement)source).getLighterASTNode());
            if (lighterASTNode != null) {
                void $this$toKtLightSourceElement_u24default$iv;
                LighterASTNode lighterASTNode2 = lighterASTNode;
                FlyweightCapableTreeStructure<LighterASTNode> flyweightCapableTreeStructure = ((KtLightSourceElement)source).getTreeStructure();
                KtSourceElementKind kind$iv = KtRealSourceElementKind.INSTANCE;
                int startOffset$iv = $this$toKtLightSourceElement_u24default$iv.getStartOffset();
                int endOffset$iv = $this$toKtLightSourceElement_u24default$iv.getEndOffset();
                boolean $i$f$toKtLightSourceElement = false;
                ktLightSourceElement = new KtLightSourceElement((LighterASTNode)$this$toKtLightSourceElement_u24default$iv, startOffset$iv, endOffset$iv, flyweightCapableTreeStructure, kind$iv);
            } else {
                ktLightSourceElement = null;
            }
            ktSourceElement = ktLightSourceElement;
        }
        if (ktSourceElement == null) {
            return;
        }
        KtSourceElement keyword = ktSourceElement;
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)keyword, FirErrors.INSTANCE.getUNSUPPORTED(), (Object)"val or var on parameter in function type", (DiagnosticContext)context, null, 16, null);
    }

    private final boolean checkModifiers(KtSourceElement source, DiagnosticReporter reporter, CheckerContext context) {
        FirModifierList firModifierList = FirKeywordUtilsKt.getModifierList(source);
        if (firModifierList == null) {
            return true;
        }
        FirModifierList modifiersList = firModifierList;
        for (FirModifier<?> modifier : modifiersList.getModifiers()) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)modifier.getSource(), FirErrors.INSTANCE.getUNSUPPORTED(), (Object)"modifier on parameter in function type", (DiagnosticContext)context, null, 16, null);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkAnnotations(KtSourceElement source, DiagnosticReporter reporter, CheckerContext context) {
        List list;
        FirModifierList firModifierList = FirKeywordUtilsKt.getModifierList(source);
        if (firModifierList == null) {
            return true;
        }
        FirModifierList commonModifiersList = firModifierList;
        FirModifierList firModifierList2 = commonModifiersList;
        if (firModifierList2 instanceof FirModifierList.FirLightModifierList) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            LighterASTNode it;
            void $this$filterTo$iv$iv;
            FlyweightCapableTreeStructure<LighterASTNode> tree = ((FirModifierList.FirLightModifierList)commonModifiersList).getTree();
            List<LighterASTNode> children = LightTreeUtilsKt.getChildren(((FirModifierList.FirLightModifierList)commonModifiersList).getModifierList(), tree);
            Iterable $this$filter$iv = children;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (LighterASTNode)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getTokenType(), KtNodeTypes.ANNOTATION_ENTRY)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (LighterASTNode)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                LighterASTNode $this$toKtLightSourceElement_u24default$iv = it;
                KtSourceElementKind kind$iv = KtRealSourceElementKind.INSTANCE;
                int startOffset$iv = $this$toKtLightSourceElement_u24default$iv.getStartOffset();
                int endOffset$iv = $this$toKtLightSourceElement_u24default$iv.getEndOffset();
                boolean $i$f$toKtLightSourceElement = false;
                collection.add(new KtLightSourceElement($this$toKtLightSourceElement_u24default$iv, startOffset$iv, endOffset$iv, tree, kind$iv));
            }
            list = (List)destination$iv$iv;
        } else if (firModifierList2 instanceof FirModifierList.FirPsiModifierList) {
            ASTNode aSTNode = ((FirModifierList.FirPsiModifierList)commonModifiersList).getModifierList().getNode();
            Intrinsics.checkNotNullExpressionValue(aSTNode, "getNode(...)");
            Sequence<ASTNode> children = PsiUtilsKt.children(aSTNode);
            list = SequencesKt.toList(SequencesKt.map(SequencesKt.filter(children, FirUnsupportedModifiersInFunctionTypeParameterChecker::checkAnnotations$lambda$2), FirUnsupportedModifiersInFunctionTypeParameterChecker::checkAnnotations$lambda$3));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        List annotationsSource = list;
        for (KtSourceElement ann : annotationsSource) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)ann, FirErrors.INSTANCE.getUNSUPPORTED(), (Object)"annotation on parameter in function type", (DiagnosticContext)context, null, 16, null);
        }
        return false;
    }

    private static final boolean checkAnnotations$lambda$2(ASTNode it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Intrinsics.areEqual(it.getElementType(), KtNodeTypes.ANNOTATION_ENTRY);
    }

    private static final KtRealPsiSourceElement checkAnnotations$lambda$3(ASTNode it) {
        Intrinsics.checkNotNullParameter(it, "it");
        PsiElement psiElement = it.getPsi();
        Intrinsics.checkNotNullExpressionValue(psiElement, "getPsi(...)");
        return new KtRealPsiSourceElement(psiElement);
    }
}

