/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.decompiler.psi;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.util.io.URLUtil;
import java.net.URL;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.decompiler.psi.BuiltinsVirtualFileProviderBaseImpl;
import org.jetbrains.kotlin.utils.exceptions.ExceptionAttachmentBuilder;
import org.jetbrains.kotlin.utils.exceptions.KotlinExceptionWithAttachments;
import org.jetbrains.kotlin.utils.exceptions.KotlinIllegalArgumentExceptionWithAttachments;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiler/psi/BuiltinsVirtualFileProviderCliImpl;", "Lorg/jetbrains/kotlin/analysis/decompiler/psi/BuiltinsVirtualFileProviderBaseImpl;", "<init>", "()V", "findVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "url", "Ljava/net/URL;", "decompiler-to-psi"})
@SourceDebugExtension(value={"SMAP\nBuiltinsVirtualFileProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuiltinsVirtualFileProvider.kt\norg/jetbrains/kotlin/analysis/decompiler/psi/BuiltinsVirtualFileProviderCliImpl\n+ 2 ExceptionAttachmentBuilder.kt\norg/jetbrains/kotlin/utils/exceptions/ExceptionAttachmentBuilderKt\n*L\n1#1,70:1\n81#2,7:71\n76#2,2:78\n57#2:80\n78#2:81\n*S KotlinDebug\n*F\n+ 1 BuiltinsVirtualFileProvider.kt\norg/jetbrains/kotlin/analysis/decompiler/psi/BuiltinsVirtualFileProviderCliImpl\n*L\n61#1:71,7\n61#1:78,2\n61#1:80\n61#1:81\n*E\n"})
public final class BuiltinsVirtualFileProviderCliImpl
extends BuiltinsVirtualFileProviderBaseImpl {
    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    protected VirtualFile findVirtualFile(@NotNull URL url) {
        Intrinsics.checkNotNullParameter(url, "url");
        Pair<String, String> pair = URLUtil.splitJarUrl(url.getPath());
        if (pair == null) {
            void $this$buildErrorWithAttachment_u24lambda_u240$iv$iv;
            ExceptionAttachmentBuilder exceptionAttachmentBuilder;
            String message$iv = "URL for builtins does not contain jar separator";
            Throwable cause$iv = null;
            String attachmentName$iv = "info.txt";
            boolean $i$f$errorWithAttachment = false;
            boolean $i$f$buildErrorWithAttachment = false;
            KotlinIllegalArgumentExceptionWithAttachments exception$iv$iv = new KotlinIllegalArgumentExceptionWithAttachments(message$iv, cause$iv);
            KotlinExceptionWithAttachments $this$buildAttachment$iv$iv$iv = exception$iv$iv;
            boolean $i$f$buildAttachment = false;
            ExceptionAttachmentBuilder exceptionAttachmentBuilder2 = exceptionAttachmentBuilder = new ExceptionAttachmentBuilder();
            String string2 = attachmentName$iv;
            KotlinExceptionWithAttachments kotlinExceptionWithAttachments = $this$buildAttachment$iv$iv$iv;
            boolean bl = false;
            void $this$findVirtualFile_u24lambda_u241 = $this$buildErrorWithAttachment_u24lambda_u240$iv$iv;
            boolean bl2 = false;
            $this$findVirtualFile_u24lambda_u241.withEntry("url", url, arg_0 -> BuiltinsVirtualFileProviderCliImpl.findVirtualFile$lambda$1$lambda$0(url, arg_0));
            kotlinExceptionWithAttachments.withAttachment(string2, exceptionAttachmentBuilder.buildString());
            throw (Throwable)exception$iv$iv;
        }
        Pair<String, String> split = pair;
        String jarPath = (String)split.first;
        String builtinFile = (String)split.second;
        String pathToQuery = jarPath + "!/" + builtinFile;
        VirtualFileSystem jarFileSystem = VirtualFileManager.getInstance().getFileSystem("jar");
        return jarFileSystem.findFileByPath(pathToQuery);
    }

    private static final String findVirtualFile$lambda$1$lambda$0(URL $url, URL it) {
        Intrinsics.checkNotNullParameter(it, "it");
        String string2 = $url.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
        return string2;
    }
}

