/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.BodyLoweringPass;
import org.jetbrains.kotlin.backend.common.CompilationExceptionKt;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrArithBuilder;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrBuilder;
import org.jetbrains.kotlin.ir.backend.js.lower.TypeOperatorLowering;
import org.jetbrains.kotlin.ir.backend.js.utils.JsInlineClassesUtils;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstantArray;
import org.jetbrains.kotlin.ir.expressions.IrConstantObject;
import org.jetbrains.kotlin.ir.expressions.IrConstantPrimitive;
import org.jetbrains.kotlin.ir.expressions.IrConstantValue;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInlinedFunctionBlock;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrReturnableBlock;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrCompositeImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetObjectValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrDynamicType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.DeepCopyIrTreeWithSymbols;
import org.jetbrains.kotlin.ir.util.DeepCopySymbolRemapper;
import org.jetbrains.kotlin.ir.util.DeepCopyTypeRemapper;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.util.ReferencedSymbolRemapper;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.util.TypeRemapper;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformer;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020BH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0012R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0012R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\u00020\u001e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0014\u0010$\u001a\u00020\u001e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010#R\u000e\u0010%\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010*\u001a\b\u0012\u0004\u0012\u00020+0\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010\u0012R\u001a\u0010-\u001a\b\u0012\u0004\u0012\u00020+0\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010\u0012R\u001a\u0010/\u001a\b\u0012\u0004\u0012\u00020+0\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u0010\u0012R\u001a\u00101\u001a\b\u0012\u0004\u0012\u00020+0\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u0010\u0012R\u0014\u00103\u001a\u0002048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b5\u00106R\u0014\u00107\u001a\u0002048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b8\u00106R\u0014\u00109\u001a\u0002048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b:\u00106R\u000e\u0010;\u001a\u00020<X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/TypeOperatorLowering;", "Lorg/jetbrains/kotlin/backend/common/BodyLoweringPass;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "unit", "Lorg/jetbrains/kotlin/ir/types/IrType;", "unitValue", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrGetObjectValueImpl;", "getUnitValue", "()Lorg/jetbrains/kotlin/ir/expressions/impl/IrGetObjectValueImpl;", "lit24", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrConstImpl;", "", "getLit24", "()Lorg/jetbrains/kotlin/ir/expressions/impl/IrConstImpl;", "lit16", "getLit16", "byteMask", "getByteMask", "shortMask", "getShortMask", "calculator", "Lorg/jetbrains/kotlin/ir/backend/js/ir/JsIrArithBuilder;", "devMode", "", "throwCCE", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "throwNPE", "eqeq", "booleanNot", "isInterfaceSymbol", "()Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "isArraySymbol", "isSuspendFunctionSymbol", "instanceOfIntrinsicSymbol", "isExternalObjectSymbol", "typeOfIntrinsicSymbol", "jsClassIntrinsicSymbol", "stringMarker", "", "getStringMarker", "booleanMarker", "getBooleanMarker", "functionMarker", "getFunctionMarker", "numberMarker", "getNumberMarker", "litTrue", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "getLitTrue", "()Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "litFalse", "getLitFalse", "litNull", "getLitNull", "icUtils", "Lorg/jetbrains/kotlin/ir/backend/js/utils/JsInlineClassesUtils;", "lower", "", "irBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "backend.js"})
public final class TypeOperatorLowering
implements BodyLoweringPass {
    @NotNull
    private final JsIrBackendContext context;
    @NotNull
    private final IrType unit;
    @NotNull
    private final JsIrArithBuilder calculator;
    private final boolean devMode;
    @NotNull
    private final IrSimpleFunctionSymbol throwCCE;
    @NotNull
    private final IrSimpleFunctionSymbol throwNPE;
    @NotNull
    private final IrSimpleFunctionSymbol eqeq;
    @NotNull
    private final IrSimpleFunctionSymbol booleanNot;
    @NotNull
    private final IrSimpleFunctionSymbol isSuspendFunctionSymbol;
    @NotNull
    private final IrSimpleFunctionSymbol instanceOfIntrinsicSymbol;
    @NotNull
    private final IrSimpleFunctionSymbol isExternalObjectSymbol;
    @NotNull
    private final IrSimpleFunctionSymbol typeOfIntrinsicSymbol;
    @NotNull
    private final IrSimpleFunctionSymbol jsClassIntrinsicSymbol;
    @NotNull
    private final JsInlineClassesUtils icUtils;

    public TypeOperatorLowering(@NotNull JsIrBackendContext context) {
        Intrinsics.checkNotNullParameter(context, "context");
        this.context = context;
        this.unit = this.context.getIrBuiltIns().getUnitType();
        this.calculator = new JsIrArithBuilder(this.context);
        this.devMode = this.context.getDevMode();
        this.throwCCE = this.context.getIr().getSymbols().getThrowTypeCastException();
        this.throwNPE = this.context.getIr().getSymbols().getThrowNullPointerException();
        this.eqeq = this.context.getIrBuiltIns().getEqeqSymbol();
        this.booleanNot = this.context.getIrBuiltIns().getBooleanNotSymbol();
        this.isSuspendFunctionSymbol = this.context.getIntrinsics().isSuspendFunctionSymbol();
        this.instanceOfIntrinsicSymbol = this.context.getIntrinsics().getJsInstanceOf();
        this.isExternalObjectSymbol = this.context.getIntrinsics().isExternalObject();
        this.typeOfIntrinsicSymbol = this.context.getIntrinsics().getJsTypeOf();
        this.jsClassIntrinsicSymbol = this.context.getIntrinsics().getJsClass();
        this.icUtils = this.context.getInlineClassesUtils();
    }

    @NotNull
    public final JsIrBackendContext getContext() {
        return this.context;
    }

    private final IrGetObjectValueImpl getUnitValue() {
        IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrFail(this.unit);
        Intrinsics.checkNotNull(irClassifierSymbol, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.symbols.IrClassSymbol");
        return JsIrBuilder.INSTANCE.buildGetObjectValue(this.unit, (IrClassSymbol)irClassifierSymbol);
    }

    private final IrConstImpl<Integer> getLit24() {
        return JsIrBuilder.INSTANCE.buildInt(this.context.getIrBuiltIns().getIntType(), 24);
    }

    private final IrConstImpl<Integer> getLit16() {
        return JsIrBuilder.INSTANCE.buildInt(this.context.getIrBuiltIns().getIntType(), 16);
    }

    private final IrConstImpl<Integer> getByteMask() {
        return JsIrBuilder.INSTANCE.buildInt(this.context.getIrBuiltIns().getIntType(), 255);
    }

    private final IrConstImpl<Integer> getShortMask() {
        return JsIrBuilder.INSTANCE.buildInt(this.context.getIrBuiltIns().getIntType(), 65535);
    }

    private final IrSimpleFunctionSymbol isInterfaceSymbol() {
        return this.context.getIntrinsics().isInterfaceSymbol();
    }

    private final IrSimpleFunctionSymbol isArraySymbol() {
        return this.context.getIntrinsics().isArraySymbol();
    }

    private final IrConstImpl<String> getStringMarker() {
        return JsIrBuilder.INSTANCE.buildString(this.context.getIrBuiltIns().getStringType(), "string");
    }

    private final IrConstImpl<String> getBooleanMarker() {
        return JsIrBuilder.INSTANCE.buildString(this.context.getIrBuiltIns().getStringType(), "boolean");
    }

    private final IrConstImpl<String> getFunctionMarker() {
        return JsIrBuilder.INSTANCE.buildString(this.context.getIrBuiltIns().getStringType(), "function");
    }

    private final IrConstImpl<String> getNumberMarker() {
        return JsIrBuilder.INSTANCE.buildString(this.context.getIrBuiltIns().getStringType(), "number");
    }

    private final IrExpression getLitTrue() {
        return JsIrBuilder.INSTANCE.buildBoolean(this.context.getIrBuiltIns().getBooleanType(), true);
    }

    private final IrExpression getLitFalse() {
        return JsIrBuilder.INSTANCE.buildBoolean(this.context.getIrBuiltIns().getBooleanType(), false);
    }

    private final IrExpression getLitNull() {
        return JsIrBuilder.INSTANCE.buildNull(this.context.getIrBuiltIns().getNothingNType());
    }

    @Override
    public void lower(@NotNull IrBody irBody, @NotNull IrDeclaration container) {
        Intrinsics.checkNotNullParameter(irBody, "irBody");
        Intrinsics.checkNotNullParameter(container, "container");
        IrElementTransformer irElementTransformer = new IrElementTransformer<IrDeclarationParent>(this){
            final /* synthetic */ TypeOperatorLowering this$0;
            {
                this.this$0 = $receiver;
            }

            public IrStatement visitDeclaration(IrDeclarationBase declaration, IrDeclarationParent data) {
                Intrinsics.checkNotNullParameter(declaration, "declaration");
                Intrinsics.checkNotNullParameter(data, "data");
                IrDeclarationParent irDeclarationParent = declaration instanceof IrDeclarationParent ? (IrDeclarationParent)((Object)declaration) : null;
                if (irDeclarationParent == null) {
                    irDeclarationParent = data;
                }
                return IrElementTransformer.DefaultImpls.visitDeclaration(this, declaration, irDeclarationParent);
            }

            public IrExpression visitTypeOperator(IrTypeOperatorCall expression2, IrDeclarationParent data) {
                IrExpression irExpression;
                Intrinsics.checkNotNullParameter(expression2, "expression");
                Intrinsics.checkNotNullParameter(data, "data");
                IrElementTransformer.DefaultImpls.visitTypeOperator(this, expression2, data);
                switch (lower.WhenMappings.$EnumSwitchMapping$0[expression2.getOperator().ordinal()]) {
                    case 1: {
                        irExpression = this.lowerImplicitCast(expression2, data);
                        break;
                    }
                    case 2: {
                        irExpression = this.lowerImplicitDynamicCast(expression2, data);
                        break;
                    }
                    case 3: {
                        irExpression = this.lowerCoercionToUnit(expression2);
                        break;
                    }
                    case 4: {
                        irExpression = this.lowerIntegerCoercion(expression2, data);
                        break;
                    }
                    case 5: {
                        irExpression = this.lowerImplicitNotNull(expression2, data);
                        break;
                    }
                    case 6: {
                        irExpression = this.lowerInstanceOf(expression2, data, false);
                        break;
                    }
                    case 7: {
                        irExpression = this.lowerInstanceOf(expression2, data, true);
                        break;
                    }
                    case 8: {
                        irExpression = this.lowerCast(expression2, data, false);
                        break;
                    }
                    case 9: {
                        irExpression = this.lowerCast(expression2, data, true);
                        break;
                    }
                    case 10: {
                        irExpression = expression2;
                        break;
                    }
                    case 11: {
                        String string2 = "SAM conversion: " + RenderIrElementKt.render$default(expression2, null, 1, null);
                        throw new NotImplementedError("An operation is not implemented: " + string2);
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return irExpression;
            }

            private final IrExpression lowerImplicitNotNull(IrTypeOperatorCall expression2, IrDeclarationParent declaration) {
                boolean bl;
                boolean bl2 = bl = expression2.getOperator() == IrTypeOperator.IMPLICIT_NOTNULL;
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                bl = org.jetbrains.kotlin.ir.types.IrTypeUtilsKt.isNullable(expression2.getTypeOperand()) ^ org.jetbrains.kotlin.ir.types.IrTypeUtilsKt.isNullable(expression2.getArgument().getType());
                if (_Assertions.ENABLED && !bl) {
                    String string3 = "Assertion failed";
                    throw new AssertionError((Object)string3);
                }
                List newStatements = new ArrayList<E>();
                Function0<IrExpression> argument = this.cacheValue(expression2.getArgument(), newStatements, declaration);
                IrCall irNullCheck = this.nullCheck(argument.invoke());
                ((Collection)newStatements).add(JsIrBuilder.buildIfElse$default(JsIrBuilder.INSTANCE, expression2.getTypeOperand(), irNullCheck, JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, TypeOperatorLowering.access$getThrowNPE$p(this.this$0), null, null, null, null, 30, null), argument.invoke(), 0, 0, 0, 0, 240, null));
                IrTypeOperatorCall $this$lowerImplicitNotNull_u24lambda_u240 = expression2;
                boolean bl3 = false;
                return new IrCompositeImpl($this$lowerImplicitNotNull_u24lambda_u240.getStartOffset(), $this$lowerImplicitNotNull_u24lambda_u240.getEndOffset(), $this$lowerImplicitNotNull_u24lambda_u240.getTypeOperand(), null, newStatements);
            }

            private final boolean needBoxingOrUnboxing(IrType fromType, IrType toType) {
                return TypeOperatorLowering.access$getIcUtils$p(this.this$0).getInlinedClass(fromType) != null ^ TypeOperatorLowering.access$getIcUtils$p(this.this$0).getInlinedClass(toType) != null || IrTypePredicatesKt.isUnit(fromType) && !IrTypePredicatesKt.isUnit(toType);
            }

            private final IrExpression wrapWithUnsafeCast(IrTypeOperatorCall $this$wrapWithUnsafeCast, IrExpression arg) {
                return !this.needBoxingOrUnboxing(arg.getType(), $this$wrapWithUnsafeCast.getTypeOperand()) ? (IrExpression)BuildersKt.IrTypeOperatorCallImpl($this$wrapWithUnsafeCast.getStartOffset(), $this$wrapWithUnsafeCast.getEndOffset(), $this$wrapWithUnsafeCast.getType(), IrTypeOperator.REINTERPRET_CAST, $this$wrapWithUnsafeCast.getTypeOperand(), arg) : arg;
            }

            private final IrExpression lowerCast(IrTypeOperatorCall expression2, IrDeclarationParent declaration, boolean isSafe) {
                boolean bl;
                IrTypeOperator operator = expression2.getOperator();
                boolean bl2 = bl = operator == IrTypeOperator.CAST || operator == IrTypeOperator.SAFE_CAST || operator == IrTypeOperator.IMPLICIT_CAST || operator == IrTypeOperator.IMPLICIT_DYNAMIC_CAST;
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                boolean bl3 = bl = operator == IrTypeOperator.SAFE_CAST == isSafe;
                if (_Assertions.ENABLED && !bl) {
                    String string3 = "Assertion failed";
                    throw new AssertionError((Object)string3);
                }
                IrType toType = expression2.getTypeOperand();
                IrExpression failResult = isSafe ? TypeOperatorLowering.access$getLitNull(this.this$0) : (IrExpression)JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, TypeOperatorLowering.access$getThrowCCE$p(this.this$0), null, null, null, null, 30, null);
                List newStatements = new ArrayList<E>();
                Function0<IrExpression> argument = this.cacheValue(expression2.getArgument(), newStatements, declaration);
                IrExpression check2 = this.generateTypeCheck(argument, toType);
                IrExpression castedValue = this.wrapWithUnsafeCast(expression2, argument.invoke());
                ((Collection)newStatements).add(JsIrBuilder.buildIfElse$default(JsIrBuilder.INSTANCE, expression2.getType(), check2, castedValue, failResult, 0, 0, 0, 0, 240, null));
                IrTypeOperatorCall $this$lowerCast_u24lambda_u241 = expression2;
                boolean bl4 = false;
                return new IrCompositeImpl($this$lowerCast_u24lambda_u241.getStartOffset(), $this$lowerCast_u24lambda_u241.getEndOffset(), expression2.getType(), null, newStatements);
            }

            private final IrExpression lowerImplicitCast(IrTypeOperatorCall expression2, IrDeclarationParent data) {
                boolean bl;
                IrTypeOperatorCall irTypeOperatorCall = expression2;
                TypeOperatorLowering typeOperatorLowering = this.this$0;
                IrTypeOperatorCall $this$lowerImplicitCast_u24lambda_u242 = irTypeOperatorCall;
                boolean bl2 = false;
                boolean bl3 = bl = $this$lowerImplicitCast_u24lambda_u242.getOperator() == IrTypeOperator.IMPLICIT_CAST;
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                return TypeOperatorLowering.access$getDevMode$p(typeOperatorLowering) ? this.lowerCast(expression2, data, false) : this.wrapWithUnsafeCast($this$lowerImplicitCast_u24lambda_u242, $this$lowerImplicitCast_u24lambda_u242.getArgument());
            }

            private final IrExpression lowerImplicitDynamicCast(IrTypeOperatorCall expression2, IrDeclarationParent data) {
                boolean bl;
                IrTypeOperatorCall irTypeOperatorCall = expression2;
                TypeOperatorLowering typeOperatorLowering = this.this$0;
                IrTypeOperatorCall $this$lowerImplicitDynamicCast_u24lambda_u243 = irTypeOperatorCall;
                boolean bl2 = false;
                boolean bl3 = bl = $this$lowerImplicitDynamicCast_u24lambda_u243.getOperator() == IrTypeOperator.IMPLICIT_DYNAMIC_CAST;
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                return TypeOperatorLowering.access$getDevMode$p(typeOperatorLowering) ? this.lowerCast(expression2, data, false) : this.wrapWithUnsafeCast($this$lowerImplicitDynamicCast_u24lambda_u243, $this$lowerImplicitDynamicCast_u24lambda_u243.getArgument());
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private final boolean advancedCheckRequired(IrType type2) {
                if (IrTypeUtilsKt.isInterface(type2)) return true;
                if (IrTypeUtilsKt.isTypeParameter(type2)) {
                    boolean bl;
                    Iterable $this$any$iv = IrTypeUtilsKt.superTypes(type2);
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            IrType it = (IrType)element$iv;
                            boolean bl2 = false;
                            if (!IrTypeUtilsKt.isInterface(it)) continue;
                            return true;
                        }
                        bl = false;
                    }
                    if (bl) return true;
                }
                if (IrTypePredicatesKt.isArray(type2)) return true;
                if (IrTypeUtilsKt.isPrimitiveArray(type2)) return true;
                if (!this.isTypeOfCheckingType(type2)) return false;
                return true;
            }

            private final boolean isTypeOfCheckingType(IrType type2) {
                return IrTypePredicatesKt.isByte(type2) || IrTypePredicatesKt.isShort(type2) || IrTypePredicatesKt.isInt(type2) || IrTypePredicatesKt.isFloat(type2) || IrTypePredicatesKt.isDouble(type2) || IrTypePredicatesKt.isBoolean(type2) || IrTypeUtilsKt.isFunctionOrKFunction(type2) || IrTypePredicatesKt.isString(type2);
            }

            public final IrExpression lowerInstanceOf(IrTypeOperatorCall expression2, IrDeclarationParent declaration, boolean inverted) {
                boolean bl;
                Intrinsics.checkNotNullParameter(expression2, "expression");
                Intrinsics.checkNotNullParameter(declaration, "declaration");
                boolean bl2 = bl = expression2.getOperator() == IrTypeOperator.INSTANCEOF || expression2.getOperator() == IrTypeOperator.NOT_INSTANCEOF;
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                boolean bl3 = bl = expression2.getOperator() == IrTypeOperator.NOT_INSTANCEOF == inverted;
                if (_Assertions.ENABLED && !bl) {
                    String string3 = "Assertion failed";
                    throw new AssertionError((Object)string3);
                }
                IrType toType = expression2.getTypeOperand();
                List newStatements = new ArrayList<E>();
                Function0<IrExpression> argument = this.cacheValue(expression2.getArgument(), newStatements, declaration);
                IrExpression check2 = this.generateTypeCheck(argument, toType);
                IrExpression result2 = inverted ? TypeOperatorLowering.access$getCalculator$p(this.this$0).not(check2) : check2;
                ((Collection)newStatements).add(result2);
                return new IrCompositeImpl(expression2.getStartOffset(), expression2.getEndOffset(), this.this$0.getContext().getIrBuiltIns().getBooleanType(), null, newStatements);
            }

            private final IrCall nullCheck(IrExpression value2) {
                IrCall irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, TypeOperatorLowering.access$getEqeq$p(this.this$0), null, null, null, null, 30, null);
                TypeOperatorLowering typeOperatorLowering = this.this$0;
                IrCall $this$nullCheck_u24lambda_u245 = irCall;
                boolean bl = false;
                $this$nullCheck_u24lambda_u245.putValueArgument(0, value2);
                $this$nullCheck_u24lambda_u245.putValueArgument(1, TypeOperatorLowering.access$getLitNull(typeOperatorLowering));
                return irCall;
            }

            private final Function0<IrExpression> cacheValue(IrExpression value2, List<IrStatement> newStatements, IrDeclarationParent declaration) {
                Function0<IrExpression> function0;
                if (org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.isPure$default(value2, true, false, null, 4, null)) {
                    function0 = () -> lower.1.cacheValue$lambda$6(value2);
                } else {
                    IrVariable varDeclaration = JsIrBuilder.buildVar$default(JsIrBuilder.INSTANCE, value2.getType(), declaration, null, false, false, false, value2, null, 188, null);
                    ((Collection)newStatements).add(varDeclaration);
                    function0 = () -> lower.1.cacheValue$lambda$7(varDeclaration);
                }
                return function0;
            }

            private final IrExpression generateTypeCheck(Function0<? extends IrExpression> argument, IrType toType) {
                IrExpression irExpression;
                IrType toNotNullable = IrTypesKt.makeNotNull(toType);
                IrExpression argumentInstance = argument.invoke();
                IrExpression instanceCheck = this.generateTypeCheckNonNull(argumentInstance, toNotNullable);
                boolean isFromNullable = org.jetbrains.kotlin.ir.types.IrTypeUtilsKt.isNullable(argumentInstance.getType());
                boolean isToNullable = org.jetbrains.kotlin.ir.types.IrTypeUtilsKt.isNullable(toType);
                boolean isNativeCheck = !this.advancedCheckRequired(toNotNullable);
                if (!isFromNullable) {
                    irExpression = instanceCheck;
                } else if (isToNullable) {
                    JsIrArithBuilder $this$generateTypeCheck_u24lambda_u248 = TypeOperatorLowering.access$getCalculator$p(this.this$0);
                    boolean bl = false;
                    irExpression = $this$generateTypeCheck_u24lambda_u248.oror(this.nullCheck(argument.invoke()), instanceCheck);
                } else if (isNativeCheck) {
                    irExpression = instanceCheck;
                } else {
                    JsIrArithBuilder $this$generateTypeCheck_u24lambda_u249 = TypeOperatorLowering.access$getCalculator$p(this.this$0);
                    boolean bl = false;
                    irExpression = $this$generateTypeCheck_u24lambda_u249.andand($this$generateTypeCheck_u24lambda_u249.not(this.nullCheck(argument.invoke())), instanceCheck);
                }
                return irExpression;
            }

            private final IrExpression generateTypeCheckNonNull(IrExpression argument, IrType toType) {
                IrExpression irExpression;
                boolean bl;
                boolean bl2 = bl = !IrTypePredicatesKt.isMarkedNullable(toType);
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                if (toType instanceof IrDynamicType) {
                    irExpression = argument;
                } else if (IrTypePredicatesKt.isAny(toType)) {
                    irExpression = this.generateIsObjectCheck(argument);
                } else if (IrTypePredicatesKt.isNothing(toType)) {
                    IrExpression[] irExpressionArray = new IrExpression[]{argument, TypeOperatorLowering.access$getLitFalse(this.this$0)};
                    irExpression = JsIrBuilder.INSTANCE.buildComposite(this.this$0.getContext().getIrBuiltIns().getBooleanType(), CollectionsKt.listOf(irExpressionArray));
                } else if (IrTypeUtilsKt.isSuspendFunction(toType)) {
                    irExpression = this.generateSuspendFunctionCheck(argument, toType);
                } else if (this.isTypeOfCheckingType(toType)) {
                    irExpression = this.generateTypeOfCheck(argument, toType);
                } else if (IrTypePredicatesKt.isNumber(toType)) {
                    irExpression = this.generateNumberCheck(argument);
                } else if (IrTypePredicatesKt.isComparable(toType)) {
                    irExpression = this.generateComparableCheck(argument);
                } else if (IrTypePredicatesKt.isCharSequence(toType)) {
                    irExpression = this.generateCharSequenceCheck(argument);
                } else if (IrTypePredicatesKt.isArray(toType)) {
                    irExpression = this.generateGenericArrayCheck(argument);
                } else if (IrTypeUtilsKt.isPrimitiveArray(toType)) {
                    irExpression = this.generatePrimitiveArrayTypeCheck(argument, toType);
                } else if (IrTypeUtilsKt.isTypeParameter(toType)) {
                    irExpression = this.generateTypeCheckWithTypeParameter(argument, toType);
                } else if (IrTypeUtilsKt.isInterface(toType)) {
                    IrSymbolOwner irSymbolOwner = IrTypesKt.getClassifierOrFail(toType).getOwner();
                    Intrinsics.checkNotNull(irSymbolOwner, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
                    irExpression = IrUtilsKt.isEffectivelyExternal((IrClass)irSymbolOwner) ? (IrExpression)this.generateIsObjectCheck(argument) : this.generateInterfaceCheck(argument, toType);
                } else {
                    irExpression = IrTypeUtilsKt.isExternalObject(toType) ? this.generateIsExternalObject(argument, toType) : this.generateNativeInstanceOf(argument, toType);
                }
                return irExpression;
            }

            private final IrCall generateIsObjectCheck(IrExpression argument) {
                IrCall irCall;
                IrCall $this$generateIsObjectCheck_u24lambda_u2410 = irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, TypeOperatorLowering.access$getBooleanNot$p(this.this$0), null, null, null, null, 30, null);
                boolean bl = false;
                $this$generateIsObjectCheck_u24lambda_u2410.setDispatchReceiver(this.nullCheck(argument));
                return irCall;
            }

            /*
             * WARNING - void declaration
             */
            private final IrExpression generateTypeCheckWithTypeParameter(IrExpression argument, IrType toType) {
                void $this$fold$iv;
                void initial$iv;
                IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrNull(toType);
                IrTypeParameterSymbol irTypeParameterSymbol = irClassifierSymbol instanceof IrTypeParameterSymbol ? (IrTypeParameterSymbol)irClassifierSymbol : null;
                if (irTypeParameterSymbol == null) {
                    CompilationExceptionKt.compilationException("expected type parameter, but " + toType, argument);
                    throw null;
                }
                IrTypeParameterSymbol typeParameterSymbol = irTypeParameterSymbol;
                IrTypeParameter typeParameter = (IrTypeParameter)typeParameterSymbol.getOwner();
                Iterable iterable = typeParameter.getSuperTypes();
                Object var7_7 = null;
                TypeOperatorLowering typeOperatorLowering = this.this$0;
                boolean $i$f$fold = false;
                IrExpression accumulator$iv = initial$iv;
                for (T element$iv : $this$fold$iv) {
                    void t;
                    IrType irType = (IrType)element$iv;
                    void r = accumulator$iv;
                    boolean bl = false;
                    IrExpression irExpression = IrUtilsKt.shallowCopyOrNull(argument);
                    if (irExpression == null) {
                        IrElement $this$deepCopyWithSymbols_u24default$iv = argument;
                        IrDeclarationParent initialParent$iv = null;
                        boolean $i$f$deepCopyWithSymbols = false;
                        IrElement $this$deepCopyImpl$iv$iv = $this$deepCopyWithSymbols_u24default$iv;
                        boolean $i$f$deepCopyImpl = false;
                        DeepCopySymbolRemapper symbolRemapper$iv$iv = new DeepCopySymbolRemapper(null, 1, null);
                        IrVisitorsKt.acceptVoid($this$deepCopyImpl$iv$iv, symbolRemapper$iv$iv);
                        DeepCopySymbolRemapper deepCopySymbolRemapper = symbolRemapper$iv$iv;
                        boolean bl2 = false;
                        ReferencedSymbolRemapper p0 = deepCopySymbolRemapper;
                        TypeRemapper typeRemapper$iv$iv = new DeepCopyTypeRemapper(p0);
                        IrElement irElement = $this$deepCopyImpl$iv$iv.transform(new DeepCopyIrTreeWithSymbols(symbolRemapper$iv$iv, typeRemapper$iv$iv, null, 4, null), null);
                        if (irElement == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpression");
                        }
                        irExpression = (IrExpression)PatchDeclarationParentsKt.patchDeclarationParents((IrElement)((IrExpression)irElement), initialParent$iv);
                    }
                    IrExpression copy = irExpression;
                    IrExpression check2 = this.generateTypeCheckNonNull(copy, IrTypesKt.makeNotNull((IrType)t));
                    accumulator$iv = r == null ? check2 : (IrExpression)TypeOperatorLowering.access$getCalculator$p(typeOperatorLowering).andand((IrExpression)r, check2);
                }
                IrExpression irExpression = accumulator$iv;
                if (irExpression == null) {
                    irExpression = TypeOperatorLowering.access$getLitTrue(this.this$0);
                }
                return irExpression;
            }

            private final IrExpression generateSuspendFunctionCheck(IrExpression argument, IrType toType) {
                IrCall irCall;
                IrSymbolOwner irSymbolOwner = IrTypesKt.getClassifierOrFail(toType).getOwner();
                Intrinsics.checkNotNull(irSymbolOwner, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
                int arity = ((IrClass)irSymbolOwner).getTypeParameters().size() - 1;
                IrBuiltIns irBuiltIns = this.this$0.getContext().getIrBuiltIns();
                IrCall $this$generateSuspendFunctionCheck_u24lambda_u2412 = irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, TypeOperatorLowering.access$isSuspendFunctionSymbol$p(this.this$0), irBuiltIns.getBooleanType(), null, null, null, 28, null);
                boolean bl = false;
                $this$generateSuspendFunctionCheck_u24lambda_u2412.putValueArgument(0, argument);
                $this$generateSuspendFunctionCheck_u24lambda_u2412.putValueArgument(1, JsIrBuilder.INSTANCE.buildInt(irBuiltIns.getIntType(), arity));
                return irCall;
            }

            private final IrExpression generateTypeOfCheck(IrExpression argument, IrType toType) {
                IrCall irCall;
                IrConstImpl marker = IrTypeUtilsKt.isFunctionOrKFunction(toType) ? TypeOperatorLowering.access$getFunctionMarker(this.this$0) : (IrTypePredicatesKt.isBoolean(toType) ? TypeOperatorLowering.access$getBooleanMarker(this.this$0) : (IrTypePredicatesKt.isString(toType) ? TypeOperatorLowering.access$getStringMarker(this.this$0) : TypeOperatorLowering.access$getNumberMarker(this.this$0)));
                IrCall $this$generateTypeOfCheck_u24lambda_u2413 = irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, TypeOperatorLowering.access$getTypeOfIntrinsicSymbol$p(this.this$0), null, null, null, null, 30, null);
                boolean bl = false;
                $this$generateTypeOfCheck_u24lambda_u2413.putValueArgument(0, argument);
                IrCall typeOf = irCall;
                IrCall $this$generateTypeOfCheck_u24lambda_u2414 = irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, TypeOperatorLowering.access$getEqeq$p(this.this$0), null, null, null, null, 30, null);
                boolean bl2 = false;
                $this$generateTypeOfCheck_u24lambda_u2414.putValueArgument(0, typeOf);
                $this$generateTypeOfCheck_u24lambda_u2414.putValueArgument(1, marker);
                return irCall;
            }

            private final IrCall wrapTypeReference(IrType toType) {
                IrCall irCall;
                IrCall $this$wrapTypeReference_u24lambda_u2415 = irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, TypeOperatorLowering.access$getJsClassIntrinsicSymbol$p(this.this$0), null, null, null, null, 30, null);
                boolean bl = false;
                $this$wrapTypeReference_u24lambda_u2415.putTypeArgument(0, toType);
                return irCall;
            }

            private final IrCall generateGenericArrayCheck(IrExpression argument) {
                IrCall irCall;
                IrCall $this$generateGenericArrayCheck_u24lambda_u2416 = irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, TypeOperatorLowering.access$isArraySymbol(this.this$0), null, null, null, null, 30, null);
                boolean bl = false;
                $this$generateGenericArrayCheck_u24lambda_u2416.putValueArgument(0, argument);
                return irCall;
            }

            private final IrCall generateNumberCheck(IrExpression argument) {
                IrCall irCall;
                IrCall $this$generateNumberCheck_u24lambda_u2417 = irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, this.this$0.getContext().getIntrinsics().isNumberSymbol(), null, null, null, null, 30, null);
                boolean bl = false;
                $this$generateNumberCheck_u24lambda_u2417.putValueArgument(0, argument);
                return irCall;
            }

            private final IrCall generateComparableCheck(IrExpression argument) {
                IrCall irCall;
                IrCall $this$generateComparableCheck_u24lambda_u2418 = irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, this.this$0.getContext().getIntrinsics().isComparableSymbol(), null, null, null, null, 30, null);
                boolean bl = false;
                $this$generateComparableCheck_u24lambda_u2418.putValueArgument(0, argument);
                return irCall;
            }

            private final IrCall generateCharSequenceCheck(IrExpression argument) {
                IrCall irCall;
                IrCall $this$generateCharSequenceCheck_u24lambda_u2419 = irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, this.this$0.getContext().getIntrinsics().isCharSequenceSymbol(), null, null, null, null, 30, null);
                boolean bl = false;
                $this$generateCharSequenceCheck_u24lambda_u2419.putValueArgument(0, argument);
                return irCall;
            }

            private final IrExpression generatePrimitiveArrayTypeCheck(IrExpression argument, IrType toType) {
                IrCall irCall;
                IrSimpleFunctionSymbol irSimpleFunctionSymbol = this.this$0.getContext().getIntrinsics().isPrimitiveArray().get((Object)((Object)IrTypeUtilsKt.getPrimitiveArrayElementType(toType)));
                Intrinsics.checkNotNull(irSimpleFunctionSymbol);
                IrSimpleFunctionSymbol f = irSimpleFunctionSymbol;
                IrCall $this$generatePrimitiveArrayTypeCheck_u24lambda_u2420 = irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, f, null, null, null, null, 30, null);
                boolean bl = false;
                $this$generatePrimitiveArrayTypeCheck_u24lambda_u2420.putValueArgument(0, argument);
                return irCall;
            }

            private final IrExpression generateInterfaceCheck(IrExpression argument, IrType toType) {
                IrCall irCall;
                IrCall irType = this.wrapTypeReference(toType);
                IrCall $this$generateInterfaceCheck_u24lambda_u2421 = irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, TypeOperatorLowering.access$isInterfaceSymbol(this.this$0), null, null, null, null, 30, null);
                boolean bl = false;
                $this$generateInterfaceCheck_u24lambda_u2421.putValueArgument(0, argument);
                $this$generateInterfaceCheck_u24lambda_u2421.putValueArgument(1, irType);
                return irCall;
            }

            private final IrExpression generateIsExternalObject(IrExpression argument, IrType toType) {
                IrCall irCall;
                IrCall irType = this.wrapTypeReference(toType);
                IrCall $this$generateIsExternalObject_u24lambda_u2422 = irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, TypeOperatorLowering.access$isExternalObjectSymbol$p(this.this$0), null, null, null, null, 30, null);
                boolean bl = false;
                $this$generateIsExternalObject_u24lambda_u2422.putValueArgument(0, argument);
                $this$generateIsExternalObject_u24lambda_u2422.putValueArgument(1, irType);
                return irCall;
            }

            private final IrExpression generateNativeInstanceOf(IrExpression argument, IrType toType) {
                IrCall irCall;
                IrCall irType = this.wrapTypeReference(toType);
                IrCall $this$generateNativeInstanceOf_u24lambda_u2423 = irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, TypeOperatorLowering.access$getInstanceOfIntrinsicSymbol$p(this.this$0), null, null, null, null, 30, null);
                boolean bl = false;
                $this$generateNativeInstanceOf_u24lambda_u2423.putValueArgument(0, argument);
                $this$generateNativeInstanceOf_u24lambda_u2423.putValueArgument(1, irType);
                return irCall;
            }

            private final IrExpression lowerCoercionToUnit(IrTypeOperatorCall expression2) {
                boolean bl;
                boolean bl2 = bl = expression2.getOperator() == IrTypeOperator.IMPLICIT_COERCION_TO_UNIT;
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                IrTypeOperatorCall irTypeOperatorCall = expression2;
                TypeOperatorLowering typeOperatorLowering = this.this$0;
                IrTypeOperatorCall $this$lowerCoercionToUnit_u24lambda_u2424 = irTypeOperatorCall;
                boolean bl3 = false;
                IrExpression[] irExpressionArray = new IrExpression[]{$this$lowerCoercionToUnit_u24lambda_u2424.getArgument(), TypeOperatorLowering.access$getUnitValue(typeOperatorLowering)};
                return new IrCompositeImpl($this$lowerCoercionToUnit_u24lambda_u2424.getStartOffset(), $this$lowerCoercionToUnit_u24lambda_u2424.getEndOffset(), TypeOperatorLowering.access$getUnit$p(typeOperatorLowering), null, CollectionsKt.listOf(irExpressionArray));
            }

            private final IrExpression lowerIntegerCoercion(IrTypeOperatorCall expression2, IrDeclarationParent declaration) {
                IrExpression irExpression;
                boolean bl;
                boolean bl2 = bl = expression2.getOperator() == IrTypeOperator.IMPLICIT_INTEGER_COERCION;
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                bl = IrTypePredicatesKt.isInt(expression2.getArgument().getType());
                if (_Assertions.ENABLED && !bl) {
                    String string3 = "Assertion failed";
                    throw new AssertionError((Object)string3);
                }
                boolean isNullable = org.jetbrains.kotlin.ir.types.IrTypeUtilsKt.isNullable(expression2.getArgument().getType());
                IrType toType = expression2.getTypeOperand();
                List newStatements = new ArrayList<E>();
                Function0<IrExpression> argument = this.cacheValue(expression2.getArgument(), newStatements, declaration);
                if (IrTypePredicatesKt.isByte(toType)) {
                    irExpression = lower.1.lowerIntegerCoercion$maskOp(this.this$0, argument.invoke(), TypeOperatorLowering.access$getByteMask(this.this$0), TypeOperatorLowering.access$getLit24(this.this$0));
                } else if (IrTypePredicatesKt.isShort(toType)) {
                    irExpression = lower.1.lowerIntegerCoercion$maskOp(this.this$0, argument.invoke(), TypeOperatorLowering.access$getShortMask(this.this$0), TypeOperatorLowering.access$getLit16(this.this$0));
                } else if (IrTypePredicatesKt.isLong(toType)) {
                    IrCall irCall;
                    IrCall $this$lowerIntegerCoercion_u24lambda_u2426 = irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, this.this$0.getContext().getIntrinsics().getJsToLong(), null, null, null, null, 30, null);
                    boolean bl3 = false;
                    $this$lowerIntegerCoercion_u24lambda_u2426.putValueArgument(0, argument.invoke());
                    irExpression = irCall;
                } else {
                    CompilationExceptionKt.compilationException("Unreachable execution (coercion to non-Integer type)", expression2);
                    throw null;
                }
                IrExpression casted = irExpression;
                ((Collection)newStatements).add(isNullable ? (IrExpression)JsIrBuilder.buildIfElse$default(JsIrBuilder.INSTANCE, toType, this.nullCheck(argument.invoke()), TypeOperatorLowering.access$getLitNull(this.this$0), casted, 0, 0, 0, 0, 240, null) : casted);
                IrTypeOperatorCall $this$lowerIntegerCoercion_u24lambda_u2427 = expression2;
                boolean bl4 = false;
                return new IrCompositeImpl($this$lowerIntegerCoercion_u24lambda_u2427.getStartOffset(), $this$lowerIntegerCoercion_u24lambda_u2427.getEndOffset(), toType, null, newStatements);
            }

            public IrElement visitElement(IrElement element, IrDeclarationParent data) {
                return IrElementTransformer.DefaultImpls.visitElement(this, element, data);
            }

            public IrStatement visitValueParameter(IrValueParameter declaration, IrDeclarationParent data) {
                return IrElementTransformer.DefaultImpls.visitValueParameter(this, declaration, data);
            }

            public IrStatement visitClass(IrClass declaration, IrDeclarationParent data) {
                return IrElementTransformer.DefaultImpls.visitClass(this, declaration, data);
            }

            public IrStatement visitAnonymousInitializer(IrAnonymousInitializer declaration, IrDeclarationParent data) {
                return IrElementTransformer.DefaultImpls.visitAnonymousInitializer(this, declaration, data);
            }

            public IrStatement visitTypeParameter(IrTypeParameter declaration, IrDeclarationParent data) {
                return IrElementTransformer.DefaultImpls.visitTypeParameter(this, declaration, data);
            }

            public IrStatement visitFunction(IrFunction declaration, IrDeclarationParent data) {
                return IrElementTransformer.DefaultImpls.visitFunction(this, declaration, data);
            }

            public IrStatement visitConstructor(IrConstructor declaration, IrDeclarationParent data) {
                return IrElementTransformer.DefaultImpls.visitConstructor(this, declaration, data);
            }

            public IrStatement visitEnumEntry(IrEnumEntry declaration, IrDeclarationParent data) {
                return IrElementTransformer.DefaultImpls.visitEnumEntry(this, declaration, data);
            }

            public IrStatement visitErrorDeclaration(IrErrorDeclaration declaration, IrDeclarationParent data) {
                return IrElementTransformer.DefaultImpls.visitErrorDeclaration(this, declaration, data);
            }

            public IrStatement visitField(IrField declaration, IrDeclarationParent data) {
                return IrElementTransformer.DefaultImpls.visitField(this, declaration, data);
            }

            public IrStatement visitLocalDelegatedProperty(IrLocalDelegatedProperty declaration, IrDeclarationParent data) {
                return IrElementTransformer.DefaultImpls.visitLocalDelegatedProperty(this, declaration, data);
            }

            public IrModuleFragment visitModuleFragment(IrModuleFragment declaration, IrDeclarationParent data) {
                return IrElementTransformer.DefaultImpls.visitModuleFragment(this, declaration, data);
            }

            public IrStatement visitProperty(IrProperty declaration, IrDeclarationParent data) {
                return IrElementTransformer.DefaultImpls.visitProperty(this, declaration, data);
            }

            public IrStatement visitScript(IrScript declaration, IrDeclarationParent data) {
                return IrElementTransformer.DefaultImpls.visitScript(this, declaration, data);
            }

            public IrStatement visitSimpleFunction(IrSimpleFunction declaration, IrDeclarationParent data) {
                return IrElementTransformer.DefaultImpls.visitSimpleFunction(this, declaration, data);
            }

            public IrStatement visitTypeAlias(IrTypeAlias declaration, IrDeclarationParent data) {
                return IrElementTransformer.DefaultImpls.visitTypeAlias(this, declaration, data);
            }

            public IrStatement visitVariable(IrVariable declaration, IrDeclarationParent data) {
                return IrElementTransformer.DefaultImpls.visitVariable(this, declaration, data);
            }

            public IrElement visitPackageFragment(IrPackageFragment declaration, IrDeclarationParent data) {
                return IrElementTransformer.DefaultImpls.visitPackageFragment(this, declaration, data);
            }

            public IrExternalPackageFragment visitExternalPackageFragment(IrExternalPackageFragment declaration, IrDeclarationParent data) {
                return IrElementTransformer.DefaultImpls.visitExternalPackageFragment(this, declaration, data);
            }

            public IrFile visitFile(IrFile declaration, IrDeclarationParent data) {
                return IrElementTransformer.DefaultImpls.visitFile(this, declaration, data);
            }

            public IrExpression visitExpression(IrExpression expression2, IrDeclarationParent data) {
                return IrElementTransformer.DefaultImpls.visitExpression(this, expression2, data);
            }

            public IrBody visitBody(IrBody body2, IrDeclarationParent data) {
                return IrElementTransformer.DefaultImpls.visitBody(this, body2, data);
            }

            public IrBody visitExpressionBody(IrExpressionBody body2, IrDeclarationParent data) {
                return IrElementTransformer.DefaultImpls.visitExpressionBody(this, body2, data);
            }

            public IrBody visitBlockBody(IrBlockBody body2, IrDeclarationParent data) {
                return IrElementTransformer.DefaultImpls.visitBlockBody(this, body2, data);
            }

            public IrExpression visitDeclarationReference(IrDeclarationReference expression2, IrDeclarationParent data) {
                return IrElementTransformer.DefaultImpls.visitDeclarationReference(this, expression2, data);
            }

            public IrElement visitMemberAccess(IrMemberAccessExpression<?> expression2, IrDeclarationParent data) {
                return IrElementTransformer.DefaultImpls.visitMemberAccess(this, expression2, data);
            }

            public IrElement visitFunctionAccess(IrFunctionAccessExpression expression2, IrDeclarationParent data) {
                return IrElementTransformer.DefaultImpls.visitFunctionAccess(this, expression2, data);
            }

            public IrElement visitConstructorCall(IrConstructorCall expression2, IrDeclarationParent data) {
                return IrElementTransformer.DefaultImpls.visitConstructorCall(this, expression2, data);
            }

            public IrExpression visitSingletonReference(IrGetSingletonValue expression2, IrDeclarationParent data) {
                return IrElementTransformer.DefaultImpls.visitSingletonReference(this, expression2, data);
            }

            public IrExpression visitGetObjectValue(IrGetObjectValue expression2, IrDeclarationParent data) {
                return IrElementTransformer.DefaultImpls.visitGetObjectValue(this, expression2, data);
            }

            public IrExpression visitGetEnumValue(IrGetEnumValue expression2, IrDeclarationParent data) {
                return IrElementTransformer.DefaultImpls.visitGetEnumValue(this, expression2, data);
            }

            public IrExpression visitRawFunctionReference(IrRawFunctionReference expression2, IrDeclarationParent data) {
                return IrElementTransformer.DefaultImpls.visitRawFunctionReference(this, expression2, data);
            }

            public IrExpression visitContainerExpression(IrContainerExpression expression2, IrDeclarationParent data) {
                return IrElementTransformer.DefaultImpls.visitContainerExpression(this, expression2, data);
            }

            public IrExpression visitBlock(IrBlock expression2, IrDeclarationParent data) {
                return IrElementTransformer.DefaultImpls.visitBlock(this, expression2, data);
            }

            public IrExpression visitComposite(IrComposite expression2, IrDeclarationParent data) {
                return IrElementTransformer.DefaultImpls.visitComposite(this, expression2, data);
            }

            public IrExpression visitReturnableBlock(IrReturnableBlock expression2, IrDeclarationParent data) {
                return IrElementTransformer.DefaultImpls.visitReturnableBlock(this, expression2, data);
            }

            public IrExpression visitInlinedFunctionBlock(IrInlinedFunctionBlock inlinedBlock, IrDeclarationParent data) {
                return IrElementTransformer.DefaultImpls.visitInlinedFunctionBlock(this, inlinedBlock, data);
            }

            public IrBody visitSyntheticBody(IrSyntheticBody body2, IrDeclarationParent data) {
                return IrElementTransformer.DefaultImpls.visitSyntheticBody(this, body2, data);
            }

            public IrExpression visitBreakContinue(IrBreakContinue jump, IrDeclarationParent data) {
                return IrElementTransformer.DefaultImpls.visitBreakContinue(this, jump, data);
            }

            public IrExpression visitBreak(IrBreak jump, IrDeclarationParent data) {
                return IrElementTransformer.DefaultImpls.visitBreak(this, jump, data);
            }

            public IrExpression visitContinue(IrContinue jump, IrDeclarationParent data) {
                return IrElementTransformer.DefaultImpls.visitContinue(this, jump, data);
            }

            public IrElement visitCall(IrCall expression2, IrDeclarationParent data) {
                return IrElementTransformer.DefaultImpls.visitCall(this, expression2, data);
            }

            public IrElement visitCallableReference(IrCallableReference<?> expression2, IrDeclarationParent data) {
                return IrElementTransformer.DefaultImpls.visitCallableReference(this, expression2, data);
            }

            public IrElement visitFunctionReference(IrFunctionReference expression2, IrDeclarationParent data) {
                return IrElementTransformer.DefaultImpls.visitFunctionReference(this, expression2, data);
            }

            public IrElement visitPropertyReference(IrPropertyReference expression2, IrDeclarationParent data) {
                return IrElementTransformer.DefaultImpls.visitPropertyReference(this, expression2, data);
            }

            public IrElement visitLocalDelegatedPropertyReference(IrLocalDelegatedPropertyReference expression2, IrDeclarationParent data) {
                return IrElementTransformer.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data);
            }

            public IrExpression visitClassReference(IrClassReference expression2, IrDeclarationParent data) {
                return IrElementTransformer.DefaultImpls.visitClassReference(this, expression2, data);
            }

            public IrExpression visitConst(IrConst<?> expression2, IrDeclarationParent data) {
                return IrElementTransformer.DefaultImpls.visitConst(this, expression2, data);
            }

            public IrConstantValue visitConstantValue(IrConstantValue expression2, IrDeclarationParent data) {
                return IrElementTransformer.DefaultImpls.visitConstantValue(this, expression2, data);
            }

            public IrConstantValue visitConstantPrimitive(IrConstantPrimitive expression2, IrDeclarationParent data) {
                return IrElementTransformer.DefaultImpls.visitConstantPrimitive(this, expression2, data);
            }

            public IrConstantValue visitConstantObject(IrConstantObject expression2, IrDeclarationParent data) {
                return IrElementTransformer.DefaultImpls.visitConstantObject(this, expression2, data);
            }

            public IrConstantValue visitConstantArray(IrConstantArray expression2, IrDeclarationParent data) {
                return IrElementTransformer.DefaultImpls.visitConstantArray(this, expression2, data);
            }

            public IrElement visitDelegatingConstructorCall(IrDelegatingConstructorCall expression2, IrDeclarationParent data) {
                return IrElementTransformer.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data);
            }

            public IrExpression visitDynamicExpression(IrDynamicExpression expression2, IrDeclarationParent data) {
                return IrElementTransformer.DefaultImpls.visitDynamicExpression(this, expression2, data);
            }

            public IrExpression visitDynamicOperatorExpression(IrDynamicOperatorExpression expression2, IrDeclarationParent data) {
                return IrElementTransformer.DefaultImpls.visitDynamicOperatorExpression(this, expression2, data);
            }

            public IrExpression visitDynamicMemberExpression(IrDynamicMemberExpression expression2, IrDeclarationParent data) {
                return IrElementTransformer.DefaultImpls.visitDynamicMemberExpression(this, expression2, data);
            }

            public IrElement visitEnumConstructorCall(IrEnumConstructorCall expression2, IrDeclarationParent data) {
                return IrElementTransformer.DefaultImpls.visitEnumConstructorCall(this, expression2, data);
            }

            public IrExpression visitErrorExpression(IrErrorExpression expression2, IrDeclarationParent data) {
                return IrElementTransformer.DefaultImpls.visitErrorExpression(this, expression2, data);
            }

            public IrExpression visitErrorCallExpression(IrErrorCallExpression expression2, IrDeclarationParent data) {
                return IrElementTransformer.DefaultImpls.visitErrorCallExpression(this, expression2, data);
            }

            public IrExpression visitFieldAccess(IrFieldAccessExpression expression2, IrDeclarationParent data) {
                return IrElementTransformer.DefaultImpls.visitFieldAccess(this, expression2, data);
            }

            public IrExpression visitGetField(IrGetField expression2, IrDeclarationParent data) {
                return IrElementTransformer.DefaultImpls.visitGetField(this, expression2, data);
            }

            public IrExpression visitSetField(IrSetField expression2, IrDeclarationParent data) {
                return IrElementTransformer.DefaultImpls.visitSetField(this, expression2, data);
            }

            public IrElement visitFunctionExpression(IrFunctionExpression expression2, IrDeclarationParent data) {
                return IrElementTransformer.DefaultImpls.visitFunctionExpression(this, expression2, data);
            }

            public IrExpression visitGetClass(IrGetClass expression2, IrDeclarationParent data) {
                return IrElementTransformer.DefaultImpls.visitGetClass(this, expression2, data);
            }

            public IrExpression visitInstanceInitializerCall(IrInstanceInitializerCall expression2, IrDeclarationParent data) {
                return IrElementTransformer.DefaultImpls.visitInstanceInitializerCall(this, expression2, data);
            }

            public IrExpression visitLoop(IrLoop loop, IrDeclarationParent data) {
                return IrElementTransformer.DefaultImpls.visitLoop(this, loop, data);
            }

            public IrExpression visitWhileLoop(IrWhileLoop loop, IrDeclarationParent data) {
                return IrElementTransformer.DefaultImpls.visitWhileLoop(this, loop, data);
            }

            public IrExpression visitDoWhileLoop(IrDoWhileLoop loop, IrDeclarationParent data) {
                return IrElementTransformer.DefaultImpls.visitDoWhileLoop(this, loop, data);
            }

            public IrExpression visitReturn(IrReturn expression2, IrDeclarationParent data) {
                return IrElementTransformer.DefaultImpls.visitReturn(this, expression2, data);
            }

            public IrExpression visitStringConcatenation(IrStringConcatenation expression2, IrDeclarationParent data) {
                return IrElementTransformer.DefaultImpls.visitStringConcatenation(this, expression2, data);
            }

            public IrExpression visitSuspensionPoint(IrSuspensionPoint expression2, IrDeclarationParent data) {
                return IrElementTransformer.DefaultImpls.visitSuspensionPoint(this, expression2, data);
            }

            public IrExpression visitSuspendableExpression(IrSuspendableExpression expression2, IrDeclarationParent data) {
                return IrElementTransformer.DefaultImpls.visitSuspendableExpression(this, expression2, data);
            }

            public IrExpression visitThrow(IrThrow expression2, IrDeclarationParent data) {
                return IrElementTransformer.DefaultImpls.visitThrow(this, expression2, data);
            }

            public IrExpression visitTry(IrTry aTry, IrDeclarationParent data) {
                return IrElementTransformer.DefaultImpls.visitTry(this, aTry, data);
            }

            public IrCatch visitCatch(IrCatch aCatch, IrDeclarationParent data) {
                return IrElementTransformer.DefaultImpls.visitCatch(this, aCatch, data);
            }

            public IrExpression visitValueAccess(IrValueAccessExpression expression2, IrDeclarationParent data) {
                return IrElementTransformer.DefaultImpls.visitValueAccess(this, expression2, data);
            }

            public IrExpression visitGetValue(IrGetValue expression2, IrDeclarationParent data) {
                return IrElementTransformer.DefaultImpls.visitGetValue(this, expression2, data);
            }

            public IrExpression visitSetValue(IrSetValue expression2, IrDeclarationParent data) {
                return IrElementTransformer.DefaultImpls.visitSetValue(this, expression2, data);
            }

            public IrExpression visitVararg(IrVararg expression2, IrDeclarationParent data) {
                return IrElementTransformer.DefaultImpls.visitVararg(this, expression2, data);
            }

            public IrSpreadElement visitSpreadElement(IrSpreadElement spread, IrDeclarationParent data) {
                return IrElementTransformer.DefaultImpls.visitSpreadElement(this, spread, data);
            }

            public IrExpression visitWhen(IrWhen expression2, IrDeclarationParent data) {
                return IrElementTransformer.DefaultImpls.visitWhen(this, expression2, data);
            }

            public IrBranch visitBranch(IrBranch branch, IrDeclarationParent data) {
                return IrElementTransformer.DefaultImpls.visitBranch(this, branch, data);
            }

            public IrElseBranch visitElseBranch(IrElseBranch branch, IrDeclarationParent data) {
                return IrElementTransformer.DefaultImpls.visitElseBranch(this, branch, data);
            }

            private static final IrExpression cacheValue$lambda$6(IrExpression $value) {
                IrElement $this$deepCopyWithSymbols_u24default$iv = $value;
                IrDeclarationParent initialParent$iv = null;
                boolean $i$f$deepCopyWithSymbols = false;
                IrElement $this$deepCopyImpl$iv$iv = $this$deepCopyWithSymbols_u24default$iv;
                boolean $i$f$deepCopyImpl = false;
                DeepCopySymbolRemapper symbolRemapper$iv$iv = new DeepCopySymbolRemapper(null, 1, null);
                IrVisitorsKt.acceptVoid($this$deepCopyImpl$iv$iv, symbolRemapper$iv$iv);
                DeepCopySymbolRemapper deepCopySymbolRemapper = symbolRemapper$iv$iv;
                boolean bl = false;
                ReferencedSymbolRemapper p0 = deepCopySymbolRemapper;
                TypeRemapper typeRemapper$iv$iv = new DeepCopyTypeRemapper(p0);
                IrElement irElement = $this$deepCopyImpl$iv$iv.transform(new DeepCopyIrTreeWithSymbols(symbolRemapper$iv$iv, typeRemapper$iv$iv, null, 4, null), null);
                if (irElement == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpression");
                }
                return (IrExpression)PatchDeclarationParentsKt.patchDeclarationParents((IrElement)((IrExpression)irElement), initialParent$iv);
            }

            private static final IrGetValueImpl cacheValue$lambda$7(IrVariable $varDeclaration) {
                return JsIrBuilder.buildGetValue$default(JsIrBuilder.INSTANCE, $varDeclaration.getSymbol(), null, 2, null);
            }

            private static final IrExpression lowerIntegerCoercion$maskOp(TypeOperatorLowering this$0, IrExpression arg, IrExpression mask, IrConst<?> shift) {
                JsIrArithBuilder $this$lowerIntegerCoercion_u24maskOp_u24lambda_u2425 = TypeOperatorLowering.access$getCalculator$p(this$0);
                boolean bl = false;
                return $this$lowerIntegerCoercion_u24maskOp_u24lambda_u2425.shr($this$lowerIntegerCoercion_u24maskOp_u24lambda_u2425.shl($this$lowerIntegerCoercion_u24maskOp_u24lambda_u2425.and(arg, mask), shift), IrUtilsKt.shallowCopy((IrExpression)shift));
            }
        };
        IrDeclarationParent irDeclarationParent = container instanceof IrDeclarationParent ? (IrDeclarationParent)((Object)container) : null;
        if (irDeclarationParent == null) {
            irDeclarationParent = container.getParent();
        }
        irBody.transformChildren(irElementTransformer, irDeclarationParent);
    }

    public static final /* synthetic */ IrSimpleFunctionSymbol access$getThrowNPE$p(TypeOperatorLowering $this) {
        return $this.throwNPE;
    }

    public static final /* synthetic */ JsInlineClassesUtils access$getIcUtils$p(TypeOperatorLowering $this) {
        return $this.icUtils;
    }

    public static final /* synthetic */ IrExpression access$getLitNull(TypeOperatorLowering $this) {
        return $this.getLitNull();
    }

    public static final /* synthetic */ IrSimpleFunctionSymbol access$getThrowCCE$p(TypeOperatorLowering $this) {
        return $this.throwCCE;
    }

    public static final /* synthetic */ JsIrArithBuilder access$getCalculator$p(TypeOperatorLowering $this) {
        return $this.calculator;
    }

    public static final /* synthetic */ IrSimpleFunctionSymbol access$getEqeq$p(TypeOperatorLowering $this) {
        return $this.eqeq;
    }

    public static final /* synthetic */ IrExpression access$getLitFalse(TypeOperatorLowering $this) {
        return $this.getLitFalse();
    }

    public static final /* synthetic */ IrSimpleFunctionSymbol access$getBooleanNot$p(TypeOperatorLowering $this) {
        return $this.booleanNot;
    }

    public static final /* synthetic */ IrExpression access$getLitTrue(TypeOperatorLowering $this) {
        return $this.getLitTrue();
    }

    public static final /* synthetic */ IrSimpleFunctionSymbol access$isSuspendFunctionSymbol$p(TypeOperatorLowering $this) {
        return $this.isSuspendFunctionSymbol;
    }

    public static final /* synthetic */ IrConstImpl access$getFunctionMarker(TypeOperatorLowering $this) {
        return $this.getFunctionMarker();
    }

    public static final /* synthetic */ IrConstImpl access$getBooleanMarker(TypeOperatorLowering $this) {
        return $this.getBooleanMarker();
    }

    public static final /* synthetic */ IrConstImpl access$getStringMarker(TypeOperatorLowering $this) {
        return $this.getStringMarker();
    }

    public static final /* synthetic */ IrConstImpl access$getNumberMarker(TypeOperatorLowering $this) {
        return $this.getNumberMarker();
    }

    public static final /* synthetic */ IrSimpleFunctionSymbol access$getTypeOfIntrinsicSymbol$p(TypeOperatorLowering $this) {
        return $this.typeOfIntrinsicSymbol;
    }

    public static final /* synthetic */ IrSimpleFunctionSymbol access$getJsClassIntrinsicSymbol$p(TypeOperatorLowering $this) {
        return $this.jsClassIntrinsicSymbol;
    }

    public static final /* synthetic */ IrSimpleFunctionSymbol access$isArraySymbol(TypeOperatorLowering $this) {
        return $this.isArraySymbol();
    }

    public static final /* synthetic */ IrSimpleFunctionSymbol access$isInterfaceSymbol(TypeOperatorLowering $this) {
        return $this.isInterfaceSymbol();
    }

    public static final /* synthetic */ IrSimpleFunctionSymbol access$isExternalObjectSymbol$p(TypeOperatorLowering $this) {
        return $this.isExternalObjectSymbol;
    }

    public static final /* synthetic */ IrSimpleFunctionSymbol access$getInstanceOfIntrinsicSymbol$p(TypeOperatorLowering $this) {
        return $this.instanceOfIntrinsicSymbol;
    }

    public static final /* synthetic */ IrConstImpl access$getByteMask(TypeOperatorLowering $this) {
        return $this.getByteMask();
    }

    public static final /* synthetic */ IrConstImpl access$getLit24(TypeOperatorLowering $this) {
        return $this.getLit24();
    }

    public static final /* synthetic */ IrConstImpl access$getShortMask(TypeOperatorLowering $this) {
        return $this.getShortMask();
    }

    public static final /* synthetic */ IrConstImpl access$getLit16(TypeOperatorLowering $this) {
        return $this.getLit16();
    }

    public static final /* synthetic */ boolean access$getDevMode$p(TypeOperatorLowering $this) {
        return $this.devMode;
    }

    public static final /* synthetic */ IrType access$getUnit$p(TypeOperatorLowering $this) {
        return $this.unit;
    }

    public static final /* synthetic */ IrGetObjectValueImpl access$getUnitValue(TypeOperatorLowering $this) {
        return $this.getUnitValue();
    }
}

