/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ant;

import java.io.File;
import java.lang.ref.SoftReference;
import java.net.JarURLConnection;
import java.net.URLConnection;
import java.util.Collection;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.tools.ant.AntClassLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.preloading.ClassPreloadingUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\b0\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0006\u0010\u001a\u001a\u00020\u0006R\u0016\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u001b\u0010\r\u001a\u00020\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\f\u001a\u0004\b\u000e\u0010\nR\u001b\u0010\u0010\u001a\u00020\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\f\u001a\u0004\b\u0011\u0010\nR\u001b\u0010\u0013\u001a\u00020\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\f\u001a\u0004\b\u0014\u0010\n\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/ant/KotlinAntTaskUtil;", "", "<init>", "()V", "classLoaderRef", "Ljava/lang/ref/SoftReference;", "Ljava/lang/ClassLoader;", "libPath", "Ljava/io/File;", "getLibPath", "()Ljava/io/File;", "libPath$delegate", "Lkotlin/Lazy;", "compilerJar", "getCompilerJar", "compilerJar$delegate", "runtimeJar", "getRuntimeJar", "runtimeJar$delegate", "reflectJar", "getReflectJar", "reflectJar$delegate", "jar", "Lkotlin/Lazy;", "name", "", "getOrCreateClassLoader", "kotlin-ant"})
public final class KotlinAntTaskUtil {
    @NotNull
    public static final KotlinAntTaskUtil INSTANCE = new KotlinAntTaskUtil();
    @NotNull
    private static SoftReference<ClassLoader> classLoaderRef = new SoftReference<Object>(null);
    @NotNull
    private static final Lazy libPath$delegate = LazyKt.lazy(KotlinAntTaskUtil::libPath_delegate$lambda$0);
    @NotNull
    private static final Lazy compilerJar$delegate = INSTANCE.jar("kotlin-compiler.jar");
    @NotNull
    private static final Lazy runtimeJar$delegate = INSTANCE.jar("kotlin-stdlib.jar");
    @NotNull
    private static final Lazy reflectJar$delegate = INSTANCE.jar("kotlin-reflect.jar");

    private KotlinAntTaskUtil() {
    }

    private final File getLibPath() {
        Lazy lazy = libPath$delegate;
        Object t = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue(t, "getValue(...)");
        return (File)t;
    }

    @NotNull
    public final File getCompilerJar() {
        Lazy lazy = compilerJar$delegate;
        return (File)lazy.getValue();
    }

    @NotNull
    public final File getRuntimeJar() {
        Lazy lazy = runtimeJar$delegate;
        return (File)lazy.getValue();
    }

    @NotNull
    public final File getReflectJar() {
        Lazy lazy = reflectJar$delegate;
        return (File)lazy.getValue();
    }

    private final Lazy<File> jar(String name) {
        return LazyKt.lazy(() -> KotlinAntTaskUtil.jar$lambda$2(name));
    }

    @NotNull
    public final synchronized ClassLoader getOrCreateClassLoader() {
        ClassLoader cached;
        ClassLoader classLoader = cached = classLoaderRef.get();
        if (classLoader != null) {
            return classLoader;
        }
        ClassLoader myLoader = this.getClass().getClassLoader();
        if (!(myLoader instanceof AntClassLoader)) {
            Intrinsics.checkNotNull(myLoader);
            return myLoader;
        }
        ClassLoader classLoader2 = ClassPreloadingUtils.preloadClasses((Collection)CollectionsKt.listOf(this.getCompilerJar()), (int)4096, (ClassLoader)myLoader, null);
        classLoaderRef = new SoftReference<ClassLoader>(classLoader2);
        Intrinsics.checkNotNull(classLoader2);
        return classLoader2;
    }

    private static final File libPath_delegate$lambda$0() {
        StringBuilder stringBuilder = new StringBuilder().append('/');
        String string = INSTANCE.getClass().getName();
        Intrinsics.checkNotNullExpressionValue(string, "getName(...)");
        String resourcePath = stringBuilder.append(StringsKt.replace$default(string, '.', '/', false, 4, null)).append(".class").toString();
        URLConnection uRLConnection = INSTANCE.getClass().getResource(resourcePath).openConnection();
        JarURLConnection jarURLConnection = uRLConnection instanceof JarURLConnection ? (JarURLConnection)uRLConnection : null;
        if (jarURLConnection == null) {
            throw new UnsupportedOperationException("Kotlin compiler Ant task should be loaded from the JAR file");
        }
        JarURLConnection jarConnection = jarURLConnection;
        File antTaskJarPath = new File(jarConnection.getJarFileURL().toURI());
        return antTaskJarPath.getParentFile();
    }

    private static final File jar$lambda$2(String $name) {
        File file;
        Intrinsics.checkNotNullParameter($name, "$name");
        File $this$jar_u24lambda_u242_u24lambda_u241 = file = new File(INSTANCE.getLibPath(), $name);
        boolean bl = false;
        if (!$this$jar_u24lambda_u242_u24lambda_u241.exists()) {
            throw new IllegalStateException("File is not found in the directory of Kotlin Ant task: " + $name);
        }
        return file;
    }
}

