/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.expression;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CodegenUtil;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.cfg.WhenChecker;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsBooleanLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBreak;
import org.jetbrains.kotlin.js.backend.ast.JsCase;
import org.jetbrains.kotlin.js.backend.ast.JsDefault;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsIf;
import org.jetbrains.kotlin.js.backend.ast.JsIntLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsNullLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsPrefixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsSwitch;
import org.jetbrains.kotlin.js.backend.ast.JsSwitchMember;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.expression.PatternTranslator;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.operation.InOperationTranslator;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.mutator.CoercionMutator;
import org.jetbrains.kotlin.js.translate.utils.mutator.LastExpressionMutator;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtWhenCondition;
import org.jetbrains.kotlin.psi.KtWhenConditionInRange;
import org.jetbrains.kotlin.psi.KtWhenConditionIsPattern;
import org.jetbrains.kotlin.psi.KtWhenConditionWithExpression;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactoryImpl;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.EnumValue;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00b0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 C2\u00020\u0001:\u0001CB\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\u001e\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u001a2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002JT\u0010\u001e\u001a*\u0012 \u0012\u001e\u0012\u001a\u0012\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u001f\u0012\u0004\u0012\u00020!0\u001aj\u0002` 0\u001f\u0012\u0004\u0012\u00020\u001c0\u001a2\u0006\u0010\u001d\u001a\u00020\u001c2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020!0\u001f2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\t0$H\u0002JN\u0010%\u001a*\u0012 \u0012\u001e\u0012\u001a\u0012\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u001f\u0012\u0004\u0012\u00020!0\u001aj\u0002` 0\u001f\u0012\u0004\u0012\u00020\u001c0\u001a2\u0006\u0010\u001d\u001a\u00020\u001c2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020!0\u001f2\u0006\u0010&\u001a\u00020\tH\u0002J\u0094\u0001\u0010'\u001a*\u0012 \u0012\u001e\u0012\u001a\u0012\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u001f\u0012\u0004\u0012\u00020!0\u001aj\u0002` 0\u001f\u0012\u0004\u0012\u00020\u001c0\u001a\"\b\b\u0000\u0010(*\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u001c2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020!0\u001f2\u0018\u0010)\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030+\u0012\u0006\u0012\u0004\u0018\u0001H(0*2\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u0002H(\u0012\u0004\u0012\u00020\u00150*2\u0014\u0010-\u001a\u0010\u0012\u0004\u0012\u0002H(\u0012\u0006\u0012\u0004\u0018\u00010\u000b0*H\u0002J\u000e\u0010.\u001a\u0004\u0018\u00010/*\u00020\tH\u0002J \u00100\u001a\u0002012\u0006\u00102\u001a\u00020!2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u00103\u001a\u000204H\u0002J\u0018\u00105\u001a\u00020\u000b2\u0006\u00102\u001a\u00020!2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J \u00106\u001a\u00020\u000b2\u0006\u00107\u001a\u00020\u000b2\u0006\u00108\u001a\u0002092\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0018\u0010:\u001a\u00020\u000b2\u0006\u00108\u001a\u0002092\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0018\u0010;\u001a\u00020\u000b2\u0006\u00108\u001a\u0002092\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0018\u0010<\u001a\u00020\u000b2\u0006\u0010=\u001a\u00020>2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0018\u0010?\u001a\u00020\u000b2\u0006\u00108\u001a\u00020@2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0018\u0010A\u001a\u00020\u000b2\u0006\u00108\u001a\u00020B2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016\u00a8\u0006D"}, d2={"Lorg/jetbrains/kotlin/js/translate/expression/WhenTranslator;", "Lorg/jetbrains/kotlin/js/translate/general/AbstractTranslator;", "whenExpression", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtWhenExpression;Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;)V", "subjectType", "Lorg/jetbrains/kotlin/types/KotlinType;", "expressionToMatch", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "type", "uniqueConstants", "", "", "uniqueEnumNames", "", "dataFlowValueFactory", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;", "isExhaustive", "", "()Z", "translate", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "translateAsSwitch", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/js/backend/ast/JsSwitch;", "", "fromIndex", "collectPrimitiveConstantEntries", "", "Lorg/jetbrains/kotlin/js/translate/expression/EntryWithConstants;", "Lorg/jetbrains/kotlin/psi/KtWhenEntry;", "entries", "expectedTypes", "", "collectEnumEntries", "expectedType", "collectConstantEntries", "T", "extractor", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;", "filter", "wrapper", "getEnumClass", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "translateEntryExpression", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "entry", "block", "Lorg/jetbrains/kotlin/js/backend/ast/JsBlock;", "translateConditions", "translateOrCondition", "leftExpression", "condition", "Lorg/jetbrains/kotlin/psi/KtWhenCondition;", "translateCondition", "translateWhenConditionToBooleanExpression", "translateIsCondition", "conditionIsPattern", "Lorg/jetbrains/kotlin/psi/KtWhenConditionIsPattern;", "translateExpressionCondition", "Lorg/jetbrains/kotlin/psi/KtWhenConditionWithExpression;", "translateRangeCondition", "Lorg/jetbrains/kotlin/psi/KtWhenConditionInRange;", "Companion", "js.translator"})
@SourceDebugExtension(value={"SMAP\nWhenTranslator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WhenTranslator.kt\norg/jetbrains/kotlin/js/translate/expression/WhenTranslator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,370:1\n1454#2,2:371\n1557#2:373\n1628#2,3:374\n1456#2,3:378\n774#2:394\n865#2,2:395\n1611#2,9:397\n1863#2:406\n1864#2:408\n1620#2:409\n1#3:377\n1#3:391\n1#3:407\n11420#4,9:381\n13346#4:390\n13347#4:392\n11429#4:393\n1288#5,3:410\n*S KotlinDebug\n*F\n+ 1 WhenTranslator.kt\norg/jetbrains/kotlin/js/translate/expression/WhenTranslator\n*L\n165#1:371,2\n166#1:373\n166#1:374,3\n165#1:378,3\n249#1:394\n249#1:395,2\n249#1:397,9\n249#1:406\n249#1:408\n249#1:409\n240#1:391\n249#1:407\n240#1:381,9\n240#1:390\n240#1:392\n240#1:393\n292#1:410,3\n*E\n"})
public final class WhenTranslator
extends AbstractTranslator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KtWhenExpression whenExpression;
    @Nullable
    private final KotlinType subjectType;
    @Nullable
    private final JsExpression expressionToMatch;
    @Nullable
    private final KotlinType type;
    @NotNull
    private final Set<Object> uniqueConstants;
    @NotNull
    private final Set<String> uniqueEnumNames;
    @NotNull
    private final DataFlowValueFactory dataFlowValueFactory;

    private WhenTranslator(KtWhenExpression whenExpression, TranslationContext context2) {
        super(context2);
        this.whenExpression = whenExpression;
        this.uniqueConstants = new LinkedHashSet();
        this.uniqueEnumNames = new LinkedHashSet();
        LanguageVersionSettings languageVersionSettings = context2.getLanguageVersionSettings();
        Intrinsics.checkNotNullExpressionValue(languageVersionSettings, "getLanguageVersionSettings(...)");
        this.dataFlowValueFactory = new DataFlowValueFactoryImpl(languageVersionSettings);
        KtProperty subjectVariable = this.whenExpression.getSubjectVariable();
        KtExpression subjectExpression = this.whenExpression.getSubjectExpression();
        if (subjectVariable != null) {
            CallableDescriptor descriptor;
            JsStatement jsStatement = Translation.translateAsStatement(subjectVariable, context2);
            Intrinsics.checkNotNull(jsStatement, "null cannot be cast to non-null type org.jetbrains.kotlin.js.backend.ast.JsVars");
            JsVars variable = (JsVars)jsStatement;
            context2.addStatementToCurrentBlock(variable);
            DeclarationDescriptor declarationDescriptor = BindingUtils.getDescriptorForElement(context2.bindingContext(), subjectVariable);
            CallableDescriptor callableDescriptor = descriptor = declarationDescriptor instanceof CallableDescriptor ? (CallableDescriptor)declarationDescriptor : null;
            this.subjectType = callableDescriptor != null ? callableDescriptor.getReturnType() : null;
            List<JsVars.JsVar> list = variable.getVars();
            Intrinsics.checkNotNullExpressionValue(list, "getVars(...)");
            this.expressionToMatch = CollectionsKt.first(list).getName().makeRef();
        } else if (subjectExpression != null) {
            this.subjectType = this.bindingContext().getType(subjectExpression);
            this.expressionToMatch = context2.defineTemporary(Translation.translateAsExpression(subjectExpression, context2));
        } else {
            this.subjectType = null;
            this.expressionToMatch = null;
        }
        this.type = this.bindingContext().getType(this.whenExpression);
    }

    private final boolean isExhaustive() {
        KotlinType type2 = this.bindingContext().getType(this.whenExpression);
        boolean isStatement = type2 != null && KotlinBuiltIns.isUnit(type2) && !type2.isMarkedNullable();
        BindingContext bindingContext = this.bindingContext();
        Intrinsics.checkNotNullExpressionValue(bindingContext, "bindingContext(...)");
        return CodegenUtil.isExhaustive(bindingContext, this.whenExpression, isStatement);
    }

    private final JsNode translate() {
        JsNode jsNode;
        Ref.ObjectRef resultIf = new Ref.ObjectRef();
        Function1<JsStatement, Unit> setWhenStatement = arg_0 -> WhenTranslator.translate$lambda$0(resultIf, arg_0);
        int i = 0;
        boolean hasElse = false;
        while (i < this.whenExpression.getEntries().size()) {
            JsStatement statementToAdd;
            JsIf jsIf;
            Pair<JsSwitch, Integer> asSwitch = this.translateAsSwitch(i);
            if (asSwitch != null) {
                JsSwitch jsSwitch = asSwitch.component1();
                int next = ((Number)asSwitch.component2()).intValue();
                setWhenStatement.invoke(jsSwitch);
                setWhenStatement = arg_0 -> WhenTranslator.translate$lambda$3(jsSwitch, this, arg_0);
                i = next;
                continue;
            }
            KtWhenEntry entry = this.whenExpression.getEntries().get(i++);
            JsBlock statementBlock = new JsBlock();
            Intrinsics.checkNotNull(entry);
            TranslationContext translationContext = this.context();
            Intrinsics.checkNotNullExpressionValue(translationContext, "context(...)");
            JsStatement statement = this.translateEntryExpression(entry, translationContext, statementBlock);
            if (resultIf.element == null && entry.isElse()) {
                this.context().addStatementsToCurrentBlockFrom(statementBlock);
                return statement;
            }
            statement = JsAstUtils.mergeStatementInBlockIfNeeded(statement, statementBlock);
            JsBlock conditionsBlock = new JsBlock();
            if (entry.isElse()) {
                hasElse = true;
                setWhenStatement.invoke(statement);
                break;
            }
            TranslationContext translationContext2 = this.context().innerBlock(conditionsBlock);
            Intrinsics.checkNotNullExpressionValue(translationContext2, "innerBlock(...)");
            Intrinsics.checkNotNullExpressionValue(JsAstUtils.newJsIf(this.translateConditions(entry, translationContext2), statement), "newJsIf(...)");
            jsIf.setSource(entry);
            Intrinsics.checkNotNullExpressionValue(JsAstUtils.mergeStatementInBlockIfNeeded(jsIf, conditionsBlock), "mergeStatementInBlockIfNeeded(...)");
            setWhenStatement.invoke(statementToAdd);
            setWhenStatement = arg_0 -> WhenTranslator.translate$lambda$4(jsIf, arg_0);
        }
        if (this.isExhaustive() && !hasElse) {
            JsInvocation noWhenMatchedInvocation = new JsInvocation((JsExpression)JsAstUtils.pureFqn("noWhenBranchMatched", (JsExpression)Namer.kotlinObject()), new JsExpression[0]);
            JsStatement jsStatement = JsAstUtils.asSyntheticStatement(noWhenMatchedInvocation);
            Intrinsics.checkNotNullExpressionValue(jsStatement, "asSyntheticStatement(...)");
            setWhenStatement.invoke(jsStatement);
        }
        if (resultIf.element != null) {
            Object t = resultIf.element;
            Intrinsics.checkNotNull(t);
            jsNode = (JsNode)t;
        } else {
            jsNode = new JsNullLiteral();
        }
        return jsNode;
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<JsSwitch, Integer> translateAsSwitch(int fromIndex) {
        Pair<JsSwitch, Integer> pair;
        Pair<List<Pair<List<JsExpression>, KtWhenEntry>>, Integer> pair2;
        ClassDescriptor enumClass;
        KotlinType kotlinType = this.subjectType;
        if (kotlinType == null) {
            return null;
        }
        KotlinType subjectType = kotlinType;
        KtExpression ktExpression = this.whenExpression.getSubjectExpression();
        if (ktExpression == null) {
            return null;
        }
        KtExpression ktSubject = ktExpression;
        BindingContext bindingContext = this.bindingContext();
        Intrinsics.checkNotNullExpressionValue(bindingContext, "bindingContext(...)");
        DeclarationDescriptor declarationDescriptor = this.context().getDeclarationDescriptor();
        if (declarationDescriptor == null) {
            ModuleDescriptor moduleDescriptor = this.context().getCurrentModule();
            Intrinsics.checkNotNullExpressionValue(moduleDescriptor, "getCurrentModule(...)");
            declarationDescriptor = moduleDescriptor;
        }
        DataFlowValue dataFlow = this.dataFlowValueFactory.createDataFlowValue(ktSubject, subjectType, bindingContext, declarationDescriptor);
        CompilerConfiguration compilerConfiguration = this.context().getConfig().getConfiguration();
        Intrinsics.checkNotNullExpressionValue(compilerConfiguration, "getConfiguration(...)");
        LanguageVersionSettings languageVersionSettings = CommonConfigurationKeysKt.getLanguageVersionSettings(compilerConfiguration);
        BindingContext bindingContext2 = this.bindingContext();
        Intrinsics.checkNotNullExpressionValue(bindingContext2, "bindingContext(...)");
        Set<KotlinType> expectedTypes = SetsKt.plus(BindingContextUtilsKt.getDataFlowInfoBefore(bindingContext2, ktSubject).getStableTypes(dataFlow, languageVersionSettings), (Iterable)SetsKt.setOf(subjectType));
        JsExpression jsExpression = this.expressionToMatch;
        if (jsExpression == null) {
            return null;
        }
        JsExpression subject = jsExpression;
        Function0<JsExpression> subjectSupplier = () -> WhenTranslator.translateAsSwitch$lambda$5(subject);
        ClassDescriptor classDescriptor = enumClass = SequencesKt.firstOrNull(SequencesKt.mapNotNull(CollectionsKt.asSequence((Iterable)expectedTypes), arg_0 -> WhenTranslator.translateAsSwitch$lambda$6(this, arg_0)));
        if (classDescriptor != null) {
            subjectSupplier = () -> WhenTranslator.translateAsSwitch$lambda$7(classDescriptor, this, subject);
            List<KtWhenEntry> list = this.whenExpression.getEntries();
            Intrinsics.checkNotNullExpressionValue(list, "getEntries(...)");
            SimpleType simpleType = enumClass.getDefaultType();
            Intrinsics.checkNotNullExpressionValue(simpleType, "getDefaultType(...)");
            pair2 = this.collectEnumEntries(fromIndex, list, simpleType);
        } else {
            List<KtWhenEntry> list = this.whenExpression.getEntries();
            Intrinsics.checkNotNullExpressionValue(list, "getEntries(...)");
            pair2 = this.collectPrimitiveConstantEntries(fromIndex, list, expectedTypes);
        }
        Pair<List<Pair<List<JsExpression>, KtWhenEntry>>, Integer> pair3 = pair2;
        List<Pair<List<JsExpression>, KtWhenEntry>> entriesForSwitch = pair3.component1();
        int nextIndex = ((Number)pair3.component2()).intValue();
        if (SequencesKt.sumOfInt(SequencesKt.map(CollectionsKt.asSequence((Iterable)entriesForSwitch), WhenTranslator::translateAsSwitch$lambda$8)) > 1) {
            JsSwitch jsSwitch;
            List switchEntries = new ArrayList();
            Iterable $this$flatMapTo$iv = entriesForSwitch;
            boolean $i$f$flatMapTo = false;
            for (Object element$iv : $this$flatMapTo$iv) {
                JsBreak jsBreak;
                void $this$mapTo$iv$iv;
                Pair pair4 = (Pair)element$iv;
                boolean bl = false;
                List conditions = (List)pair4.component1();
                KtWhenEntry entry = (KtWhenEntry)pair4.component2();
                Iterable $this$map$iv = conditions;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    JsCase jsCase;
                    JsExpression jsExpression2 = (JsExpression)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    JsCase $this$translateAsSwitch_u24lambda_u2412_u24lambda_u2410_u24lambda_u249 = jsCase = new JsCase();
                    boolean bl3 = false;
                    $this$translateAsSwitch_u24lambda_u2412_u24lambda_u2410_u24lambda_u249.setCaseExpression(it.source(entry));
                    collection.add(jsCase);
                }
                List members = (List)destination$iv$iv;
                JsBlock block = new JsBlock();
                TranslationContext translationContext = this.context();
                Intrinsics.checkNotNullExpressionValue(translationContext, "context(...)");
                JsStatement statement = this.translateEntryExpression(entry, translationContext, block);
                JsCase lastEntry = (JsCase)CollectionsKt.last(members);
                List<JsStatement> list = lastEntry.getStatements();
                Intrinsics.checkNotNullExpressionValue(list, "getStatements(...)");
                Collection collection = list;
                List<JsStatement> list2 = block.getStatements();
                Intrinsics.checkNotNullExpressionValue(list2, "getStatements(...)");
                CollectionsKt.addAll(collection, (Iterable)list2);
                List<JsStatement> list3 = lastEntry.getStatements();
                Intrinsics.checkNotNullExpressionValue(list3, "getStatements(...)");
                ((Collection)list3).add(statement);
                List<JsStatement> list4 = lastEntry.getStatements();
                Intrinsics.checkNotNullExpressionValue(list4, "getStatements(...)");
                collection = list4;
                JsBreak $this$translateAsSwitch_u24lambda_u2412_u24lambda_u2411 = jsBreak = new JsBreak();
                boolean bl4 = false;
                $this$translateAsSwitch_u24lambda_u2412_u24lambda_u2411.setSource(entry);
                collection.add(jsBreak);
                Iterable list$iv = members;
                CollectionsKt.addAll((Collection)switchEntries, list$iv);
            }
            JsSwitch $this$translateAsSwitch_u24lambda_u2413 = jsSwitch = new JsSwitch(subjectSupplier.invoke(), switchEntries);
            boolean bl = false;
            $this$translateAsSwitch_u24lambda_u2413.setSource(this.whenExpression);
            Integer n = nextIndex;
            JsSwitch jsSwitch2 = jsSwitch;
            pair = new Pair<JsSwitch, Integer>(jsSwitch2, n);
        } else {
            pair = null;
        }
        return pair;
    }

    private final Pair<List<Pair<List<JsExpression>, KtWhenEntry>>, Integer> collectPrimitiveConstantEntries(int fromIndex, List<? extends KtWhenEntry> entries, Set<? extends KotlinType> expectedTypes) {
        return this.collectConstantEntries(fromIndex, entries, arg_0 -> WhenTranslator.collectPrimitiveConstantEntries$lambda$15(expectedTypes, arg_0), arg_0 -> WhenTranslator.collectPrimitiveConstantEntries$lambda$16(this, arg_0), WhenTranslator::collectPrimitiveConstantEntries$lambda$17);
    }

    private final Pair<List<Pair<List<JsExpression>, KtWhenEntry>>, Integer> collectEnumEntries(int fromIndex, List<? extends KtWhenEntry> entries, KotlinType expectedType) {
        ClassId classId = WhenChecker.getClassIdForTypeIfEnum(expectedType);
        return this.collectConstantEntries(fromIndex, entries, arg_0 -> WhenTranslator.collectEnumEntries$lambda$19(expectedType, classId, arg_0), arg_0 -> WhenTranslator.collectEnumEntries$lambda$20(this, arg_0), WhenTranslator::collectEnumEntries$lambda$21);
    }

    /*
     * WARNING - void declaration
     */
    private final <T> Pair<List<Pair<List<JsExpression>, KtWhenEntry>>, Integer> collectConstantEntries(int fromIndex, List<? extends KtWhenEntry> entries, Function1<? super CompileTimeConstant<?>, ? extends T> extractor2, Function1<? super T, Boolean> filter, Function1<? super T, ? extends JsExpression> wrapper) {
        KtWhenEntry entry;
        int i;
        List entriesForSwitch = new ArrayList();
        for (i = fromIndex; i < entries.size() && !(entry = entries.get(i)).isElse(); ++i) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            void $this$filterTo$iv$iv;
            Object element$iv$iv;
            Object element$iv$iv$iv;
            void $this$mapNotNullTo$iv$iv2;
            boolean hasImproperConstants = false;
            KtWhenCondition[] ktWhenConditionArray = entry.getConditions();
            Intrinsics.checkNotNullExpressionValue(ktWhenConditionArray, "getConditions(...)");
            Object[] $this$mapNotNull$iv2 = ktWhenConditionArray;
            boolean $i$f$mapNotNull = false;
            Object[] objectArray = $this$mapNotNull$iv2;
            Iterable<KtExpression> destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
            boolean $i$f$forEach = false;
            int n = ((void)$this$forEach$iv$iv$iv).length;
            for (int j = 0; j < n; ++j) {
                Object object;
                block9: {
                    block8: {
                        element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[j];
                        boolean bl = false;
                        KtWhenCondition condition = (KtWhenCondition)element$iv$iv;
                        boolean bl2 = false;
                        KtWhenConditionWithExpression ktWhenConditionWithExpression = condition instanceof KtWhenConditionWithExpression ? (KtWhenConditionWithExpression)condition : null;
                        KtExpression expression2 = ktWhenConditionWithExpression != null ? ktWhenConditionWithExpression.getExpression() : null;
                        object = expression2;
                        if (object == null) break block8;
                        KtExpression it = object;
                        boolean bl3 = false;
                        BindingContext bindingContext = this.bindingContext();
                        Intrinsics.checkNotNullExpressionValue(bindingContext, "bindingContext(...)");
                        CompileTimeConstant<?> compileTimeConstant = ConstantExpressionEvaluator.Companion.getConstant(it, bindingContext);
                        object = compileTimeConstant;
                        if (compileTimeConstant != null && (object = extractor2.invoke((CompileTimeConstant<?>)object)) != null) break block9;
                    }
                    WhenTranslator $this$collectConstantEntries_u24lambda_u2424_u24lambda_u2423 = this;
                    boolean bl = false;
                    hasImproperConstants = true;
                    object = null;
                }
                if (object == null) continue;
                KtExpression it$iv$iv = object;
                boolean bl = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List constantValues = (List)destination$iv$iv;
            if (hasImproperConstants) break;
            Iterable $this$filter$iv = constantValues;
            boolean $i$f$filter = false;
            destination$iv$iv = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                if (!filter.invoke(element$iv$iv2).booleanValue()) continue;
                destination$iv$iv2.add(element$iv$iv2);
            }
            $this$filter$iv = (List)destination$iv$iv2;
            boolean $i$f$mapNotNull2 = false;
            $this$filterTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo2 = false;
            void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach2 = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv2.iterator();
            while (iterator2.hasNext()) {
                element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                Object it = element$iv$iv;
                boolean bl4 = false;
                JsExpression jsExpression = wrapper.invoke(it);
                if (jsExpression == null) {
                    WhenTranslator $this$collectConstantEntries_u24lambda_u2426_u24lambda_u2425 = this;
                    boolean bl5 = false;
                    hasImproperConstants = true;
                    jsExpression = null;
                }
                if (jsExpression == null) continue;
                JsExpression it$iv$iv = jsExpression;
                boolean bl6 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            List constants = (List)destination$iv$iv2;
            if (hasImproperConstants) break;
            if (!(!((Collection)constants).isEmpty())) continue;
            ((Collection)entriesForSwitch).add(new Pair<List, KtWhenEntry>(constants, entry));
        }
        return new Pair<List<Pair<List<JsExpression>, KtWhenEntry>>, Integer>(entriesForSwitch, i);
    }

    private final ClassDescriptor getEnumClass(KotlinType $this$getEnumClass) {
        ClassDescriptor classDescriptor;
        if ($this$getEnumClass.isMarkedNullable()) {
            return null;
        }
        ClassifierDescriptor classifierDescriptor = $this$getEnumClass.getConstructor().getDeclarationDescriptor();
        ClassDescriptor classDescriptor2 = classDescriptor = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
        return (classDescriptor2 != null ? classDescriptor2.getKind() : null) == ClassKind.ENUM_CLASS && !classDescriptor.isExternal() ? classDescriptor : null;
    }

    private final JsStatement translateEntryExpression(KtWhenEntry entry, TranslationContext context2, JsBlock block) {
        JsStatement jsStatement;
        KtExpression ktExpression = entry.getExpression();
        if (ktExpression == null) {
            throw new IllegalStateException("WhenEntry should have whenExpression to execute.".toString());
        }
        KtExpression expressionToExecute = ktExpression;
        JsStatement jsStatement2 = Translation.translateAsStatement(expressionToExecute, context2, block);
        Intrinsics.checkNotNullExpressionValue(jsStatement2, "translateAsStatement(...)");
        JsStatement result2 = jsStatement2;
        if (this.type != null) {
            JsStatement jsStatement3 = LastExpressionMutator.mutateLastExpression(result2, new CoercionMutator(this.type, context2));
            Intrinsics.checkNotNull(jsStatement3);
            jsStatement = jsStatement3;
        } else {
            jsStatement = result2;
        }
        return jsStatement;
    }

    /*
     * WARNING - void declaration
     */
    private final JsExpression translateConditions(KtWhenEntry entry, TranslationContext context2) {
        boolean bl;
        KtWhenCondition[] ktWhenConditionArray = entry.getConditions();
        Intrinsics.checkNotNullExpressionValue(ktWhenConditionArray, "getConditions(...)");
        KtWhenCondition[] conditions = ktWhenConditionArray;
        boolean bl2 = bl = !(conditions.length == 0);
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-WhenTranslator$translateConditions$22 = false;
            String $i$a$-assert-WhenTranslator$translateConditions$22 = "When entry (not else) should have at least one condition";
            throw new AssertionError((Object)$i$a$-assert-WhenTranslator$translateConditions$22);
        }
        KtWhenCondition ktWhenCondition = conditions[0];
        Intrinsics.checkNotNullExpressionValue(ktWhenCondition, "get(...)");
        JsExpression first = this.translateCondition(ktWhenCondition, context2);
        Sequence<KtWhenCondition> $this$fold$iv = SequencesKt.drop(ArraysKt.asSequence(conditions), 1);
        boolean $i$f$fold = false;
        JsExpression accumulator$iv = first;
        Iterator<KtWhenCondition> iterator2 = $this$fold$iv.iterator();
        while (iterator2.hasNext()) {
            void condition;
            KtWhenCondition element$iv;
            KtWhenCondition ktWhenCondition2 = element$iv = iterator2.next();
            JsExpression acc = accumulator$iv;
            boolean bl3 = false;
            Intrinsics.checkNotNull(condition);
            accumulator$iv = this.translateOrCondition(acc, (KtWhenCondition)condition, context2);
        }
        return accumulator$iv;
    }

    private final JsExpression translateOrCondition(JsExpression leftExpression, KtWhenCondition condition, TranslationContext context2) {
        JsExpression jsExpression;
        TranslationContext translationContext = context2.innerBlock();
        Intrinsics.checkNotNullExpressionValue(translationContext, "innerBlock(...)");
        TranslationContext rightContext = translationContext;
        JsExpression rightExpression = this.translateCondition(condition, rightContext);
        context2.moveVarsFrom(rightContext);
        if (rightContext.currentBlockIsEmpty()) {
            jsExpression = new JsBinaryOperation(JsBinaryOperator.OR, leftExpression, rightExpression);
        } else {
            boolean bl = rightExpression instanceof JsNameRef;
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-WhenTranslator$translateOrCondition$22 = false;
                String $i$a$-assert-WhenTranslator$translateOrCondition$22 = "expected JsNameRef, but: " + rightExpression;
                throw new AssertionError((Object)$i$a$-assert-WhenTranslator$translateOrCondition$22);
            }
            Intrinsics.checkNotNull(rightExpression, "null cannot be cast to non-null type org.jetbrains.kotlin.js.backend.ast.JsNameRef");
            JsNameRef result2 = (JsNameRef)rightExpression;
            JsIf jsIf = JsAstUtils.newJsIf(leftExpression, JsAstUtils.assignment(result2, new JsBooleanLiteral(true)).makeStmt(), rightContext.getCurrentBlock());
            Intrinsics.checkNotNullExpressionValue(jsIf, "newJsIf(...)");
            JsIf ifStatement = jsIf;
            ifStatement.setSource(condition);
            context2.addStatementToCurrentBlock(ifStatement);
            jsExpression = result2;
        }
        return jsExpression;
    }

    private final JsExpression translateCondition(KtWhenCondition condition, TranslationContext context2) {
        JsExpression jsExpression;
        JsExpression patternMatchExpression = this.translateWhenConditionToBooleanExpression(condition, context2);
        if (WhenTranslator.Companion.isNegated(condition)) {
            JsPrefixOperation jsPrefixOperation = JsAstUtils.not(patternMatchExpression);
            Intrinsics.checkNotNullExpressionValue(jsPrefixOperation, "not(...)");
            jsExpression = jsPrefixOperation;
        } else {
            jsExpression = patternMatchExpression;
        }
        return jsExpression;
    }

    private final JsExpression translateWhenConditionToBooleanExpression(KtWhenCondition condition, TranslationContext context2) {
        JsExpression jsExpression;
        KtWhenCondition ktWhenCondition = condition;
        if (ktWhenCondition instanceof KtWhenConditionIsPattern) {
            jsExpression = this.translateIsCondition((KtWhenConditionIsPattern)condition, context2);
        } else if (ktWhenCondition instanceof KtWhenConditionWithExpression) {
            jsExpression = this.translateExpressionCondition((KtWhenConditionWithExpression)condition, context2);
        } else if (ktWhenCondition instanceof KtWhenConditionInRange) {
            jsExpression = this.translateRangeCondition((KtWhenConditionInRange)condition, context2);
        } else {
            throw new IllegalStateException(("Unsupported when condition " + condition.getClass()).toString());
        }
        return jsExpression;
    }

    private final JsExpression translateIsCondition(KtWhenConditionIsPattern conditionIsPattern, TranslationContext context2) {
        JsExpression jsExpression = this.expressionToMatch;
        if (jsExpression == null) {
            throw new IllegalStateException("An is-check is not allowed in when() without subject.".toString());
        }
        JsExpression expressionToMatch = jsExpression;
        KtTypeReference ktTypeReference = conditionIsPattern.getTypeReference();
        if (ktTypeReference == null) {
            throw new IllegalStateException("An is-check must have a type reference.".toString());
        }
        KtTypeReference typeReference = ktTypeReference;
        JsExpression result2 = Translation.patternTranslator(context2).translateIsCheck(expressionToMatch, typeReference);
        JsExpression jsExpression2 = result2;
        if (jsExpression2 == null) {
            jsExpression2 = new JsBooleanLiteral(true);
        }
        JsExpression jsExpression3 = jsExpression2.source(conditionIsPattern);
        Intrinsics.checkNotNullExpressionValue(jsExpression3, "source(...)");
        return jsExpression3;
    }

    private final JsExpression translateExpressionCondition(KtWhenConditionWithExpression condition, TranslationContext context2) {
        JsExpression jsExpression;
        KtExpression ktExpression = condition.getExpression();
        if (ktExpression == null) {
            throw new IllegalStateException("Expression pattern should have an expression.".toString());
        }
        KtExpression patternExpression = ktExpression;
        PatternTranslator patternTranslator = Translation.patternTranslator(context2);
        Intrinsics.checkNotNullExpressionValue(patternTranslator, "patternTranslator(...)");
        PatternTranslator patternTranslator2 = patternTranslator;
        if (this.expressionToMatch == null) {
            JsExpression jsExpression2 = patternTranslator2.translateExpressionForExpressionPattern(patternExpression);
            Intrinsics.checkNotNull(jsExpression2);
            jsExpression = jsExpression2;
        } else {
            KotlinType kotlinType = this.subjectType;
            Intrinsics.checkNotNull(kotlinType);
            JsExpression jsExpression3 = patternTranslator2.translateExpressionPattern(kotlinType, this.expressionToMatch, patternExpression);
            Intrinsics.checkNotNull(jsExpression3);
            jsExpression = jsExpression3;
        }
        return jsExpression;
    }

    private final JsExpression translateRangeCondition(KtWhenConditionInRange condition, TranslationContext context2) {
        JsExpression jsExpression = this.expressionToMatch;
        if (jsExpression == null) {
            throw new IllegalStateException(("Range pattern is only available for 'when (C) { in ... }'  expressions: " + PsiUtilsKt.getTextWithLocation(condition)).toString());
        }
        JsExpression expressionToMatch = jsExpression;
        HashMap subjectAliases = new HashMap();
        Map map = subjectAliases;
        KtExpression ktExpression = this.whenExpression.getSubjectExpression();
        Intrinsics.checkNotNull(ktExpression);
        map.put(ktExpression, expressionToMatch);
        TranslationContext translationContext = context2.innerContextWithAliasesForExpressions(subjectAliases);
        Intrinsics.checkNotNullExpressionValue(translationContext, "innerContextWithAliasesForExpressions(...)");
        TranslationContext callContext = translationContext;
        boolean negated = condition.getOperationReference().getReferencedNameElementType() == KtTokens.NOT_IN;
        KtExpression ktExpression2 = condition.getRangeExpression();
        Intrinsics.checkNotNull(ktExpression2);
        JsExpression jsExpression2 = new InOperationTranslator(callContext, expressionToMatch, ktExpression2, condition.getOperationReference(), negated).translate().source(condition);
        Intrinsics.checkNotNullExpressionValue(jsExpression2, "source(...)");
        return jsExpression2;
    }

    private static final Unit translate$lambda$0(Ref.ObjectRef $resultIf, JsStatement it) {
        Intrinsics.checkNotNullParameter($resultIf, "$resultIf");
        Intrinsics.checkNotNullParameter(it, "it");
        $resultIf.element = it;
        return Unit.INSTANCE;
    }

    private static final Unit translate$lambda$3(JsSwitch $jsSwitch, WhenTranslator this$0, JsStatement whenStatement) {
        JsBreak jsBreak;
        JsDefault jsDefault;
        Intrinsics.checkNotNullParameter($jsSwitch, "$jsSwitch");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter(whenStatement, "whenStatement");
        List<JsSwitchMember> list = $jsSwitch.getCases();
        Intrinsics.checkNotNullExpressionValue(list, "getCases(...)");
        Collection collection = list;
        JsDefault $this$translate_u24lambda_u243_u24lambda_u242 = jsDefault = new JsDefault();
        boolean bl = false;
        List<JsStatement> list2 = $this$translate_u24lambda_u243_u24lambda_u242.getStatements();
        Intrinsics.checkNotNullExpressionValue(list2, "getStatements(...)");
        ((Collection)list2).add(whenStatement);
        List<JsStatement> list3 = $this$translate_u24lambda_u243_u24lambda_u242.getStatements();
        Intrinsics.checkNotNullExpressionValue(list3, "getStatements(...)");
        Collection collection2 = list3;
        JsBreak $this$translate_u24lambda_u243_u24lambda_u242_u24lambda_u241 = jsBreak = new JsBreak();
        boolean bl2 = false;
        $this$translate_u24lambda_u243_u24lambda_u242_u24lambda_u241.setSource(this$0.whenExpression);
        collection2.add(jsBreak);
        collection.add(jsDefault);
        return Unit.INSTANCE;
    }

    private static final Unit translate$lambda$4(JsIf $jsIf, JsStatement it) {
        Intrinsics.checkNotNullParameter($jsIf, "$jsIf");
        Intrinsics.checkNotNullParameter(it, "it");
        $jsIf.setElseStatement(it);
        return Unit.INSTANCE;
    }

    private static final JsExpression translateAsSwitch$lambda$5(JsExpression $subject) {
        Intrinsics.checkNotNullParameter($subject, "$subject");
        return $subject;
    }

    private static final ClassDescriptor translateAsSwitch$lambda$6(WhenTranslator this$0, KotlinType it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter(it, "it");
        return this$0.getEnumClass(it);
    }

    private static final JsNameRef translateAsSwitch$lambda$7(ClassDescriptor $enumClass, WhenTranslator this$0, JsExpression $subject) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($subject, "$subject");
        ClassDescriptor enumBaseClass = DescriptorUtilsKt.getSuperClassOrAny($enumClass);
        PropertyDescriptor propertyDescriptor = DescriptorUtils.getPropertyByName(enumBaseClass.getUnsubstitutedMemberScope(), StandardNames.NAME);
        Intrinsics.checkNotNullExpressionValue(propertyDescriptor, "getPropertyByName(...)");
        PropertyDescriptor nameProperty = propertyDescriptor;
        return new JsNameRef(this$0.context().getNameForDescriptor(nameProperty), $subject);
    }

    private static final int translateAsSwitch$lambda$8(Pair it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return ((List)it.getFirst()).size();
    }

    private static final Object collectPrimitiveConstantEntries$lambda$15$lambda$14(CompileTimeConstant $constant, KotlinType it) {
        Intrinsics.checkNotNullParameter($constant, "$constant");
        Intrinsics.checkNotNullParameter(it, "it");
        return $constant.getValue(it);
    }

    private static final Object collectPrimitiveConstantEntries$lambda$15(Set $expectedTypes, CompileTimeConstant constant) {
        Intrinsics.checkNotNullParameter($expectedTypes, "$expectedTypes");
        Intrinsics.checkNotNullParameter(constant, "constant");
        return SequencesKt.firstOrNull(SequencesKt.mapNotNull(CollectionsKt.asSequence($expectedTypes), arg_0 -> WhenTranslator.collectPrimitiveConstantEntries$lambda$15$lambda$14(constant, arg_0)));
    }

    private static final boolean collectPrimitiveConstantEntries$lambda$16(WhenTranslator this$0, Object it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter(it, "it");
        return this$0.uniqueConstants.add(it);
    }

    private static final JsExpression collectPrimitiveConstantEntries$lambda$17(Object it) {
        Intrinsics.checkNotNullParameter(it, "it");
        Object object = it;
        return object instanceof String ? (JsExpression)new JsStringLiteral((String)it) : (object instanceof Integer ? (JsExpression)new JsIntLiteral(((Number)it).intValue()) : (object instanceof Short ? (JsExpression)new JsIntLiteral(((Number)it).shortValue()) : (object instanceof Byte ? (JsExpression)new JsIntLiteral(((Number)it).byteValue()) : (object instanceof Character ? (JsExpression)new JsIntLiteral(((Character)it).charValue()) : null))));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final String collectEnumEntries$lambda$19(KotlinType $expectedType, ClassId $classId, CompileTimeConstant it) {
        Intrinsics.checkNotNullParameter($expectedType, "$expectedType");
        Intrinsics.checkNotNullParameter(it, "it");
        EnumValue enumValue = it.toConstantValue($expectedType);
        if (!(enumValue instanceof EnumValue)) return null;
        EnumValue enumValue2 = enumValue;
        EnumValue enumValue3 = enumValue2;
        if (enumValue3 == null) return null;
        Object object = enumValue3;
        EnumValue enumEntry = object;
        boolean bl = false;
        if (!Intrinsics.areEqual(enumEntry.getEnumClassId(), $classId)) return null;
        EnumValue enumValue4 = object;
        enumValue = enumValue4;
        if (enumValue == null) return null;
        object = enumValue.getEnumEntryName();
        if (object == null) return null;
        String string2 = ((Name)object).getIdentifier();
        return string2;
    }

    private static final boolean collectEnumEntries$lambda$20(WhenTranslator this$0, String it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter(it, "it");
        return this$0.uniqueEnumNames.add(it);
    }

    private static final JsExpression collectEnumEntries$lambda$21(String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return new JsStringLiteral(it);
    }

    @JvmStatic
    @NotNull
    public static final JsNode translate(@NotNull KtWhenExpression expression2, @NotNull TranslationContext context2) {
        return Companion.translate(expression2, context2);
    }

    public /* synthetic */ WhenTranslator(KtWhenExpression whenExpression, TranslationContext context2, DefaultConstructorMarker $constructor_marker) {
        this(whenExpression, context2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/js/translate/expression/WhenTranslator$Companion;", "", "<init>", "()V", "translate", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "expression", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "isNegated", "", "condition", "Lorg/jetbrains/kotlin/psi/KtWhenCondition;", "js.translator"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final JsNode translate(@NotNull KtWhenExpression expression2, @NotNull TranslationContext context2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            Intrinsics.checkNotNullParameter(context2, "context");
            return new WhenTranslator(expression2, context2, null).translate();
        }

        private final boolean isNegated(KtWhenCondition condition) {
            KtWhenConditionIsPattern ktWhenConditionIsPattern = condition instanceof KtWhenConditionIsPattern ? (KtWhenConditionIsPattern)condition : null;
            return ktWhenConditionIsPattern != null ? ktWhenConditionIsPattern.isNegated() : false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

