/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.scopes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.ScopeUtilsKt;
import org.jetbrains.kotlin.fir.scopes.CallableCopyTypeCalculator;
import org.jetbrains.kotlin.fir.scopes.FirContainingNamesAwareScope;
import org.jetbrains.kotlin.fir.scopes.FirKotlinScopeProviderKt;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.scopes.FirTypeScopeKt;
import org.jetbrains.kotlin.fir.scopes.ProcessorAction;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a.\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\b2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a&\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\b2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\f\u001a\u00020\r\u001a0\u0010\u000e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100\u000f*\u00020\u00112\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0014"}, d2={"getNestedClassifierScope", "Lorg/jetbrains/kotlin/fir/scopes/FirContainingNamesAwareScope;", "Lorg/jetbrains/kotlin/fir/symbols/ConeClassLikeLookupTag;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "debugCollectOverrides", "", "", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "scope", "Lorg/jetbrains/kotlin/fir/scopes/FirTypeScope;", "overriddenFunctions", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirFunctionSymbol;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "containingClass", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;", "providers"})
public final class ScopesKt {
    @Nullable
    public static final FirContainingNamesAwareScope getNestedClassifierScope(@NotNull ConeClassLikeLookupTag $this$getNestedClassifierScope, @NotNull FirSession session2, @NotNull ScopeSession scopeSession) {
        Intrinsics.checkNotNullParameter($this$getNestedClassifierScope, "<this>");
        Intrinsics.checkNotNullParameter(session2, "session");
        Intrinsics.checkNotNullParameter(scopeSession, "scopeSession");
        FirClassLikeSymbol<?> firClassLikeSymbol = LookupTagUtilsKt.toSymbol($this$getNestedClassifierScope, session2);
        FirClassLikeDeclaration firClassLikeDeclaration = firClassLikeSymbol != null ? (FirClassLikeDeclaration)firClassLikeSymbol.getFir() : null;
        FirRegularClass firRegularClass = firClassLikeDeclaration instanceof FirRegularClass ? (FirRegularClass)firClassLikeDeclaration : null;
        if (firRegularClass == null) {
            return null;
        }
        FirRegularClass klass = firRegularClass;
        return klass.getScopeProvider().getNestedClassifierScope(klass, session2, scopeSession);
    }

    @NotNull
    public static final Map<Object, Object> debugCollectOverrides(@NotNull FirCallableSymbol<?> symbol, @NotNull FirSession session2, @NotNull ScopeSession scopeSession) {
        Intrinsics.checkNotNullParameter(symbol, "symbol");
        Intrinsics.checkNotNullParameter(session2, "session");
        Intrinsics.checkNotNullParameter(scopeSession, "scopeSession");
        Object object = symbol.getDispatchReceiverType();
        if (object == null || (object = ScopeUtilsKt.scope((ConeKotlinType)object, session2, scopeSession, CallableCopyTypeCalculator.DoNothing.INSTANCE, FirResolvePhase.STATUS)) == null) {
            return MapsKt.emptyMap();
        }
        Object scope2 = object;
        return ScopesKt.debugCollectOverrides(symbol, (FirTypeScope)scope2);
    }

    @NotNull
    public static final Map<Object, Object> debugCollectOverrides(@NotNull FirCallableSymbol<?> symbol, @NotNull FirTypeScope scope2) {
        Intrinsics.checkNotNullParameter(symbol, "symbol");
        Intrinsics.checkNotNullParameter(scope2, "scope");
        return ScopesKt.debugCollectOverrides$process(scope2, symbol);
    }

    @NotNull
    public static final Collection<FirFunctionSymbol<?>> overriddenFunctions(@NotNull FirNamedFunctionSymbol $this$overriddenFunctions, @NotNull FirClassSymbol<?> containingClass, @NotNull FirSession session2, @NotNull ScopeSession scopeSession) {
        Intrinsics.checkNotNullParameter($this$overriddenFunctions, "<this>");
        Intrinsics.checkNotNullParameter(containingClass, "containingClass");
        Intrinsics.checkNotNullParameter(session2, "session");
        Intrinsics.checkNotNullParameter(scopeSession, "scopeSession");
        FirTypeScope firTypeScope = FirKotlinScopeProviderKt.unsubstitutedScope(containingClass, session2, scopeSession, true, FirResolvePhase.STATUS);
        Set overriddenFunctions = new LinkedHashSet();
        firTypeScope.processFunctionsByName($this$overriddenFunctions.getCallableId().getCallableName(), ScopesKt::overriddenFunctions$lambda$2);
        FirTypeScopeKt.processOverriddenFunctions(firTypeScope, $this$overriddenFunctions, arg_0 -> ScopesKt.overriddenFunctions$lambda$3(overriddenFunctions, arg_0));
        ((Collection)overriddenFunctions).remove($this$overriddenFunctions);
        return overriddenFunctions;
    }

    private static final ProcessorAction debugCollectOverrides$process$lambda$0(List $resultList, FirNamedFunctionSymbol baseSymbol, FirTypeScope baseScope) {
        Intrinsics.checkNotNullParameter($resultList, "$resultList");
        Intrinsics.checkNotNullParameter(baseSymbol, "baseSymbol");
        Intrinsics.checkNotNullParameter(baseScope, "baseScope");
        $resultList.add(ScopesKt.debugCollectOverrides$process(baseScope, baseSymbol));
        return ProcessorAction.NEXT;
    }

    private static final ProcessorAction debugCollectOverrides$process$lambda$1(List $resultList, FirPropertySymbol baseSymbol, FirTypeScope baseScope) {
        Intrinsics.checkNotNullParameter($resultList, "$resultList");
        Intrinsics.checkNotNullParameter(baseSymbol, "baseSymbol");
        Intrinsics.checkNotNullParameter(baseScope, "baseScope");
        $resultList.add(ScopesKt.debugCollectOverrides$process(baseScope, baseSymbol));
        return ProcessorAction.NEXT;
    }

    private static final Map<Object, Object> debugCollectOverrides$process(FirTypeScope scope2, FirCallableSymbol<?> symbol) {
        Map result2 = new LinkedHashMap();
        List resultList = new ArrayList();
        FirCallableSymbol<?> firCallableSymbol = symbol;
        if (firCallableSymbol instanceof FirNamedFunctionSymbol) {
            scope2.processDirectOverriddenFunctionsWithBaseScope((FirNamedFunctionSymbol)symbol, (arg_0, arg_1) -> ScopesKt.debugCollectOverrides$process$lambda$0(resultList, arg_0, arg_1));
        } else if (firCallableSymbol instanceof FirPropertySymbol) {
            scope2.processDirectOverriddenPropertiesWithBaseScope((FirPropertySymbol)symbol, (arg_0, arg_1) -> ScopesKt.debugCollectOverrides$process$lambda$1(resultList, arg_0, arg_1));
        }
        result2.put(symbol, resultList);
        return result2;
    }

    private static final Unit overriddenFunctions$lambda$2(FirNamedFunctionSymbol it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Unit.INSTANCE;
    }

    private static final ProcessorAction overriddenFunctions$lambda$3(Set $overriddenFunctions, FirNamedFunctionSymbol it) {
        Intrinsics.checkNotNullParameter($overriddenFunctions, "$overriddenFunctions");
        Intrinsics.checkNotNullParameter(it, "it");
        $overriddenFunctions.add(it);
        return ProcessorAction.NEXT;
    }
}

