/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlinx.collections.immutable.ExtensionsKt;
import kotlinx.collections.immutable.PersistentList;
import kotlinx.collections.immutable.PersistentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.resolve.ImplicitReceiverStack;
import org.jetbrains.kotlin.fir.resolve.calls.ContextReceiverValue;
import org.jetbrains.kotlin.fir.resolve.calls.ImplicitDispatchReceiverValue;
import org.jetbrains.kotlin.fir.resolve.calls.ImplicitReceiverValue;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.util.PersistentSetMultimap;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010(\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u0002BY\b\u0002\u0012\u0010\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u0005\u0012\u0016\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u0007\u0012\u0016\u0010\t\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0012\u0004\u0012\u00020\f0\n\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0005\u00a2\u0006\u0004\b\u000f\u0010\u0010B\t\b\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0011J\u0018\u0010\u0015\u001a\u00020\u00002\u0010\u0010\u0016\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u0017J\u0018\u0010\u0018\u001a\u00020\u00002\u0010\u0010\u0016\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00190\u0017J(\u0010\u001a\u001a\u00020\u00002\b\u0010\u001b\u001a\u0004\u0018\u00010\b2\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u00032\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\bJB\u0010\u001e\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u0007*\u0012\u0012\u0004\u0012\u00020\b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u00072\b\u0010\u001b\u001a\u0004\u0018\u00010\b2\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u0003H\u0002J\u0012\u0010\u001f\u001a\u00020\u00002\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u0019J\u0019\u0010 \u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00032\b\u0010\u001b\u001a\u0004\u0018\u00010!H\u0096\u0002J\n\u0010\"\u001a\u0004\u0018\u00010#H\u0016J\"\u0010\"\u001a\u0004\u0018\u00010#2\u0016\u0010$\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0003\u0012\u0004\u0012\u00020&0%H\u0016J\u0012\u0010'\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u0017H\u0016J\u0013\u0010(\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030)H\u0096\u0002J\u0019\u0010*\u001a\u0004\u0018\u00010\f2\n\u0010+\u001a\u0006\u0012\u0002\b\u00030\u000b\u00a2\u0006\u0002\u0010,J\u000e\u0010-\u001a\u00020\u000e2\u0006\u0010.\u001a\u00020\fJ\u000e\u0010/\u001a\u00020\u000e2\u0006\u0010.\u001a\u00020\fJ\u0016\u00100\u001a\u0002012\u0006\u0010.\u001a\u00020\f2\u0006\u00102\u001a\u00020\u000eJ\u000e\u00103\u001a\u00020\u00002\u0006\u00104\u001a\u00020&R\u0018\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u00065"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/PersistentImplicitReceiverStack;", "Lorg/jetbrains/kotlin/fir/resolve/ImplicitReceiverStack;", "", "Lorg/jetbrains/kotlin/fir/resolve/calls/ImplicitReceiverValue;", "stack", "Lkotlinx/collections/immutable/PersistentList;", "receiversPerLabel", "Lorg/jetbrains/kotlin/fir/util/PersistentSetMultimap;", "Lorg/jetbrains/kotlin/name/Name;", "indexesPerSymbol", "Lkotlinx/collections/immutable/PersistentMap;", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "", "originalTypes", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "<init>", "(Lkotlinx/collections/immutable/PersistentList;Lorg/jetbrains/kotlin/fir/util/PersistentSetMultimap;Lkotlinx/collections/immutable/PersistentMap;Lkotlinx/collections/immutable/PersistentList;)V", "()V", "size", "getSize", "()I", "addAll", "receivers", "", "addAllContextReceivers", "Lorg/jetbrains/kotlin/fir/resolve/calls/ContextReceiverValue;", "add", "name", "value", "aliasLabel", "putIfNameIsNotNull", "addContextReceiver", "get", "", "lastDispatchReceiver", "Lorg/jetbrains/kotlin/fir/resolve/calls/ImplicitDispatchReceiverValue;", "lookupCondition", "Lkotlin/Function1;", "", "receiversAsReversed", "iterator", "", "getReceiverIndex", "symbol", "(Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;)Ljava/lang/Integer;", "getOriginalType", "index", "getType", "replaceReceiverType", "", "type", "createSnapshot", "keepMutable", "semantics"})
@SourceDebugExtension(value={"SMAP\nPersistentImplicitReceiverStack.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PersistentImplicitReceiverStack.kt\norg/jetbrains/kotlin/fir/resolve/PersistentImplicitReceiverStack\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,122:1\n1797#2,3:123\n1797#2,3:126\n808#2,11:129\n808#2,11:140\n543#2,6:151\n1557#2:157\n1628#2,3:158\n*S KotlinDebug\n*F\n+ 1 PersistentImplicitReceiverStack.kt\norg/jetbrains/kotlin/fir/resolve/PersistentImplicitReceiverStack\n*L\n34#1:123,3\n38#1:126,3\n80#1:129,11\n84#1:140,11\n84#1:151,6\n115#1:157\n115#1:158,3\n*E\n"})
public final class PersistentImplicitReceiverStack
extends ImplicitReceiverStack
implements Iterable<ImplicitReceiverValue<?>>,
KMappedMarker {
    @NotNull
    private final PersistentList<ImplicitReceiverValue<?>> stack;
    @NotNull
    private final PersistentSetMultimap<Name, ImplicitReceiverValue<?>> receiversPerLabel;
    @NotNull
    private final PersistentMap<FirBasedSymbol<?>, Integer> indexesPerSymbol;
    @NotNull
    private final PersistentList<ConeKotlinType> originalTypes;

    private PersistentImplicitReceiverStack(PersistentList<? extends ImplicitReceiverValue<?>> stack, PersistentSetMultimap<Name, ImplicitReceiverValue<?>> receiversPerLabel, PersistentMap<FirBasedSymbol<?>, Integer> indexesPerSymbol, PersistentList<? extends ConeKotlinType> originalTypes) {
        this.stack = stack;
        this.receiversPerLabel = receiversPerLabel;
        this.indexesPerSymbol = indexesPerSymbol;
        this.originalTypes = originalTypes;
    }

    public final int getSize() {
        return this.stack.size();
    }

    public PersistentImplicitReceiverStack() {
        this(ExtensionsKt.persistentListOf(), new PersistentSetMultimap(), ExtensionsKt.persistentMapOf(), ExtensionsKt.persistentListOf());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final PersistentImplicitReceiverStack addAll(@NotNull List<? extends ImplicitReceiverValue<?>> receivers) {
        Intrinsics.checkNotNullParameter(receivers, "receivers");
        Iterable $this$fold$iv = receivers;
        boolean $i$f$fold = false;
        PersistentImplicitReceiverStack accumulator$iv = this;
        for (Object element$iv : $this$fold$iv) {
            void value2;
            ImplicitReceiverValue implicitReceiverValue = (ImplicitReceiverValue)element$iv;
            PersistentImplicitReceiverStack acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = PersistentImplicitReceiverStack.add$default(acc, null, (ImplicitReceiverValue)value2, null, 4, null);
        }
        return accumulator$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final PersistentImplicitReceiverStack addAllContextReceivers(@NotNull List<? extends ContextReceiverValue<?>> receivers) {
        Intrinsics.checkNotNullParameter(receivers, "receivers");
        Iterable $this$fold$iv = receivers;
        boolean $i$f$fold = false;
        PersistentImplicitReceiverStack accumulator$iv = this;
        for (Object element$iv : $this$fold$iv) {
            void value2;
            ContextReceiverValue contextReceiverValue = (ContextReceiverValue)element$iv;
            PersistentImplicitReceiverStack acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = acc.addContextReceiver((ContextReceiverValue<?>)value2);
        }
        return accumulator$iv;
    }

    @NotNull
    public final PersistentImplicitReceiverStack add(@Nullable Name name2, @NotNull ImplicitReceiverValue<?> value2, @Nullable Name aliasLabel) {
        Intrinsics.checkNotNullParameter(value2, "value");
        PersistentList<ImplicitReceiverValue<?>> stack = this.stack.add(value2);
        PersistentList<ConeKotlinType> originalTypes = this.originalTypes.add(value2.getOriginalType());
        int index = stack.size() - 1;
        PersistentSetMultimap<Name, ImplicitReceiverValue<?>> receiversPerLabel = this.putIfNameIsNotNull(this.putIfNameIsNotNull(this.receiversPerLabel, name2, value2), aliasLabel, value2);
        PersistentMap<FirBasedSymbol<?>, Integer> indexesPerSymbol = this.indexesPerSymbol.put((FirBasedSymbol<?>)value2.getBoundSymbol(), index);
        return new PersistentImplicitReceiverStack(stack, receiversPerLabel, indexesPerSymbol, originalTypes);
    }

    public static /* synthetic */ PersistentImplicitReceiverStack add$default(PersistentImplicitReceiverStack persistentImplicitReceiverStack, Name name2, ImplicitReceiverValue implicitReceiverValue, Name name3, int n, Object object) {
        if ((n & 4) != 0) {
            name3 = null;
        }
        return persistentImplicitReceiverStack.add(name2, implicitReceiverValue, name3);
    }

    private final PersistentSetMultimap<Name, ImplicitReceiverValue<?>> putIfNameIsNotNull(PersistentSetMultimap<Name, ImplicitReceiverValue<?>> $this$putIfNameIsNotNull, Name name2, ImplicitReceiverValue<?> value2) {
        return name2 != null ? $this$putIfNameIsNotNull.put(name2, value2) : $this$putIfNameIsNotNull;
    }

    @NotNull
    public final PersistentImplicitReceiverStack addContextReceiver(@NotNull ContextReceiverValue<?> value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        Name name2 = value2.getLabelName();
        if (name2 == null) {
            return this;
        }
        Name labelName = name2;
        PersistentSetMultimap<Name, ImplicitReceiverValue<?>> receiversPerLabel = this.receiversPerLabel.put(labelName, value2);
        return new PersistentImplicitReceiverStack(this.stack, receiversPerLabel, this.indexesPerSymbol, this.originalTypes);
    }

    @Override
    @Nullable
    public ImplicitReceiverValue<?> get(@Nullable String name2) {
        if (name2 == null) {
            return (ImplicitReceiverValue)CollectionsKt.lastOrNull((List)this.stack);
        }
        Name name3 = Name.identifier(name2);
        Intrinsics.checkNotNullExpressionValue(name3, "identifier(...)");
        return (ImplicitReceiverValue)CollectionsKt.lastOrNull((Iterable)this.receiversPerLabel.get(name3));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public ImplicitDispatchReceiverValue lastDispatchReceiver() {
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = this.stack;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof ImplicitDispatchReceiverValue)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (ImplicitDispatchReceiverValue)CollectionsKt.lastOrNull((List)destination$iv$iv);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public ImplicitDispatchReceiverValue lastDispatchReceiver(@NotNull Function1<? super ImplicitReceiverValue<?>, Boolean> lookupCondition) {
        Object v0;
        block2: {
            void $this$filterIsInstanceTo$iv$iv;
            Intrinsics.checkNotNullParameter(lookupCondition, "lookupCondition");
            Iterable $this$filterIsInstance$iv = this.stack;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof ImplicitDispatchReceiverValue)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List $this$lastOrNull$iv = (List)destination$iv$iv;
            boolean $i$f$lastOrNull = false;
            ListIterator iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
            while (iterator$iv.hasPrevious()) {
                Object element$iv = iterator$iv.previous();
                if (!lookupCondition.invoke((ImplicitReceiverValue<?>)element$iv).booleanValue()) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        return v0;
    }

    @Override
    @NotNull
    public List<ImplicitReceiverValue<?>> receiversAsReversed() {
        return CollectionsKt.asReversed((List)this.stack);
    }

    @Override
    @NotNull
    public Iterator<ImplicitReceiverValue<?>> iterator() {
        return this.stack.iterator();
    }

    @Nullable
    public final Integer getReceiverIndex(@NotNull FirBasedSymbol<?> symbol) {
        Intrinsics.checkNotNullParameter(symbol, "symbol");
        return (Integer)this.indexesPerSymbol.get(symbol);
    }

    @NotNull
    public final ConeKotlinType getOriginalType(int index) {
        return (ConeKotlinType)this.originalTypes.get(index);
    }

    @NotNull
    public final ConeKotlinType getType(int index) {
        return ((ImplicitReceiverValue)this.stack.get(index)).getType();
    }

    public final void replaceReceiverType(int index, @NotNull ConeKotlinType type2) {
        boolean bl;
        Intrinsics.checkNotNullParameter(type2, "type");
        boolean bl2 = bl = index >= 0 && index < this.stack.size();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        ((ImplicitReceiverValue)this.stack.get(index)).updateTypeFromSmartcast(type2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final PersistentImplicitReceiverStack createSnapshot(boolean keepMutable) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.stack;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ImplicitReceiverValue implicitReceiverValue = (ImplicitReceiverValue)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.createSnapshot(keepMutable));
        }
        PersistentList<ConeKotlinType> persistentList = this.originalTypes;
        PersistentMap<FirBasedSymbol<?>, Integer> persistentMap = this.indexesPerSymbol;
        PersistentSetMultimap<Name, ImplicitReceiverValue<?>> persistentSetMultimap = this.receiversPerLabel;
        PersistentList persistentList2 = ExtensionsKt.toPersistentList((List)destination$iv$iv);
        return new PersistentImplicitReceiverStack(persistentList2, persistentSetMultimap, persistentMap, persistentList);
    }
}

