/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.type;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirArrayOfNothingQualifierChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.type.FirTypeChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/type/FirArrayOfNothingTypeChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/type/FirTypeRefChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/type/FirTypeChecker;", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "<init>", "()V", "check", "", "typeRef", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirArrayOfNothingTypeChecker
extends FirTypeChecker<FirTypeRef> {
    @NotNull
    public static final FirArrayOfNothingTypeChecker INSTANCE = new FirArrayOfNothingTypeChecker();

    private FirArrayOfNothingTypeChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirTypeRef typeRef, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        boolean isVararg;
        Intrinsics.checkNotNullParameter(typeRef, "typeRef");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        if (CollectionsKt.lastOrNull(context2.getContainingDeclarations()) instanceof FirTypeAlias) {
            return;
        }
        ConeKotlinType coneKotlinType = FirTypeUtilsKt.getConeTypeOrNull(typeRef);
        if (coneKotlinType == null) {
            return;
        }
        ConeKotlinType coneType = coneKotlinType;
        ConeKotlinType fullyExpandedType = TypeExpansionUtilsKt.fullyExpandedType(coneType, context2.getSession());
        FirDeclaration firDeclaration = CollectionsKt.lastOrNull(context2.getContainingDeclarations());
        FirValueParameter firValueParameter = firDeclaration instanceof FirValueParameter ? (FirValueParameter)firDeclaration : null;
        boolean bl = isVararg = firValueParameter != null ? firValueParameter.isVararg() : false;
        if (!isVararg && FirArrayOfNothingQualifierChecker.INSTANCE.isArrayOfNothing(fullyExpandedType)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)typeRef.getSource(), FirErrors.INSTANCE.getUNSUPPORTED(), (Object)"Array<Nothing> is illegal", (DiagnosticContext)context2, null, 16, null);
        }
    }
}

