/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.syntax;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtLightSourceElement;
import org.jetbrains.kotlin.KtPsiSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.diagnostics.LightTreePositioningStrategiesKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.syntax.FirDeclarationSyntaxChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.psi.KtFunction;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J0\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J(\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/syntax/FirAnonymousFunctionSyntaxChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/syntax/FirDeclarationSyntaxChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousFunction;", "Lorg/jetbrains/kotlin/psi/KtFunction;", "<init>", "()V", "checkPsi", "", "element", "source", "Lorg/jetbrains/kotlin/KtPsiSourceElement;", "psi", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkLightTree", "Lorg/jetbrains/kotlin/KtLightSourceElement;", "checkers"})
public final class FirAnonymousFunctionSyntaxChecker
extends FirDeclarationSyntaxChecker<FirAnonymousFunction, KtFunction> {
    @NotNull
    public static final FirAnonymousFunctionSyntaxChecker INSTANCE = new FirAnonymousFunctionSyntaxChecker();

    private FirAnonymousFunctionSyntaxChecker() {
    }

    @Override
    public void checkPsi(@NotNull FirAnonymousFunction element, @NotNull KtPsiSourceElement source, @NotNull KtFunction psi, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(element, "element");
        Intrinsics.checkNotNullParameter(source, "source");
        Intrinsics.checkNotNullParameter(psi, "psi");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        if (psi.getTypeParameterList() != null) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getTYPE_PARAMETERS_NOT_ALLOWED(), (DiagnosticContext)context2, null, 8, null);
        }
    }

    @Override
    public void checkLightTree(@NotNull FirAnonymousFunction element, @NotNull KtLightSourceElement source, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        block0: {
            Intrinsics.checkNotNullParameter(element, "element");
            Intrinsics.checkNotNullParameter(source, "source");
            Intrinsics.checkNotNullParameter(context2, "context");
            Intrinsics.checkNotNullParameter(reporter, "reporter");
            if (LightTreePositioningStrategiesKt.typeParametersList(source.getTreeStructure(), source.getLighterASTNode()) == null) break block0;
            boolean bl = false;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getTYPE_PARAMETERS_NOT_ALLOWED(), (DiagnosticContext)context2, null, 8, null);
        }
    }
}

