/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKind;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.analysis.checkers.FirKeywordUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0018\u0010\r\u001a\u00020\u000e*\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOpenMemberChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirClassChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "shouldReportOpenFromSource", "", "Lorg/jetbrains/kotlin/KtSourceElement;", "getShouldReportOpenFromSource", "(Lorg/jetbrains/kotlin/KtSourceElement;)Z", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirOpenMemberChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirOpenMemberChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOpenMemberChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,53:1\n13#2:54\n40#2:55\n*S KotlinDebug\n*F\n+ 1 FirOpenMemberChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOpenMemberChecker\n*L\n34#1:54\n34#1:55\n*E\n"})
public final class FirOpenMemberChecker
extends FirDeclarationChecker<FirClass> {
    @NotNull
    public static final FirOpenMemberChecker INSTANCE = new FirOpenMemberChecker();

    private FirOpenMemberChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirClass declaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        if (DeclarationUtilsKt.getCanHaveOpenMembers(declaration)) {
            return;
        }
        for (FirDeclaration memberDeclaration : declaration.getDeclarations()) {
            KtSourceElement source;
            block7: {
                block6: {
                    if (!(memberDeclaration instanceof FirCallableDeclaration) || memberDeclaration instanceof FirConstructor || ((FirCallableDeclaration)memberDeclaration).getSource() == null) continue;
                    FirMemberDeclaration $this$isOpen$iv = (FirMemberDeclaration)memberDeclaration;
                    boolean $i$f$isOpen = false;
                    if (!($this$isOpen$iv.getStatus().getModality() == Modality.OPEN)) break block6;
                    FirMemberDeclaration $this$isOverride$iv = (FirMemberDeclaration)memberDeclaration;
                    boolean $i$f$isOverride = false;
                    if (!$this$isOverride$iv.getStatus().isOverride() && declaration.getClassKind() == ClassKind.ANNOTATION_CLASS) break block7;
                }
                FirElement firElement = memberDeclaration;
                KtModifierKeywordToken ktModifierKeywordToken = KtTokens.OPEN_KEYWORD;
                Intrinsics.checkNotNullExpressionValue(ktModifierKeywordToken, "OPEN_KEYWORD");
                if (!FirKeywordUtilsKt.hasModifier(firElement, ktModifierKeywordToken) || !this.getShouldReportOpenFromSource(source)) continue;
            }
            if (declaration.getClassKind() == ClassKind.OBJECT) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getNON_FINAL_MEMBER_IN_OBJECT(), (DiagnosticContext)context2, null, 8, null);
                continue;
            }
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getNON_FINAL_MEMBER_IN_FINAL_CLASS(), (DiagnosticContext)context2, null, 8, null);
        }
    }

    private final boolean getShouldReportOpenFromSource(KtSourceElement $this$shouldReportOpenFromSource) {
        KtSourceElementKind ktSourceElementKind = $this$shouldReportOpenFromSource.getKind();
        return Intrinsics.areEqual(ktSourceElementKind, KtRealSourceElementKind.INSTANCE) || Intrinsics.areEqual(ktSourceElementKind, KtFakeSourceElementKind.PropertyFromParameter.INSTANCE);
    }
}

