/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower.loops.handlers;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.lower.loops.handlers.IndexedGetIterationHandler;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0010\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0016R\u0018\u0010\u000e\u001a\u00020\u000f*\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0018\u0010\u0013\u001a\u00020\u000f*\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/loops/handlers/CharSequenceIterationHandler;", "Lorg/jetbrains/kotlin/backend/common/lower/loops/handlers/IndexedGetIterationHandler;", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "canCacheLast", "", "<init>", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;Z)V", "matchIterable", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "matchIteratorCall", "call", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "sizePropertyGetter", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "Lorg/jetbrains/kotlin/ir/types/IrType;", "getSizePropertyGetter", "(Lorg/jetbrains/kotlin/ir/types/IrType;)Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "getFunction", "getGetFunction", "ir.backend.common"})
public class CharSequenceIterationHandler
extends IndexedGetIterationHandler {
    public CharSequenceIterationHandler(@NotNull CommonBackendContext context2, boolean canCacheLast) {
        Intrinsics.checkNotNullParameter(context2, "context");
        super(context2, canCacheLast);
    }

    public /* synthetic */ CharSequenceIterationHandler(CommonBackendContext commonBackendContext, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(commonBackendContext, bl);
    }

    public boolean matchIterable(@NotNull IrExpression expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        return IrTypeUtilsKt.isSubtypeOfClass(expression2.getType(), this.getContext().getIr().getSymbols().getCharSequence());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean matchIteratorCall(@NotNull IrCall call2) {
        Intrinsics.checkNotNullParameter(call2, "call");
        IrSimpleFunction callee = (IrSimpleFunction)call2.getSymbol().getOwner();
        if (!callee.getValueParameters().isEmpty()) return false;
        IrValueParameter irValueParameter = callee.getExtensionReceiverParameter();
        IrAnnotationContainer irAnnotationContainer = irValueParameter;
        if (irValueParameter == null) return false;
        IrType irType = irAnnotationContainer.getType();
        irAnnotationContainer = irType;
        if (irType == null) return false;
        if (!IrTypePredicatesKt.isCharSequence((IrType)irAnnotationContainer)) return false;
        boolean bl = true;
        if (!bl) return false;
        if (!Intrinsics.areEqual(AdditionalIrUtilsKt.getKotlinFqName(callee), new FqName("kotlin.text." + OperatorNameConventions.ITERATOR))) return false;
        return true;
    }

    @Override
    @NotNull
    public IrSimpleFunction getSizePropertyGetter(@NotNull IrType $this$sizePropertyGetter) {
        Intrinsics.checkNotNullParameter($this$sizePropertyGetter, "<this>");
        IrSimpleFunctionSymbol irSimpleFunctionSymbol = AdditionalIrUtilsKt.getPropertyGetter(this.getContext().getIr().getSymbols().getCharSequence(), "length");
        Intrinsics.checkNotNull(irSimpleFunctionSymbol);
        return (IrSimpleFunction)irSimpleFunctionSymbol.getOwner();
    }

    @Override
    @NotNull
    public IrSimpleFunction getGetFunction(@NotNull IrType $this$getFunction) {
        Intrinsics.checkNotNullParameter($this$getFunction, "<this>");
        IrClassSymbol irClassSymbol = this.getContext().getIr().getSymbols().getCharSequence();
        String string2 = OperatorNameConventions.GET.asString();
        Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
        IrSimpleFunctionSymbol irSimpleFunctionSymbol = AdditionalIrUtilsKt.getSimpleFunction(irClassSymbol, string2);
        Intrinsics.checkNotNull(irSimpleFunctionSymbol);
        return (IrSimpleFunction)irSimpleFunctionSymbol.getOwner();
    }
}

