/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common;

import java.util.Collection;
import java.util.LinkedHashSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CheckDeclarationParentsVisitor;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.IrValidator;
import org.jetbrains.kotlin.backend.common.IrValidatorConfig;
import org.jetbrains.kotlin.backend.common.UtilsKt;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b\u001a&\u0010\t\u001a\u00020\u0001*\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\n\u0010\u000e\u001a\u00020\u0001*\u00020\r\u00a8\u0006\u000f"}, d2={"validateIrFile", "", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "validateIrModule", "irModule", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "reportIrValidationError", "message", "", "irElement", "Lorg/jetbrains/kotlin/ir/IrElement;", "checkDeclarationParents", "ir.backend.common"})
@SourceDebugExtension(value={"SMAP\nIrValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrValidator.kt\norg/jetbrains/kotlin/backend/common/IrValidatorKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,145:1\n1863#2,2:146\n1863#2,2:148\n*S KotlinDebug\n*F\n+ 1 IrValidator.kt\norg/jetbrains/kotlin/backend/common/IrValidatorKt\n*L\n108#1:146,2\n121#1:148,2\n*E\n"})
public final class IrValidatorKt {
    public static final void validateIrFile(@NotNull CommonBackendContext context2, @NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(irFile, "irFile");
        IrValidator visitor2 = new IrValidator(context2, new IrValidatorConfig(false, false, false, false, false, false, 60, null));
        IrVisitorsKt.acceptVoid(irFile, visitor2);
    }

    public static final void validateIrModule(@NotNull CommonBackendContext context2, @NotNull IrModuleFragment irModule) {
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(irModule, "irModule");
        IrValidator visitor2 = new IrValidator(context2, new IrValidatorConfig(false, true, false, false, false, false, 60, null));
        IrVisitorsKt.acceptVoid(irModule, visitor2);
    }

    private static final void reportIrValidationError(CommonBackendContext $this$reportIrValidationError, String message, IrFile irFile, IrElement irElement) {
        try {
            UtilsKt.reportWarning($this$reportIrValidationError, "[IR VALIDATION] " + message, irFile, irElement);
        }
        catch (Throwable e) {
            System.out.println((Object)("an error trying to print a warning message: " + e));
            e.printStackTrace();
        }
    }

    public static final void checkDeclarationParents(@NotNull IrElement $this$checkDeclarationParents) {
        Intrinsics.checkNotNullParameter($this$checkDeclarationParents, "<this>");
        CheckDeclarationParentsVisitor checker = new CheckDeclarationParentsVisitor();
        $this$checkDeclarationParents.accept(checker, null);
        if (!((Collection)checker.getErrors()).isEmpty()) {
            Object it;
            StringBuilder stringBuilder;
            LinkedHashSet<IrDeclarationParent> expectedParents = new LinkedHashSet<IrDeclarationParent>();
            StringBuilder $this$checkDeclarationParents_u24lambda_u242 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$checkDeclarationParents_u24lambda_u242.append("Declarations with wrong parent: ");
            $this$checkDeclarationParents_u24lambda_u242.append(checker.getErrors().size());
            $this$checkDeclarationParents_u24lambda_u242.append("\n");
            Iterable $this$forEach$iv = checker.getErrors();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (CheckDeclarationParentsVisitor.Error)element$iv;
                boolean bl2 = false;
                $this$checkDeclarationParents_u24lambda_u242.append("declaration: ");
                $this$checkDeclarationParents_u24lambda_u242.append(RenderIrElementKt.render$default(((CheckDeclarationParentsVisitor.Error)it).getDeclaration(), null, 1, null));
                $this$checkDeclarationParents_u24lambda_u242.append("\n\t");
                $this$checkDeclarationParents_u24lambda_u242.append(((CheckDeclarationParentsVisitor.Error)it).getDeclaration());
                $this$checkDeclarationParents_u24lambda_u242.append("\nexpectedParent: ");
                $this$checkDeclarationParents_u24lambda_u242.append(RenderIrElementKt.render$default(((CheckDeclarationParentsVisitor.Error)it).getExpectedParent(), null, 1, null));
                $this$checkDeclarationParents_u24lambda_u242.append("\nactualParent: ");
                IrDeclarationParent irDeclarationParent = ((CheckDeclarationParentsVisitor.Error)it).getActualParent();
                $this$checkDeclarationParents_u24lambda_u242.append(irDeclarationParent != null ? RenderIrElementKt.render$default(irDeclarationParent, null, 1, null) : null);
                $this$checkDeclarationParents_u24lambda_u242.append("\n");
                expectedParents.add(((CheckDeclarationParentsVisitor.Error)it).getExpectedParent());
            }
            $this$checkDeclarationParents_u24lambda_u242.append("\nExpected parents:\n");
            $this$forEach$iv = expectedParents;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (IrDeclarationParent)element$iv;
                boolean bl3 = false;
                $this$checkDeclarationParents_u24lambda_u242.append(DumpIrTreeKt.dump$default((IrElement)it, null, 1, null));
            }
            String string2 = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
            String string3 = string2;
            throw new AssertionError((Object)string3);
        }
    }

    public static final /* synthetic */ void access$reportIrValidationError(CommonBackendContext $receiver, String message, IrFile irFile, IrElement irElement) {
        IrValidatorKt.reportIrValidationError($receiver, message, irFile, irElement);
    }
}

