/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.diagnostic.LoadingState;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.JobFutureTask;
import com.intellij.openapi.progress.JobRunnable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.Async;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class BoundedTaskExecutor
extends AbstractExecutorService {
    private volatile boolean myShutdown;
    @NotNull
    private final String myName;
    private final Executor myBackendExecutor;
    private final int myMaxThreads;
    private final AtomicLong myStatus;
    private final BlockingQueue<Runnable> myTaskQueue;
    private final boolean myChangeThreadName;

    BoundedTaskExecutor(@NotNull @NonNls String name2, @NotNull Executor backendExecutor, int maxThreads, boolean changeThreadName) {
        if (name2 == null) {
            BoundedTaskExecutor.$$$reportNull$$$0(0);
        }
        if (backendExecutor == null) {
            BoundedTaskExecutor.$$$reportNull$$$0(1);
        }
        this(name2, backendExecutor, maxThreads, changeThreadName, new LinkedBlockingQueue<Runnable>());
        if (name2.isEmpty() || !Character.isUpperCase(name2.charAt(0))) {
            Logger.getInstance(this.getClass()).warn("Pool name must be capitalized but got: '" + name2 + "'", new IllegalArgumentException());
        }
    }

    BoundedTaskExecutor(@NotNull @NonNls String name2, @NotNull Executor backendExecutor, int maxThreads, boolean changeThreadName, @NotNull BlockingQueue<Runnable> queue) {
        if (name2 == null) {
            BoundedTaskExecutor.$$$reportNull$$$0(2);
        }
        if (backendExecutor == null) {
            BoundedTaskExecutor.$$$reportNull$$$0(3);
        }
        if (queue == null) {
            BoundedTaskExecutor.$$$reportNull$$$0(4);
        }
        this.myStatus = new AtomicLong();
        this.myName = name2;
        this.myBackendExecutor = backendExecutor;
        if (maxThreads < 1) {
            throw new IllegalArgumentException("maxThreads must be >=1 but got: " + maxThreads);
        }
        if (backendExecutor instanceof BoundedTaskExecutor) {
            throw new IllegalArgumentException("backendExecutor is already BoundedTaskExecutor: " + backendExecutor);
        }
        this.myMaxThreads = maxThreads;
        this.myChangeThreadName = changeThreadName;
        this.myTaskQueue = queue;
    }

    static Object info(Runnable info) {
        Runnable task = info;
        String extra = null;
        if (task instanceof FutureTask) {
            extra = ((FutureTask)task).isCancelled() ? " (future cancelled)" : (((FutureTask)task).isDone() ? " (future done)" : null);
            task = ObjectUtils.chooseNotNull(ReflectionUtil.getField(task.getClass(), task, Callable.class, "callable"), task);
        }
        if (task instanceof Callable && task.getClass().getName().equals("java.util.concurrent.Executors$RunnableAdapter")) {
            task = ObjectUtils.chooseNotNull(ReflectionUtil.getField(task.getClass(), task, Runnable.class, "task"), task);
        }
        return extra == null ? task : task.getClass() + extra;
    }

    @Override
    public void shutdown() {
        if (this.myShutdown) {
            throw new IllegalStateException("Already shut down: " + this);
        }
        this.myShutdown = true;
    }

    @Override
    @NotNull
    public List<Runnable> shutdownNow() {
        this.shutdown();
        List<Runnable> list = this.clearAndCancelAll();
        if (list == null) {
            BoundedTaskExecutor.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Override
    public boolean isShutdown() {
        return this.myShutdown;
    }

    @Override
    public boolean isTerminated() {
        return this.myShutdown;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean awaitTermination(long timeout, @NotNull TimeUnit timeUnit) throws InterruptedException {
        if (timeUnit == null) {
            BoundedTaskExecutor.$$$reportNull$$$0(6);
        }
        if (!this.isShutdown()) {
            throw new IllegalStateException("you must call shutdown() or shutdownNow() first");
        }
        try {
            void unit;
            this.waitAllTasksExecuted(timeout, (TimeUnit)unit);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getCause());
        }
        catch (TimeoutException e) {
            return false;
        }
        return true;
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value2) {
        return this.newTaskFor(Executors.callable(runnable, value2));
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        if (LoadingState.APP_STARTED.isOccurred() && Registry.is("ide.cancellation.propagate")) {
            return JobFutureTask.jobRunnableFuture(callable);
        }
        return super.newTaskFor(callable);
    }

    @Override
    public void execute(@NotNull Runnable command) {
        if (command == null) {
            BoundedTaskExecutor.$$$reportNull$$$0(7);
        }
        if (LoadingState.APP_STARTED.isOccurred() && Registry.is("ide.cancellation.propagate")) {
            this.executeRaw(JobRunnable.jobRunnable(command));
        } else {
            this.executeRaw(command);
        }
    }

    private void executeRaw(@NotNull Runnable task) {
        if (task == null) {
            BoundedTaskExecutor.$$$reportNull$$$0(8);
        }
        if (this.isShutdown() && !(task instanceof LastTask)) {
            throw new RejectedExecutionException("Already shutdown");
        }
        long status2 = this.incrementCounterAndTimestamp();
        int inProgress = (int)status2;
        assert (inProgress > 0) : inProgress;
        if (inProgress <= this.myMaxThreads) {
            this.wrapAndExecute(task, status2);
            return;
        }
        if (!this.myTaskQueue.offer(task)) {
            throw new RejectedExecutionException();
        }
        Runnable next = this.pollOrGiveUp(status2);
        if (next != null) {
            this.wrapAndExecute(next, status2);
        }
    }

    private long incrementCounterAndTimestamp() {
        return this.myStatus.updateAndGet(status2 -> status2 + 1L + 0x100000000L & Long.MAX_VALUE);
    }

    private Runnable pollOrGiveUp(long status2) {
        while (true) {
            Runnable next;
            int inProgress = (int)status2;
            assert (inProgress > 0) : inProgress;
            if (inProgress <= this.myMaxThreads && (next = (Runnable)this.myTaskQueue.poll()) != null) {
                return next;
            }
            if (this.myStatus.compareAndSet(status2, status2 - 1L)) break;
            status2 = this.myStatus.get();
        }
        return null;
    }

    private void wrapAndExecute(@NotNull Runnable firstTask, final long status2) {
        if (firstTask == null) {
            BoundedTaskExecutor.$$$reportNull$$$0(9);
        }
        try {
            final AtomicReference<Runnable> currentTask = new AtomicReference<Runnable>(firstTask);
            this.myBackendExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    if (BoundedTaskExecutor.this.myChangeThreadName) {
                        String name2 = BoundedTaskExecutor.this.myName;
                        if (StartUpMeasurer.isEnabled()) {
                            name2 = name2 + "[" + Thread.currentThread().getName() + "]";
                        }
                        ConcurrencyUtil.runUnderThreadName(name2, this::execute);
                    } else {
                        this.execute();
                    }
                }

                private void execute() {
                    Runnable task = (Runnable)currentTask.get();
                    do {
                        currentTask.set(task);
                        BoundedTaskExecutor.doRun(task);
                    } while ((task = BoundedTaskExecutor.this.pollOrGiveUp(status2)) != null);
                }

                public String toString() {
                    return String.valueOf(BoundedTaskExecutor.info((Runnable)currentTask.get()));
                }
            });
        }
        catch (Error | RuntimeException e) {
            this.myStatus.decrementAndGet();
            throw e;
        }
    }

    private static void doRun(@Async.Execute Runnable task) {
        block4: {
            try {
                task.run();
            }
            catch (Throwable e) {
                if (e instanceof ControlFlowException) break block4;
                try {
                    Logger.getInstance(BoundedTaskExecutor.class).error(e);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void waitAllTasksExecuted(final long timeout, @NotNull TimeUnit timeUnit) throws ExecutionException, InterruptedException, TimeoutException {
        void unit;
        if (timeUnit == null) {
            BoundedTaskExecutor.$$$reportNull$$$0(10);
        }
        final CountDownLatch started = new CountDownLatch(this.myMaxThreads);
        final CountDownLatch readyToFinish = new CountDownLatch(1);
        Runnable runnable = new Runnable((TimeUnit)unit){
            final /* synthetic */ TimeUnit val$unit;
            {
                this.val$unit = timeUnit;
            }

            @Override
            public void run() {
                try {
                    started.countDown();
                    readyToFinish.await();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }

            public String toString() {
                return "LastTask to waitAllTasksExecuted for " + timeout + " " + (Object)((Object)this.val$unit) + " (" + System.identityHashCode(this) + ")";
            }
        };
        List<Future> futures = ContainerUtil.map(Collections.nCopies(this.myMaxThreads, null), __ -> {
            LastTask wait = new LastTask(runnable);
            this.execute(wait);
            return wait;
        });
        try {
            if (!started.await(timeout, (TimeUnit)unit)) {
                throw new TimeoutException("Interrupted by timeout. " + this);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            readyToFinish.countDown();
        }
        for (Future future : futures) {
            future.get(timeout, (TimeUnit)unit);
        }
    }

    public boolean isEmpty() {
        return (int)this.myStatus.get() == 0;
    }

    @NotNull
    public List<Runnable> clearAndCancelAll() {
        ArrayList<Runnable> queued = new ArrayList<Runnable>();
        this.myTaskQueue.drainTo(queued);
        for (Runnable task : queued) {
            if (!(task instanceof FutureTask)) continue;
            ((FutureTask)task).cancel(false);
        }
        ArrayList<Runnable> arrayList = queued;
        if (arrayList == null) {
            BoundedTaskExecutor.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    public String toString() {
        return "BoundedExecutor(" + this.myMaxThreads + ")" + (this.isShutdown() ? " SHUTDOWN " : "") + "; inProgress: " + (int)this.myStatus.get() + (this.myTaskQueue.isEmpty() ? "" : "; queue: " + this.myTaskQueue.size() + "[" + ContainerUtil.map(this.myTaskQueue, BoundedTaskExecutor::info) + "]") + "; name: " + this.myName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 11: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "backendExecutor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queue";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/concurrency/BoundedTaskExecutor";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unit";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstTask";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/concurrency/BoundedTaskExecutor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "shutdownNow";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "clearAndCancelAll";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 11: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "awaitTermination";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "executeRaw";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "wrapAndExecute";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "waitAllTasksExecuted";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 5: 
            case 11: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class LastTask
    extends FutureTask<Void> {
        LastTask(@NotNull Runnable runnable) {
            if (runnable == null) {
                LastTask.$$$reportNull$$$0(0);
            }
            super(runnable, null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/util/concurrency/BoundedTaskExecutor$LastTask", "<init>"));
        }
    }
}

