/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.transformers.irToJs;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsPolyfills;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u0005J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0007J\u001c\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u00052\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u0013J\u0018\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u000b*\b\u0012\u0004\u0012\u00020\u00070\u0015H\u0002J\u0018\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u000b*\b\u0012\u0004\u0012\u00020\u00070\u0016H\u0002RJ\u0010\u0003\u001a>\u0012\u0004\u0012\u00020\u0005\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\b0\u0004j\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/JsPolyfills;", "", "()V", "polyfillsPerFile", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "Ljava/util/HashSet;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "Lkotlin/collections/HashSet;", "Lkotlin/collections/HashMap;", "getAllPolyfillsFor", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "file", "registerDeclarationNativeImplementation", "", "declaration", "saveOnlyIntersectionOfNextDeclarationsFor", "declarations", "", "asImplementationList", "", "Lkotlin/sequences/Sequence;", "backend.js"})
public final class JsPolyfills {
    @NotNull
    private final HashMap<IrFile, HashSet<IrDeclaration>> polyfillsPerFile = new HashMap();

    public final void registerDeclarationNativeImplementation(@NotNull IrFile file2, @NotNull IrDeclaration declaration) {
        Intrinsics.checkNotNullParameter(file2, "file");
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        if (!AnnotationUtilsKt.hasJsPolyfill(declaration)) {
            return;
        }
        HashSet<IrDeclaration> hashSet = this.polyfillsPerFile.get(file2);
        HashSet<IrDeclaration> declarations2 = hashSet == null ? new HashSet<IrDeclaration>() : hashSet;
        declarations2.add(declaration);
        ((Map)this.polyfillsPerFile).put(file2, declarations2);
    }

    public final void saveOnlyIntersectionOfNextDeclarationsFor(@NotNull IrFile file2, @NotNull Set<? extends IrDeclaration> declarations2) {
        Intrinsics.checkNotNullParameter(file2, "file");
        Intrinsics.checkNotNullParameter(declarations2, "declarations");
        HashSet<IrDeclaration> hashSet = this.polyfillsPerFile.get(file2);
        if (hashSet == null) {
            return;
        }
        HashSet<IrDeclaration> polyfills = hashSet;
        ((Map)this.polyfillsPerFile).put(file2, CollectionsKt.toHashSet(CollectionsKt.intersect((Iterable)polyfills, (Iterable)declarations2)));
    }

    @NotNull
    public final List<JsStatement> getAllPolyfillsFor(@NotNull IrFile file2) {
        Intrinsics.checkNotNullParameter(file2, "file");
        Set set = this.polyfillsPerFile.get(file2);
        if (set == null) {
            set = SetsKt.emptySet();
        }
        return this.asImplementationList(set);
    }

    private final List<JsStatement> asImplementationList(Iterable<? extends IrDeclaration> $this$asImplementationList) {
        return this.asImplementationList(CollectionsKt.asSequence($this$asImplementationList));
    }

    private final List<JsStatement> asImplementationList(Sequence<? extends IrDeclaration> $this$asImplementationList) {
        return SequencesKt.toList(SequencesKt.flatMapIterable(SequencesKt.distinctBy(SequencesKt.map($this$asImplementationList, asImplementationList.1.INSTANCE), asImplementationList.2.INSTANCE), asImplementationList.3.INSTANCE));
    }
}

