/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.boxing;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.optimization.boxing.BoxedBasicValue;
import org.jetbrains.kotlin.codegen.optimization.boxing.BoxingInterpreterKt;
import org.jetbrains.kotlin.codegen.optimization.boxing.CleanBoxedValue;
import org.jetbrains.kotlin.codegen.optimization.boxing.ProgressionIteratorBasicValue;
import org.jetbrains.kotlin.codegen.optimization.boxing.TaintedBoxedValue;
import org.jetbrains.kotlin.codegen.optimization.common.OptimizationBasicInterpreter;
import org.jetbrains.kotlin.codegen.optimization.common.StrictBasicValue;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.TypeInsnNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;
import org.jetbrains.org.objectweb.asm.tree.analysis.Value;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010 \n\u0002\b\r\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0004J\"\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u000eH\u0014J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\rH\u0002J\u0010\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0018\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u0012H\u0016J \u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u0019H\u0002J \u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\n2\u0006\u0010!\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u0019H\u0002J\u0016\u0010\"\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u0012J\u0016\u0010#\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u0012J \u0010$\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0014\u001a\u00020\r2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00120&H\u0016J \u0010'\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010(\u001a\u00020\n2\u0006\u0010)\u001a\u00020\nH\u0014J \u0010*\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010(\u001a\u00020\n2\u0006\u0010)\u001a\u00020\nH\u0014J\u0010\u0010+\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\nH\u0014J\u0018\u0010,\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\nH\u0014J\u0010\u0010-\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\nH\u0014J\u0010\u0010.\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\nH\u0014J \u0010/\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\n2\u0006\u00100\u001a\u00020\u0016H\u0014J\u001a\u00101\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0012\u00102\u001a\u00020\u0010*\b\u0012\u0004\u0012\u00020\u00120&H\u0002R*\u0010\u0007\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\f\u001a\u001e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\bj\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/boxing/BoxingInterpreter;", "Lorg/jetbrains/kotlin/codegen/optimization/common/OptimizationBasicInterpreter;", "insnList", "Lorg/jetbrains/org/objectweb/asm/tree/InsnList;", "generationState", "Lorg/jetbrains/kotlin/codegen/state/GenerationState;", "(Lorg/jetbrains/org/objectweb/asm/tree/InsnList;Lorg/jetbrains/kotlin/codegen/state/GenerationState;)V", "boxingPlaces", "Ljava/util/HashMap;", "", "Lorg/jetbrains/kotlin/codegen/optimization/boxing/BoxedBasicValue;", "Lkotlin/collections/HashMap;", "progressionIterators", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "Lorg/jetbrains/kotlin/codegen/optimization/boxing/ProgressionIteratorBasicValue;", "checkUsedValue", "", "value", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/BasicValue;", "createNewBoxing", "insn", "type", "Lorg/jetbrains/org/objectweb/asm/Type;", "progressionIterator", "isCastToProgression", "", "isExactValue", "merge", "v", "w", "isLocalVariable", "mergeBoxedHazardous", "boxed", "other", "mergeLocalVariableValues", "mergeStackValues", "naryOperation", "values", "", "onAreEqual", "value1", "value2", "onCompareTo", "onMergeFail", "onMergeSuccess", "onMethodCallWithBoxedValue", "onNewBoxedValue", "onUnboxing", "resultType", "unaryOperation", "markBoxedArgumentValues", "backend"})
@SourceDebugExtension(value={"SMAP\nBoxingInterpreter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BoxingInterpreter.kt\norg/jetbrains/kotlin/codegen/optimization/boxing/BoxingInterpreter\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,405:1\n372#2,7:406\n372#2,7:415\n1855#3,2:413\n1#4:422\n*S KotlinDebug\n*F\n+ 1 BoxingInterpreter.kt\norg/jetbrains/kotlin/codegen/optimization/boxing/BoxingInterpreter\n*L\n53#1:406,7\n98#1:415,7\n66#1:413,2\n*E\n"})
public class BoxingInterpreter
extends OptimizationBasicInterpreter {
    @NotNull
    private final InsnList insnList;
    @NotNull
    private final GenerationState generationState;
    @NotNull
    private final HashMap<Integer, BoxedBasicValue> boxingPlaces;
    @NotNull
    private final HashMap<AbstractInsnNode, ProgressionIteratorBasicValue> progressionIterators;

    public BoxingInterpreter(@NotNull InsnList insnList, @NotNull GenerationState generationState) {
        Intrinsics.checkNotNullParameter(insnList, "insnList");
        Intrinsics.checkNotNullParameter(generationState, "generationState");
        this.insnList = insnList;
        this.generationState = generationState;
        this.boxingPlaces = new HashMap();
        this.progressionIterators = new HashMap();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected BasicValue createNewBoxing(@NotNull AbstractInsnNode insn, @NotNull Type type2, @Nullable ProgressionIteratorBasicValue progressionIterator) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter(insn, "insn");
        Intrinsics.checkNotNullParameter(type2, "type");
        Map map = this.boxingPlaces;
        Integer key$iv = this.insnList.indexOf(insn);
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            CleanBoxedValue boxedBasicValue = new CleanBoxedValue(type2, insn, progressionIterator, this.generationState);
            this.onNewBoxedValue(boxedBasicValue);
            BoxedBasicValue answer$iv = boxedBasicValue;
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (BasicValue)object;
    }

    protected final void checkUsedValue(@NotNull BasicValue value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        if (value2 instanceof TaintedBoxedValue) {
            this.onMergeFail((BoxedBasicValue)value2);
        }
    }

    @Override
    @Nullable
    public BasicValue naryOperation(@NotNull AbstractInsnNode insn, @NotNull List<? extends BasicValue> values2) {
        Value value2;
        Intrinsics.checkNotNullParameter(insn, "insn");
        Intrinsics.checkNotNullParameter(values2, "values");
        Iterable $this$forEach$iv = values2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BasicValue it = (BasicValue)element$iv;
            boolean bl = false;
            this.checkUsedValue(it);
        }
        Value value3 = super.naryOperation(insn, (List)values2);
        BasicValue basicValue = CollectionsKt.firstOrNull(values2);
        if (basicValue == null) {
            return value3;
        }
        BasicValue firstArg = basicValue;
        if (BoxingInterpreterKt.isBoxing(insn, this.generationState)) {
            this.markBoxedArgumentValues(values2);
            Type type2 = ((BasicValue)value3).getType();
            Intrinsics.checkNotNullExpressionValue(type2, "getType(...)");
            value2 = this.createNewBoxing(insn, type2, null);
        } else if (BoxingInterpreterKt.isUnboxing(insn, this.generationState) && firstArg instanceof BoxedBasicValue) {
            BoxedBasicValue boxedBasicValue = (BoxedBasicValue)firstArg;
            Type type3 = ((BasicValue)value3).getType();
            Intrinsics.checkNotNullExpressionValue(type3, "getType(...)");
            this.onUnboxing(insn, boxedBasicValue, type3);
            value2 = value3;
        } else if (BoxingInterpreterKt.isIteratorMethodCall(insn)) {
            this.markBoxedArgumentValues(values2);
            Type firstArgType = firstArg.getType();
            Intrinsics.checkNotNull(firstArgType);
            if (BoxingInterpreterKt.access$isProgressionClass(firstArgType)) {
                Object object;
                Map $this$getOrPut$iv = this.progressionIterators;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(insn);
                if (value$iv == null) {
                    boolean bl = false;
                    ProgressionIteratorBasicValue progressionIteratorBasicValue = ProgressionIteratorBasicValue.Companion.byProgressionClassType(insn, firstArgType);
                    Intrinsics.checkNotNull(progressionIteratorBasicValue);
                    ProgressionIteratorBasicValue answer$iv = progressionIteratorBasicValue;
                    $this$getOrPut$iv.put(insn, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                value2 = (BasicValue)object;
            } else {
                ProgressionIteratorBasicValue progressionIteratorBasicValue = this.progressionIterators.get(insn);
                if (progressionIteratorBasicValue != null) {
                    progressionIteratorBasicValue.taint();
                }
                value2 = value3;
            }
        } else if (BoxingInterpreterKt.isNextMethodCallOfProgressionIterator(insn, values2)) {
            ProgressionIteratorBasicValue progressionIteratorBasicValue = firstArg instanceof ProgressionIteratorBasicValue ? (ProgressionIteratorBasicValue)firstArg : null;
            if (progressionIteratorBasicValue == null) {
                throw new AssertionError((Object)"firstArg should be progression iterator");
            }
            ProgressionIteratorBasicValue progressionIterator = progressionIteratorBasicValue;
            value2 = this.createNewBoxing(insn, progressionIterator.getBoxedElementType(), progressionIterator);
        } else if (BoxingInterpreterKt.isAreEqualIntrinsicForSameTypedBoxedValues(insn, values2) && BoxingInterpreterKt.canValuesBeUnboxedForAreEqual(values2, this.generationState)) {
            BasicValue basicValue2 = values2.get(0);
            Intrinsics.checkNotNull(basicValue2, "null cannot be cast to non-null type org.jetbrains.kotlin.codegen.optimization.boxing.BoxedBasicValue");
            BoxedBasicValue boxedBasicValue = (BoxedBasicValue)basicValue2;
            BasicValue basicValue3 = values2.get(1);
            Intrinsics.checkNotNull(basicValue3, "null cannot be cast to non-null type org.jetbrains.kotlin.codegen.optimization.boxing.BoxedBasicValue");
            this.onAreEqual(insn, boxedBasicValue, (BoxedBasicValue)basicValue3);
            value2 = value3;
        } else if (BoxingInterpreterKt.isJavaLangComparableCompareToForSameTypedBoxedValues(insn, values2)) {
            BasicValue basicValue4 = values2.get(0);
            Intrinsics.checkNotNull(basicValue4, "null cannot be cast to non-null type org.jetbrains.kotlin.codegen.optimization.boxing.BoxedBasicValue");
            BoxedBasicValue boxedBasicValue = (BoxedBasicValue)basicValue4;
            BasicValue basicValue5 = values2.get(1);
            Intrinsics.checkNotNull(basicValue5, "null cannot be cast to non-null type org.jetbrains.kotlin.codegen.optimization.boxing.BoxedBasicValue");
            this.onCompareTo(insn, boxedBasicValue, (BoxedBasicValue)basicValue5);
            value2 = value3;
        } else {
            this.markBoxedArgumentValues(values2);
            value2 = value3;
        }
        return value2;
    }

    private final void markBoxedArgumentValues(List<? extends BasicValue> $this$markBoxedArgumentValues) {
        for (BasicValue basicValue : $this$markBoxedArgumentValues) {
            if (!(basicValue instanceof BoxedBasicValue)) continue;
            this.onMethodCallWithBoxedValue((BoxedBasicValue)basicValue);
        }
    }

    @Override
    @Nullable
    public BasicValue unaryOperation(@NotNull AbstractInsnNode insn, @NotNull BasicValue value2) {
        Intrinsics.checkNotNullParameter(insn, "insn");
        Intrinsics.checkNotNullParameter(value2, "value");
        this.checkUsedValue(value2);
        return insn.getOpcode() == 192 && this.isExactValue(value2) && !this.isCastToProgression(insn) ? value2 : super.unaryOperation(insn, value2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isExactValue(@NotNull BasicValue value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        if (value2 instanceof ProgressionIteratorBasicValue) return true;
        if (value2 instanceof CleanBoxedValue) return true;
        if (value2.getType() == null) return false;
        Type type2 = value2.getType();
        Intrinsics.checkNotNullExpressionValue(type2, "getType(...)");
        if (!BoxingInterpreterKt.access$isProgressionClass(type2)) return false;
        return true;
    }

    private final boolean isCastToProgression(AbstractInsnNode insn) {
        boolean bl;
        boolean bl2 = bl = insn.getOpcode() == 192;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Expected opcode Opcodes.CHECKCAST, but " + insn.getOpcode() + " found";
            throw new AssertionError((Object)string2);
        }
        Intrinsics.checkNotNull(insn, "null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.TypeInsnNode");
        String desc = ((TypeInsnNode)insn).desc;
        String[] stringArray = new String[]{"kotlin/ranges/CharProgression", "kotlin/ranges/IntProgression", "kotlin/ranges/LongProgression"};
        return SetsKt.setOf(stringArray).contains(desc);
    }

    @Override
    @NotNull
    public BasicValue merge(@NotNull BasicValue v, @NotNull BasicValue w) {
        Intrinsics.checkNotNullParameter(v, "v");
        Intrinsics.checkNotNullParameter(w, "w");
        return this.mergeStackValues(v, w);
    }

    @NotNull
    public final BasicValue mergeLocalVariableValues(@NotNull BasicValue v, @NotNull BasicValue w) {
        Intrinsics.checkNotNullParameter(v, "v");
        Intrinsics.checkNotNullParameter(w, "w");
        return this.merge(v, w, true);
    }

    @NotNull
    public final BasicValue mergeStackValues(@NotNull BasicValue v, @NotNull BasicValue w) {
        Intrinsics.checkNotNullParameter(v, "v");
        Intrinsics.checkNotNullParameter(w, "w");
        return this.merge(v, w, false);
    }

    private final BasicValue merge(BasicValue v, BasicValue w, boolean isLocalVariable) {
        BasicValue basicValue;
        if (Intrinsics.areEqual(v, StrictBasicValue.UNINITIALIZED_VALUE) || Intrinsics.areEqual(w, StrictBasicValue.UNINITIALIZED_VALUE)) {
            basicValue = StrictBasicValue.UNINITIALIZED_VALUE;
        } else if (v instanceof BoxedBasicValue && w instanceof BoxedBasicValue) {
            this.onMergeSuccess((BoxedBasicValue)v, (BoxedBasicValue)w);
            basicValue = v instanceof TaintedBoxedValue ? v : (w instanceof TaintedBoxedValue ? w : (!Intrinsics.areEqual(((BoxedBasicValue)v).getType(), ((BoxedBasicValue)w).getType()) ? this.mergeBoxedHazardous((BoxedBasicValue)v, w, isLocalVariable) : v));
        } else if (v instanceof BoxedBasicValue) {
            basicValue = this.mergeBoxedHazardous((BoxedBasicValue)v, w, isLocalVariable);
        } else if (w instanceof BoxedBasicValue) {
            basicValue = this.mergeBoxedHazardous((BoxedBasicValue)w, v, isLocalVariable);
        } else {
            BasicValue basicValue2 = super.merge(v, w);
            basicValue = basicValue2;
            Intrinsics.checkNotNullExpressionValue(basicValue2, "merge(...)");
        }
        return basicValue;
    }

    private final BasicValue mergeBoxedHazardous(BoxedBasicValue boxed, BasicValue other, boolean isLocalVariable) {
        if (isLocalVariable) {
            return boxed.taint();
        }
        this.onMergeFail(boxed);
        if (other instanceof BoxedBasicValue) {
            this.onMergeFail((BoxedBasicValue)other);
        }
        return boxed;
    }

    protected void onNewBoxedValue(@NotNull BoxedBasicValue value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
    }

    protected void onUnboxing(@NotNull AbstractInsnNode insn, @NotNull BoxedBasicValue value2, @NotNull Type resultType) {
        Intrinsics.checkNotNullParameter(insn, "insn");
        Intrinsics.checkNotNullParameter(value2, "value");
        Intrinsics.checkNotNullParameter(resultType, "resultType");
    }

    protected void onAreEqual(@NotNull AbstractInsnNode insn, @NotNull BoxedBasicValue value1, @NotNull BoxedBasicValue value2) {
        Intrinsics.checkNotNullParameter(insn, "insn");
        Intrinsics.checkNotNullParameter(value1, "value1");
        Intrinsics.checkNotNullParameter(value2, "value2");
    }

    protected void onCompareTo(@NotNull AbstractInsnNode insn, @NotNull BoxedBasicValue value1, @NotNull BoxedBasicValue value2) {
        Intrinsics.checkNotNullParameter(insn, "insn");
        Intrinsics.checkNotNullParameter(value1, "value1");
        Intrinsics.checkNotNullParameter(value2, "value2");
    }

    protected void onMethodCallWithBoxedValue(@NotNull BoxedBasicValue value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
    }

    protected void onMergeFail(@NotNull BoxedBasicValue value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
    }

    protected void onMergeSuccess(@NotNull BoxedBasicValue v, @NotNull BoxedBasicValue w) {
        Intrinsics.checkNotNullParameter(v, "v");
        Intrinsics.checkNotNullParameter(w, "w");
    }
}

