/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.light;

import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.openapi.project.DumbService;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiRecordComponent;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.ElementPresentationUtil;
import com.intellij.psi.impl.light.LightField;
import com.intellij.psi.impl.light.LightRecordMember;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.ui.IconManager;
import com.intellij.ui.icons.RowIcon;
import com.intellij.util.BitUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import com.intellij.util.VisibilityIcons;
import java.util.Arrays;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightRecordField
extends LightField
implements LightRecordMember {
    @NotNull
    private final PsiRecordComponent myRecordComponent;

    public LightRecordField(@NotNull PsiManager manager, @NotNull PsiField field2, @NotNull PsiClass containingClass, @NotNull PsiRecordComponent component) {
        if (manager == null) {
            LightRecordField.$$$reportNull$$$0(0);
        }
        if (field2 == null) {
            LightRecordField.$$$reportNull$$$0(1);
        }
        if (containingClass == null) {
            LightRecordField.$$$reportNull$$$0(2);
        }
        if (component == null) {
            LightRecordField.$$$reportNull$$$0(3);
        }
        super(manager, field2, containingClass);
        this.myRecordComponent = component;
    }

    @Override
    @NotNull
    public PsiRecordComponent getRecordComponent() {
        PsiRecordComponent psiRecordComponent = this.myRecordComponent;
        if (psiRecordComponent == null) {
            LightRecordField.$$$reportNull$$$0(4);
        }
        return psiRecordComponent;
    }

    @Override
    public int getTextOffset() {
        return this.myRecordComponent.getTextOffset();
    }

    @Override
    @NotNull
    public PsiElement getNavigationElement() {
        PsiElement psiElement = this.myRecordComponent.getNavigationElement();
        if (psiElement == null) {
            LightRecordField.$$$reportNull$$$0(5);
        }
        return psiElement;
    }

    @Override
    public boolean isWritable() {
        return true;
    }

    @Override
    public PsiFile getContainingFile() {
        PsiClass containingClass = this.getContainingClass();
        if (containingClass == null) {
            return null;
        }
        return containingClass.getContainingFile();
    }

    @Override
    @NotNull
    public PsiType getType() {
        if (DumbService.isDumb(this.myRecordComponent.getProject())) {
            PsiType psiType2 = this.myRecordComponent.getType();
            if (psiType2 == null) {
                LightRecordField.$$$reportNull$$$0(6);
            }
            return psiType2;
        }
        PsiType psiType3 = (PsiType)CachedValuesManager.getCachedValue(this, () -> {
            PsiType type2 = this.myRecordComponent.getType().annotate(() -> (PsiAnnotation[])Arrays.stream(this.myRecordComponent.getAnnotations()).filter(LightRecordField::hasApplicableAnnotationTarget).toArray(PsiAnnotation[]::new));
            return CachedValueProvider.Result.create(type2, this);
        });
        if (psiType3 == null) {
            LightRecordField.$$$reportNull$$$0(7);
        }
        return psiType3;
    }

    @Override
    public PsiAnnotation @NotNull [] getAnnotations() {
        PsiAnnotation[] psiAnnotationArray = this.getType().getAnnotations();
        if (psiAnnotationArray == null) {
            LightRecordField.$$$reportNull$$$0(8);
        }
        return psiAnnotationArray;
    }

    @Override
    public boolean hasAnnotation(@NotNull String fqn) {
        if (fqn == null) {
            LightRecordField.$$$reportNull$$$0(9);
        }
        PsiType type2 = this.getType();
        return type2.hasAnnotation(fqn);
    }

    @Override
    @Nullable
    public PsiAnnotation getAnnotation(@NotNull String fqn) {
        if (fqn == null) {
            LightRecordField.$$$reportNull$$$0(10);
        }
        return this.getType().findAnnotation(fqn);
    }

    @Override
    public Icon getElementIcon(int flags) {
        RowIcon baseIcon = IconManager.getInstance().createLayeredIcon(this, PlatformIcons.FIELD_ICON, ElementPresentationUtil.getFlags(this, false));
        if (BitUtil.isSet(flags, 1)) {
            VisibilityIcons.setVisibilityIcon(1, baseIcon);
        }
        return baseIcon;
    }

    @Override
    public PsiElement getContext() {
        return this.getContainingClass();
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        PsiClass aClass = Objects.requireNonNull(this.getContainingClass());
        for (PsiClass containingClass = aClass.getContainingClass(); containingClass != null; containingClass = containingClass.getContainingClass()) {
            aClass = containingClass;
        }
        return new LocalSearchScope(aClass);
    }

    private static boolean hasApplicableAnnotationTarget(PsiAnnotation annotation2) {
        return AnnotationTargetUtil.findAnnotationTarget(annotation2, PsiAnnotation.TargetType.TYPE_USE, PsiAnnotation.TargetType.FIELD) != null;
    }

    @Override
    public void normalizeDeclaration() throws IncorrectOperationException {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o instanceof LightRecordField && this.myRecordComponent.equals(((LightRecordField)o).myRecordComponent);
    }

    public int hashCode() {
        return Objects.hash(this.myRecordComponent);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/light/LightRecordField";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/light/LightRecordField";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRecordComponent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationElement";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "hasAnnotation";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotation";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

