/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.utils.ResolvedDependencies;
import org.jetbrains.kotlin.utils.ResolvedDependenciesSupport;
import org.jetbrains.kotlin.utils.ResolvedDependency;
import org.jetbrains.kotlin.utils.ResolvedDependencyArtifactPath;
import org.jetbrains.kotlin.utils.ResolvedDependencyId;
import org.jetbrains.kotlin.utils.ResolvedDependencyVersion;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JF\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n26\u0010\u000b\u001a2\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0010\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00120\fJ\u000e\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/utils/ResolvedDependenciesSupport;", "", "()V", "DEPENDENCY_MODULE_REGEX", "Lkotlin/text/Regex;", "REQUESTED_VERSION_BY_INCOMING_DEPENDENCY_REGEX", "SOURCE_CODE_MODULE_REGEX", "deserialize", "Lorg/jetbrains/kotlin/utils/ResolvedDependencies;", "source", "", "onMalformedLine", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "lineNo", "line", "", "serialize", "dependencies", "util"})
@SourceDebugExtension(value={"SMAP\nResolvedDependencies.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResolvedDependencies.kt\norg/jetbrains/kotlin/utils/ResolvedDependenciesSupport\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Strings.kt\nkotlin/text/StringsKt__StringsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,207:1\n1864#2,3:208\n1855#2,2:211\n1864#2,2:213\n1179#2,2:221\n1253#2,4:223\n1866#2:227\n1855#2:228\n1856#2:231\n124#3:215\n113#3,5:216\n215#4,2:229\n*S KotlinDebug\n*F\n+ 1 ResolvedDependencies.kt\norg/jetbrains/kotlin/utils/ResolvedDependenciesSupport\n*L\n90#1:208,3\n98#1:211,2\n124#1:213,2\n155#1:221,2\n155#1:223,4\n124#1:227\n177#1:228\n177#1:231\n134#1:215\n134#1:216,5\n178#1:229,2\n*E\n"})
public final class ResolvedDependenciesSupport {
    @NotNull
    public static final ResolvedDependenciesSupport INSTANCE = new ResolvedDependenciesSupport();
    @NotNull
    private static final Regex SOURCE_CODE_MODULE_REGEX = new Regex("^0 ([^\\[]+)$");
    @NotNull
    private static final Regex DEPENDENCY_MODULE_REGEX = new Regex("^(\\d+) ([^\\[]+)\\[([^]]+)](.*)?$");
    @NotNull
    private static final Regex REQUESTED_VERSION_BY_INCOMING_DEPENDENCY_REGEX = new Regex("^#(\\d+)\\[(.*)]$");

    private ResolvedDependenciesSupport() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String serialize(@NotNull ResolvedDependencies dependencies2) {
        Intrinsics.checkNotNullParameter(dependencies2, "dependencies");
        Object object = new Pair[]{TuplesKt.to(dependencies2.getSourceCodeModuleId(), 0)};
        Object $this$serialize_u24lambda_u241 = object = MapsKt.mutableMapOf(object);
        boolean bl = false;
        Iterable $this$forEachIndexed$iv = dependencies2.getModules();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void module2;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ResolvedDependency resolvedDependency = (ResolvedDependency)item$iv;
            int index2 = n;
            boolean bl2 = false;
            $this$serialize_u24lambda_u241.put(module2.getId(), index2 + 1);
        }
        Object moduleIdToIndex = object;
        Object $this$serialize_u24lambda_u243 = object = new StringBuilder();
        boolean bl3 = false;
        ((StringBuilder)$this$serialize_u24lambda_u243).append("0 ");
        CollectionsKt.joinTo$default(dependencies2.getSourceCodeModuleId().getUniqueNames(), (Appendable)$this$serialize_u24lambda_u243, ",", null, null, 0, null, null, 124, null);
        ((StringBuilder)$this$serialize_u24lambda_u243).append('\n');
        Iterable $this$forEach$iv = dependencies2.getModules();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ResolvedDependency module3 = (ResolvedDependency)element$iv;
            boolean bl4 = false;
            int moduleIndex = ((Number)MapsKt.getValue(moduleIdToIndex, module3.getId())).intValue();
            ((StringBuilder)$this$serialize_u24lambda_u243).append(String.valueOf(moduleIndex)).append(' ');
            CollectionsKt.joinTo$default(module3.getId().getUniqueNames(), (Appendable)$this$serialize_u24lambda_u243, ",", null, null, 0, null, null, 124, null);
            ((StringBuilder)$this$serialize_u24lambda_u243).append('[').append(module3.getSelectedVersion()).append(']');
            CollectionsKt.joinTo$default(module3.getRequestedVersionsByIncomingDependencies().entrySet(), (Appendable)$this$serialize_u24lambda_u243, "", null, null, 0, null, new Function1<Map.Entry<ResolvedDependencyId, ResolvedDependencyVersion>, CharSequence>((Map<ResolvedDependencyId, Integer>)moduleIdToIndex){
                final /* synthetic */ Map<ResolvedDependencyId, Integer> $moduleIdToIndex;
                {
                    this.$moduleIdToIndex = $moduleIdToIndex;
                    super(1);
                }

                @NotNull
                public final CharSequence invoke(@NotNull Map.Entry<ResolvedDependencyId, ResolvedDependencyVersion> entry) {
                    Intrinsics.checkNotNullParameter(entry, "<name for destructuring parameter 0>");
                    ResolvedDependencyId incomingDependencyId = entry.getKey();
                    ResolvedDependencyVersion requestedVersion = entry.getValue();
                    int incomingDependencyIndex = ((Number)MapsKt.getValue(this.$moduleIdToIndex, incomingDependencyId)).intValue();
                    return " #" + incomingDependencyIndex + '[' + requestedVersion + ']';
                }
            }, 60, null);
            ((StringBuilder)$this$serialize_u24lambda_u243).append('\n');
            CollectionsKt.joinTo$default(module3.getArtifactPaths(), (Appendable)$this$serialize_u24lambda_u243, "", null, null, 0, null, serialize.1.1.2.INSTANCE, 60, null);
        }
        String string2 = ((StringBuilder)object).toString();
        Intrinsics.checkNotNullExpressionValue(string2, "StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ResolvedDependencies deserialize(@NotNull String source, @NotNull Function2<? super Integer, ? super String, Unit> onMalformedLine) {
        Intrinsics.checkNotNullParameter(source, "source");
        Intrinsics.checkNotNullParameter(onMalformedLine, "onMalformedLine");
        Map moduleIndexToId = new LinkedHashMap();
        Map requestedVersionsByIncomingDependenciesIndices = new LinkedHashMap();
        ResolvedDependencyId sourceCodeModuleId = null;
        List modules2 = new ArrayList();
        Iterable $this$forEachIndexed$iv = StringsKt.lines(source);
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            MatchResult result2;
            void line;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string2 = (String)item$iv;
            int lineNo = n;
            boolean bl = false;
            if (StringsKt.isBlank((CharSequence)line)) continue;
            if (CharsKt.isWhitespace(line.charAt(0))) {
                CharSequence charSequence2;
                ResolvedDependency currentModule;
                block16: {
                    currentModule = (ResolvedDependency)CollectionsKt.lastOrNull(modules2);
                    void $this$trimStart$iv = line;
                    boolean $i$f$trimStart = false;
                    CharSequence $this$trimStart$iv$iv = (CharSequence)$this$trimStart$iv;
                    boolean $i$f$trimStart2 = false;
                    int n2 = $this$trimStart$iv$iv.length();
                    for (int index$iv$iv = 0; index$iv$iv < n2; ++index$iv$iv) {
                        char it = $this$trimStart$iv$iv.charAt(index$iv$iv);
                        boolean bl2 = false;
                        if (CharsKt.isWhitespace(it)) continue;
                        charSequence2 = $this$trimStart$iv$iv.subSequence(index$iv$iv, $this$trimStart$iv$iv.length());
                        break block16;
                    }
                    charSequence2 = "";
                }
                String artifactPath = ((Object)charSequence2).toString();
                if (currentModule != null && !StringsKt.isBlank(artifactPath)) {
                    ((Collection)currentModule.getArtifactPaths()).add(new ResolvedDependencyArtifactPath(artifactPath));
                    continue;
                }
                return ResolvedDependenciesSupport.deserialize$lambda$6$malformedLine(onMalformedLine, lineNo, (String)line);
            }
            if (line.charAt(0) == '0') {
                if (SOURCE_CODE_MODULE_REGEX.matchEntire((CharSequence)line) == null) {
                    return ResolvedDependenciesSupport.deserialize$lambda$6$malformedLine(onMalformedLine, lineNo, (String)line);
                }
                char[] artifactPath = new char[]{','};
                sourceCodeModuleId = new ResolvedDependencyId(StringsKt.split$default((CharSequence)result2.getGroupValues().get(1), artifactPath, false, 0, 6, null));
                continue;
            }
            if (sourceCodeModuleId == null) {
                return ResolvedDependenciesSupport.deserialize$lambda$6$malformedLine(onMalformedLine, lineNo, (String)line);
            }
            if (DEPENDENCY_MODULE_REGEX.matchEntire((CharSequence)line) == null) {
                return ResolvedDependenciesSupport.deserialize$lambda$6$malformedLine(onMalformedLine, lineNo, (String)line);
            }
            int moduleIndex = Integer.parseInt(result2.getGroupValues().get(1));
            char[] $i$f$trimStart = new char[]{','};
            ResolvedDependencyId moduleId = new ResolvedDependencyId(StringsKt.split$default((CharSequence)result2.getGroupValues().get(2), $i$f$trimStart, false, 0, 6, null));
            ResolvedDependencyVersion selectedVersion = new ResolvedDependencyVersion(result2.getGroupValues().get(3));
            if (result2.getGroupValues().size() > 4) {
                void $this$associateTo$iv$iv;
                void $this$associate$iv;
                Object $i$f$trimStart2 = new char[]{' '};
                $i$f$trimStart2 = StringsKt.split$default((CharSequence)((Object)StringsKt.trimStart((CharSequence)result2.getGroupValues().get(4))).toString(), $i$f$trimStart2, false, 0, 6, null);
                boolean $i$f$associate = false;
                int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associate$iv, 10)), 16);
                void it = $this$associate$iv;
                Map destination$iv$iv = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateTo = false;
                for (Object element$iv$iv : $this$associateTo$iv$iv) {
                    MatchResult tokenResult;
                    Map map = destination$iv$iv;
                    String token = (String)element$iv$iv;
                    boolean bl3 = false;
                    if (REQUESTED_VERSION_BY_INCOMING_DEPENDENCY_REGEX.matchEntire(token) == null) {
                        return ResolvedDependenciesSupport.deserialize$lambda$6$malformedLine(onMalformedLine, lineNo, (String)line);
                    }
                    int incomingDependencyIndex = Integer.parseInt(tokenResult.getGroupValues().get(1));
                    ResolvedDependencyVersion requestedVersion = new ResolvedDependencyVersion(tokenResult.getGroupValues().get(2));
                    Pair<Integer, ResolvedDependencyVersion> pair = TuplesKt.to(incomingDependencyIndex, requestedVersion);
                    map.put(pair.getFirst(), pair.getSecond());
                }
                Map requestedVersions = destination$iv$iv;
                requestedVersionsByIncomingDependenciesIndices.put(moduleId, requestedVersions);
            }
            Integer $this$associate$iv = moduleIndex;
            moduleIndexToId.put($this$associate$iv, moduleId);
            ((Collection)modules2).add(new ResolvedDependency(moduleId, false, selectedVersion, new LinkedHashMap(), new LinkedHashSet(), 2, null));
        }
        Iterable $this$forEach$iv = modules2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map $this$forEach$iv2;
            ResolvedDependency module2 = (ResolvedDependency)element$iv;
            boolean bl = false;
            if ((Map)requestedVersionsByIncomingDependenciesIndices.get(module2.getId()) == null) continue;
            boolean $i$f$forEach2 = false;
            Iterator iterator2 = $this$forEach$iv2.entrySet().iterator();
            while (iterator2.hasNext()) {
                ResolvedDependencyId resolvedDependencyId;
                Map.Entry element$iv2;
                Map.Entry entry = element$iv2 = iterator2.next();
                boolean bl4 = false;
                int incomingDependencyIndex = ((Number)entry.getKey()).intValue();
                ResolvedDependencyVersion requestedVersion = (ResolvedDependencyVersion)entry.getValue();
                if (incomingDependencyIndex == 0) {
                    ResolvedDependencyId resolvedDependencyId2 = sourceCodeModuleId;
                    resolvedDependencyId = resolvedDependencyId2;
                    Intrinsics.checkNotNull(resolvedDependencyId2);
                } else {
                    resolvedDependencyId = (ResolvedDependencyId)MapsKt.getValue(moduleIndexToId, incomingDependencyIndex);
                }
                ResolvedDependencyId incomingDependencyId = resolvedDependencyId;
                module2.getRequestedVersionsByIncomingDependencies().put(incomingDependencyId, requestedVersion);
            }
        }
        Collection collection = modules2;
        ResolvedDependencyId resolvedDependencyId = sourceCodeModuleId;
        Intrinsics.checkNotNull(resolvedDependencyId);
        return new ResolvedDependencies(collection, resolvedDependencyId);
    }

    private static final ResolvedDependencies deserialize$lambda$6$malformedLine(Function2<? super Integer, ? super String, Unit> $onMalformedLine, int $lineNo, String $line) {
        $onMalformedLine.invoke((Integer)$lineNo, $line);
        return ResolvedDependencies.Companion.getEMPTY();
    }
}

