/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.debugText;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.stubs.StubElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotation;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtConstructorCalleeExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtDynamicType;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunctionType;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtImportList;
import org.jetbrains.kotlin.psi.KtInitializerList;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtNullableType;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtStubbedPsiUtil;
import org.jetbrains.kotlin.psi.KtSuperTypeList;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeArgumentList;
import org.jetbrains.kotlin.psi.KtTypeConstraint;
import org.jetbrains.kotlin.psi.KtTypeConstraintList;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterList;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.debugText.DebugTextBuildingVisitor;
import org.jetbrains.kotlin.psi.debugText.DebugTextUtilKt;
import org.jetbrains.kotlin.resolve.ImportPath;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00ce\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J%\u0010\b\u001a\u0004\u0018\u00010\u00022\u001b\u0010\t\u001a\u0017\u0012\b\u0012\u00060\u000bj\u0002`\f\u0012\u0004\u0012\u00020\u00030\n\u00a2\u0006\u0002\b\rJ1\u0010\u000e\u001a\u0004\u0018\u00010\u00022\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\u0016\u0010\u0011\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00130\u0012\"\u0004\u0018\u00010\u0013\u00a2\u0006\u0002\u0010\u0014J0\u0010\u0015\u001a\u0004\u0018\u00010\u00022\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u0016\u001a\u00020\u00022\b\b\u0002\u0010\u0017\u001a\u00020\u00022\b\b\u0002\u0010\u0018\u001a\u00020\u0002J!\u0010\u0019\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010\u001dJ!\u0010\u001e\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001f\u001a\u00020 2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010!J!\u0010\"\u001a\u0004\u0018\u00010\u00022\u0006\u0010#\u001a\u00020$2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010%J!\u0010&\u001a\u0004\u0018\u00010\u00022\u0006\u0010'\u001a\u00020(2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010)J!\u0010*\u001a\u0004\u0018\u00010\u00022\u0006\u0010+\u001a\u00020,2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010-J!\u0010.\u001a\u0004\u0018\u00010\u00022\u0006\u0010/\u001a\u0002002\b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u00101J!\u00102\u001a\u0004\u0018\u00010\u00022\u0006\u00103\u001a\u0002042\b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u00105J!\u00106\u001a\u0004\u0018\u00010\u00022\u0006\u00107\u001a\u0002082\b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u00109J!\u0010:\u001a\u0004\u0018\u00010\u00022\u0006\u0010;\u001a\u00020<2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010=J!\u0010>\u001a\u0004\u0018\u00010\u00022\u0006\u0010?\u001a\u00020@2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010AJ!\u0010B\u001a\u0004\u0018\u00010\u00022\u0006\u0010C\u001a\u00020D2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010EJ!\u0010F\u001a\u0004\u0018\u00010\u00022\u0006\u0010G\u001a\u00020H2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010IJ!\u0010J\u001a\u0004\u0018\u00010\u00022\u0006\u0010K\u001a\u00020L2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010MJ!\u0010N\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000f\u001a\u00020\u00132\b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010OJ!\u0010P\u001a\u0004\u0018\u00010\u00022\u0006\u0010Q\u001a\u00020R2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010SJ!\u0010T\u001a\u0004\u0018\u00010\u00022\u0006\u0010K\u001a\u00020U2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010VJ!\u0010W\u001a\u0004\u0018\u00010\u00022\u0006\u0010X\u001a\u00020Y2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010ZJ!\u0010[\u001a\u0004\u0018\u00010\u00022\u0006\u0010\\\u001a\u00020]2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010^J!\u0010_\u001a\u0004\u0018\u00010\u00022\u0006\u0010`\u001a\u00020a2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010bJ!\u0010c\u001a\u0004\u0018\u00010\u00022\u0006\u0010d\u001a\u00020e2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010fJ!\u0010g\u001a\u0004\u0018\u00010\u00022\u0006\u0010K\u001a\u00020h2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010iJ!\u0010j\u001a\u0004\u0018\u00010\u00022\u0006\u0010k\u001a\u00020l2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010mJ!\u0010n\u001a\u0004\u0018\u00010\u00022\u0006\u0010o\u001a\u00020p2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010qJ!\u0010r\u001a\u0004\u0018\u00010\u00022\u0006\u00103\u001a\u00020s2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010tJ!\u0010u\u001a\u0004\u0018\u00010\u00022\u0006\u0010K\u001a\u00020v2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010wJ!\u0010x\u001a\u0004\u0018\u00010\u00022\u0006\u0010y\u001a\u00020z2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010{J!\u0010|\u001a\u0004\u0018\u00010\u00022\u0006\u0010}\u001a\u00020~2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010\u007fJ%\u0010\u0080\u0001\u001a\u0004\u0018\u00010\u00022\b\u0010\u0081\u0001\u001a\u00030\u0082\u00012\b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0003\u0010\u0083\u0001J$\u0010\u0084\u0001\u001a\u0004\u0018\u00010\u00022\u0007\u0010K\u001a\u00030\u0085\u00012\b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0003\u0010\u0086\u0001J$\u0010\u0087\u0001\u001a\u0004\u0018\u00010\u00022\u0007\u0010d\u001a\u00030\u0088\u00012\b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0003\u0010\u0089\u0001J$\u0010\u008a\u0001\u001a\u0004\u0018\u00010\u00022\u0007\u0010K\u001a\u00030\u008b\u00012\b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0003\u0010\u008c\u0001J%\u0010\u008d\u0001\u001a\u0004\u0018\u00010\u00022\b\u0010\u008e\u0001\u001a\u00030\u008f\u00012\b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0003\u0010\u0090\u0001J%\u0010\u0091\u0001\u001a\u0004\u0018\u00010\u00022\b\u0010\u0092\u0001\u001a\u00030\u0093\u00012\b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0003\u0010\u0094\u0001J%\u0010\u0095\u0001\u001a\u0004\u0018\u00010\u00022\b\u0010\u0096\u0001\u001a\u00030\u0097\u00012\b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0003\u0010\u0098\u0001R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0099\u0001"}, d2={"Lorg/jetbrains/kotlin/psi/debugText/DebugTextBuildingVisitor;", "Lorg/jetbrains/kotlin/psi/KtVisitor;", "", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "buildText", "body", "Lkotlin/Function1;", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "Lkotlin/ExtensionFunctionType;", "render", "element", "Lorg/jetbrains/kotlin/psi/KtElementImplStub;", "relevantChildren", "", "Lorg/jetbrains/kotlin/psi/KtElement;", "(Lorg/jetbrains/kotlin/psi/KtElementImplStub;[Lorg/jetbrains/kotlin/psi/KtElement;)Ljava/lang/String;", "renderChildren", "separator", "prefix", "postfix", "visitAnnotation", "annotation", "Lorg/jetbrains/kotlin/psi/KtAnnotation;", "data", "(Lorg/jetbrains/kotlin/psi/KtAnnotation;Lkotlin/Unit;)Ljava/lang/String;", "visitAnnotationEntry", "annotationEntry", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "(Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;Lkotlin/Unit;)Ljava/lang/String;", "visitAnonymousInitializer", "initializer", "Lorg/jetbrains/kotlin/psi/KtAnonymousInitializer;", "(Lorg/jetbrains/kotlin/psi/KtAnonymousInitializer;Lkotlin/Unit;)Ljava/lang/String;", "visitClass", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "(Lorg/jetbrains/kotlin/psi/KtClass;Lkotlin/Unit;)Ljava/lang/String;", "visitClassBody", "classBody", "Lorg/jetbrains/kotlin/psi/KtClassBody;", "(Lorg/jetbrains/kotlin/psi/KtClassBody;Lkotlin/Unit;)Ljava/lang/String;", "visitConstructorCalleeExpression", "constructorCalleeExpression", "Lorg/jetbrains/kotlin/psi/KtConstructorCalleeExpression;", "(Lorg/jetbrains/kotlin/psi/KtConstructorCalleeExpression;Lkotlin/Unit;)Ljava/lang/String;", "visitDotQualifiedExpression", "expression", "Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;", "(Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;Lkotlin/Unit;)Ljava/lang/String;", "visitDynamicType", "type", "Lorg/jetbrains/kotlin/psi/KtDynamicType;", "(Lorg/jetbrains/kotlin/psi/KtDynamicType;Lkotlin/Unit;)Ljava/lang/String;", "visitEnumEntry", "enumEntry", "Lorg/jetbrains/kotlin/psi/KtEnumEntry;", "(Lorg/jetbrains/kotlin/psi/KtEnumEntry;Lkotlin/Unit;)Ljava/lang/String;", "visitFunctionType", "functionType", "Lorg/jetbrains/kotlin/psi/KtFunctionType;", "(Lorg/jetbrains/kotlin/psi/KtFunctionType;Lkotlin/Unit;)Ljava/lang/String;", "visitImportDirective", "importDirective", "Lorg/jetbrains/kotlin/psi/KtImportDirective;", "(Lorg/jetbrains/kotlin/psi/KtImportDirective;Lkotlin/Unit;)Ljava/lang/String;", "visitImportList", "importList", "Lorg/jetbrains/kotlin/psi/KtImportList;", "(Lorg/jetbrains/kotlin/psi/KtImportList;Lkotlin/Unit;)Ljava/lang/String;", "visitInitializerList", "list", "Lorg/jetbrains/kotlin/psi/KtInitializerList;", "(Lorg/jetbrains/kotlin/psi/KtInitializerList;Lkotlin/Unit;)Ljava/lang/String;", "visitKtElement", "(Lorg/jetbrains/kotlin/psi/KtElement;Lkotlin/Unit;)Ljava/lang/String;", "visitKtFile", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "(Lorg/jetbrains/kotlin/psi/KtFile;Lkotlin/Unit;)Ljava/lang/String;", "visitModifierList", "Lorg/jetbrains/kotlin/psi/KtModifierList;", "(Lorg/jetbrains/kotlin/psi/KtModifierList;Lkotlin/Unit;)Ljava/lang/String;", "visitNamedFunction", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "(Lorg/jetbrains/kotlin/psi/KtNamedFunction;Lkotlin/Unit;)Ljava/lang/String;", "visitNullableType", "nullableType", "Lorg/jetbrains/kotlin/psi/KtNullableType;", "(Lorg/jetbrains/kotlin/psi/KtNullableType;Lkotlin/Unit;)Ljava/lang/String;", "visitObjectDeclaration", "declaration", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "(Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;Lkotlin/Unit;)Ljava/lang/String;", "visitParameter", "parameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "(Lorg/jetbrains/kotlin/psi/KtParameter;Lkotlin/Unit;)Ljava/lang/String;", "visitParameterList", "Lorg/jetbrains/kotlin/psi/KtParameterList;", "(Lorg/jetbrains/kotlin/psi/KtParameterList;Lkotlin/Unit;)Ljava/lang/String;", "visitProperty", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "(Lorg/jetbrains/kotlin/psi/KtProperty;Lkotlin/Unit;)Ljava/lang/String;", "visitPropertyAccessor", "accessor", "Lorg/jetbrains/kotlin/psi/KtPropertyAccessor;", "(Lorg/jetbrains/kotlin/psi/KtPropertyAccessor;Lkotlin/Unit;)Ljava/lang/String;", "visitSimpleNameExpression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "(Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;Lkotlin/Unit;)Ljava/lang/String;", "visitSuperTypeList", "Lorg/jetbrains/kotlin/psi/KtSuperTypeList;", "(Lorg/jetbrains/kotlin/psi/KtSuperTypeList;Lkotlin/Unit;)Ljava/lang/String;", "visitSuperTypeListEntry", "specifier", "Lorg/jetbrains/kotlin/psi/KtSuperTypeListEntry;", "(Lorg/jetbrains/kotlin/psi/KtSuperTypeListEntry;Lkotlin/Unit;)Ljava/lang/String;", "visitTypeArgumentList", "typeArgumentList", "Lorg/jetbrains/kotlin/psi/KtTypeArgumentList;", "(Lorg/jetbrains/kotlin/psi/KtTypeArgumentList;Lkotlin/Unit;)Ljava/lang/String;", "visitTypeConstraint", "constraint", "Lorg/jetbrains/kotlin/psi/KtTypeConstraint;", "(Lorg/jetbrains/kotlin/psi/KtTypeConstraint;Lkotlin/Unit;)Ljava/lang/String;", "visitTypeConstraintList", "Lorg/jetbrains/kotlin/psi/KtTypeConstraintList;", "(Lorg/jetbrains/kotlin/psi/KtTypeConstraintList;Lkotlin/Unit;)Ljava/lang/String;", "visitTypeParameter", "Lorg/jetbrains/kotlin/psi/KtTypeParameter;", "(Lorg/jetbrains/kotlin/psi/KtTypeParameter;Lkotlin/Unit;)Ljava/lang/String;", "visitTypeParameterList", "Lorg/jetbrains/kotlin/psi/KtTypeParameterList;", "(Lorg/jetbrains/kotlin/psi/KtTypeParameterList;Lkotlin/Unit;)Ljava/lang/String;", "visitTypeProjection", "typeProjection", "Lorg/jetbrains/kotlin/psi/KtTypeProjection;", "(Lorg/jetbrains/kotlin/psi/KtTypeProjection;Lkotlin/Unit;)Ljava/lang/String;", "visitTypeReference", "typeReference", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "(Lorg/jetbrains/kotlin/psi/KtTypeReference;Lkotlin/Unit;)Ljava/lang/String;", "visitUserType", "userType", "Lorg/jetbrains/kotlin/psi/KtUserType;", "(Lorg/jetbrains/kotlin/psi/KtUserType;Lkotlin/Unit;)Ljava/lang/String;", "frontend.common-psi"})
@SourceDebugExtension(value={"SMAP\nDebugTextUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DebugTextUtil.kt\norg/jetbrains/kotlin/psi/debugText/DebugTextBuildingVisitor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,292:1\n1603#2,9:293\n1855#2:302\n1856#2:304\n1612#2:305\n1#3:303\n*S KotlinDebug\n*F\n+ 1 DebugTextUtil.kt\norg/jetbrains/kotlin/psi/debugText/DebugTextBuildingVisitor\n*L\n271#1:293,9\n271#1:302\n271#1:304\n271#1:305\n271#1:303\n*E\n"})
final class DebugTextBuildingVisitor
extends KtVisitor<String, Unit> {
    @NotNull
    public static final DebugTextBuildingVisitor INSTANCE = new DebugTextBuildingVisitor();
    @NotNull
    private static final Logger LOG;

    private DebugTextBuildingVisitor() {
    }

    @Override
    @Nullable
    public String visitKtFile(@NotNull KtFile file2, @Nullable Unit data2) {
        Intrinsics.checkNotNullParameter(file2, "file");
        return "STUB file: " + file2.getName();
    }

    @Override
    @Nullable
    public String visitKtElement(@NotNull KtElement element, @Nullable Unit data2) {
        Intrinsics.checkNotNullParameter(element, "element");
        if (element instanceof KtElementImplStub) {
            LOG.error("getDebugText() is not defined for " + element.getClass());
        }
        return element.getText();
    }

    @Override
    @Nullable
    public String visitImportDirective(@NotNull KtImportDirective importDirective, @Nullable Unit data2) {
        String string2;
        Intrinsics.checkNotNullParameter(importDirective, "importDirective");
        ImportPath importPath = importDirective.getImportPath();
        if (importPath == null) {
            return "import <invalid>";
        }
        ImportPath importPath2 = importPath;
        if (importPath2.hasAlias()) {
            StringBuilder stringBuilder2 = new StringBuilder().append(" as ");
            Name name2 = importPath2.getAlias();
            Intrinsics.checkNotNull(name2);
            string2 = stringBuilder2.append(name2.asString()).toString();
        } else {
            string2 = "";
        }
        String aliasStr = string2;
        return "import " + importPath2.getPathStr() + aliasStr;
    }

    @Override
    @Nullable
    public String visitImportList(@NotNull KtImportList importList, @Nullable Unit data2) {
        Intrinsics.checkNotNullParameter(importList, "importList");
        return DebugTextBuildingVisitor.renderChildren$default(this, importList, "\n", null, null, 12, null);
    }

    @Override
    @Nullable
    public String visitAnnotationEntry(@NotNull KtAnnotationEntry annotationEntry, @Nullable Unit data2) {
        Intrinsics.checkNotNullParameter(annotationEntry, "annotationEntry");
        KtElement[] ktElementArray = new KtElement[]{annotationEntry.getCalleeExpression(), annotationEntry.getTypeArgumentList()};
        return this.render(annotationEntry, ktElementArray);
    }

    @Override
    @Nullable
    public String visitTypeReference(@NotNull KtTypeReference typeReference, @Nullable Unit data2) {
        Intrinsics.checkNotNullParameter(typeReference, "typeReference");
        return DebugTextBuildingVisitor.renderChildren$default(this, typeReference, " ", null, null, 12, null);
    }

    @Override
    @Nullable
    public String visitTypeArgumentList(@NotNull KtTypeArgumentList typeArgumentList, @Nullable Unit data2) {
        Intrinsics.checkNotNullParameter(typeArgumentList, "typeArgumentList");
        return this.renderChildren(typeArgumentList, ", ", "<", ">");
    }

    @Override
    @Nullable
    public String visitTypeConstraintList(@NotNull KtTypeConstraintList list2, @Nullable Unit data2) {
        Intrinsics.checkNotNullParameter(list2, "list");
        return this.renderChildren(list2, ", ", "where ", "");
    }

    @Override
    @Nullable
    public String visitUserType(@NotNull KtUserType userType, @Nullable Unit data2) {
        Intrinsics.checkNotNullParameter(userType, "userType");
        KtElement[] ktElementArray = new KtElement[]{userType.getQualifier(), userType.getReferenceExpression(), userType.getTypeArgumentList()};
        return this.render(userType, ktElementArray);
    }

    @Override
    @Nullable
    public String visitDynamicType(@NotNull KtDynamicType type2, @Nullable Unit data2) {
        Intrinsics.checkNotNullParameter(type2, "type");
        return "dynamic";
    }

    @Override
    @Nullable
    public String visitAnnotation(@NotNull KtAnnotation annotation2, @Nullable Unit data2) {
        Intrinsics.checkNotNullParameter(annotation2, "annotation");
        return this.renderChildren(annotation2, " ", "[", "]");
    }

    @Override
    @Nullable
    public String visitConstructorCalleeExpression(@NotNull KtConstructorCalleeExpression constructorCalleeExpression, @Nullable Unit data2) {
        Intrinsics.checkNotNullParameter(constructorCalleeExpression, "constructorCalleeExpression");
        KtElement[] ktElementArray = new KtElement[]{constructorCalleeExpression.getConstructorReferenceExpression()};
        return this.render(constructorCalleeExpression, ktElementArray);
    }

    @Override
    @Nullable
    public String visitSuperTypeListEntry(@NotNull KtSuperTypeListEntry specifier, @Nullable Unit data2) {
        Intrinsics.checkNotNullParameter(specifier, "specifier");
        KtElement[] ktElementArray = new KtElement[]{specifier.getTypeReference()};
        return this.render(specifier, ktElementArray);
    }

    @Override
    @Nullable
    public String visitSuperTypeList(@NotNull KtSuperTypeList list2, @Nullable Unit data2) {
        Intrinsics.checkNotNullParameter(list2, "list");
        return DebugTextBuildingVisitor.renderChildren$default(this, list2, ", ", null, null, 12, null);
    }

    @Override
    @Nullable
    public String visitTypeParameterList(@NotNull KtTypeParameterList list2, @Nullable Unit data2) {
        Intrinsics.checkNotNullParameter(list2, "list");
        return this.renderChildren(list2, ", ", "<", ">");
    }

    @Override
    @Nullable
    public String visitDotQualifiedExpression(@NotNull KtDotQualifiedExpression expression2, @Nullable Unit data2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        return DebugTextBuildingVisitor.renderChildren$default(this, expression2, ".", null, null, 12, null);
    }

    @Override
    @Nullable
    public String visitInitializerList(@NotNull KtInitializerList list2, @Nullable Unit data2) {
        Intrinsics.checkNotNullParameter(list2, "list");
        return DebugTextBuildingVisitor.renderChildren$default(this, list2, ", ", null, null, 12, null);
    }

    @Override
    @Nullable
    public String visitParameterList(@NotNull KtParameterList list2, @Nullable Unit data2) {
        Intrinsics.checkNotNullParameter(list2, "list");
        return this.renderChildren(list2, ", ", "(", ")");
    }

    @Override
    @Nullable
    public String visitEnumEntry(@NotNull KtEnumEntry enumEntry, @Nullable Unit data2) {
        Intrinsics.checkNotNullParameter(enumEntry, "enumEntry");
        return this.buildText((Function1<? super StringBuilder, Unit>)new Function1<StringBuilder, Unit>(enumEntry){
            final /* synthetic */ KtEnumEntry $enumEntry;
            {
                this.$enumEntry = $enumEntry;
                super(1);
            }

            public final void invoke(@NotNull StringBuilder $this$buildText) {
                Intrinsics.checkNotNullParameter($this$buildText, "$this$buildText");
                $this$buildText.append("STUB: ");
                DebugTextUtilKt.appendInn$default($this$buildText, this.$enumEntry.getModifierList(), null, " ", 2, null);
                $this$buildText.append("enum entry ");
                DebugTextUtilKt.appendInn$default($this$buildText, this.$enumEntry.getNameAsName(), null, null, 6, null);
                DebugTextUtilKt.appendInn$default($this$buildText, this.$enumEntry.getInitializerList(), " : ", null, 4, null);
            }
        });
    }

    @Override
    @Nullable
    public String visitFunctionType(@NotNull KtFunctionType functionType, @Nullable Unit data2) {
        Intrinsics.checkNotNullParameter(functionType, "functionType");
        return this.buildText((Function1<? super StringBuilder, Unit>)new Function1<StringBuilder, Unit>(functionType){
            final /* synthetic */ KtFunctionType $functionType;
            {
                this.$functionType = $functionType;
                super(1);
            }

            public final void invoke(@NotNull StringBuilder $this$buildText) {
                Intrinsics.checkNotNullParameter($this$buildText, "$this$buildText");
                DebugTextUtilKt.appendInn$default($this$buildText, this.$functionType.getReceiverTypeReference(), null, ".", 2, null);
                DebugTextUtilKt.appendInn$default($this$buildText, this.$functionType.getParameterList(), null, null, 6, null);
                DebugTextUtilKt.appendInn$default($this$buildText, this.$functionType.getReturnTypeReference(), " -> ", null, 4, null);
            }
        });
    }

    @Override
    @Nullable
    public String visitTypeParameter(@NotNull KtTypeParameter parameter2, @Nullable Unit data2) {
        Intrinsics.checkNotNullParameter(parameter2, "parameter");
        return this.buildText((Function1<? super StringBuilder, Unit>)new Function1<StringBuilder, Unit>(parameter2){
            final /* synthetic */ KtTypeParameter $parameter;
            {
                this.$parameter = $parameter;
                super(1);
            }

            public final void invoke(@NotNull StringBuilder $this$buildText) {
                Intrinsics.checkNotNullParameter($this$buildText, "$this$buildText");
                DebugTextUtilKt.appendInn$default($this$buildText, this.$parameter.getModifierList(), null, " ", 2, null);
                DebugTextUtilKt.appendInn$default($this$buildText, this.$parameter.getNameAsName(), null, null, 6, null);
                DebugTextUtilKt.appendInn$default($this$buildText, this.$parameter.getExtendsBound(), " : ", null, 4, null);
            }
        });
    }

    @Override
    @Nullable
    public String visitTypeProjection(@NotNull KtTypeProjection typeProjection, @Nullable Unit data2) {
        Intrinsics.checkNotNullParameter(typeProjection, "typeProjection");
        return this.buildText((Function1<? super StringBuilder, Unit>)new Function1<StringBuilder, Unit>(typeProjection){
            final /* synthetic */ KtTypeProjection $typeProjection;
            {
                this.$typeProjection = $typeProjection;
                super(1);
            }

            public final void invoke(@NotNull StringBuilder $this$buildText) {
                KtSingleValueToken token;
                Intrinsics.checkNotNullParameter($this$buildText, "$this$buildText");
                KtSingleValueToken ktSingleValueToken = token = this.$typeProjection.getProjectionKind().getToken();
                DebugTextUtilKt.appendInn$default($this$buildText, ktSingleValueToken != null ? ktSingleValueToken.getValue() : null, null, null, 6, null);
                KtTypeReference typeReference = this.$typeProjection.getTypeReference();
                if (token != null && typeReference != null) {
                    $this$buildText.append(" ");
                }
                DebugTextUtilKt.appendInn$default($this$buildText, typeReference, null, null, 6, null);
            }
        });
    }

    @Override
    @Nullable
    public String visitModifierList(@NotNull KtModifierList list2, @Nullable Unit data2) {
        Intrinsics.checkNotNullParameter(list2, "list");
        return this.buildText((Function1<? super StringBuilder, Unit>)new Function1<StringBuilder, Unit>(list2){
            final /* synthetic */ KtModifierList $list;
            {
                this.$list = $list;
                super(1);
            }

            public final void invoke(@NotNull StringBuilder $this$buildText) {
                Intrinsics.checkNotNullParameter($this$buildText, "$this$buildText");
                boolean first = true;
                Intrinsics.checkNotNullExpressionValue(KtTokens.MODIFIER_KEYWORDS_ARRAY, "MODIFIER_KEYWORDS_ARRAY");
                for (KtModifierKeywordToken modifierKeywordToken : KtTokens.MODIFIER_KEYWORDS_ARRAY) {
                    if (!this.$list.hasModifier(modifierKeywordToken)) continue;
                    if (!first) {
                        $this$buildText.append(" ");
                    }
                    $this$buildText.append(modifierKeywordToken.getValue());
                    first = false;
                }
            }
        });
    }

    @Override
    @Nullable
    public String visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression2, @Nullable Unit data2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        return expression2.getReferencedName();
    }

    @Override
    @Nullable
    public String visitNullableType(@NotNull KtNullableType nullableType, @Nullable Unit data2) {
        Intrinsics.checkNotNullParameter(nullableType, "nullableType");
        return this.renderChildren(nullableType, "", "", "?");
    }

    @Override
    @Nullable
    public String visitAnonymousInitializer(@NotNull KtAnonymousInitializer initializer2, @Nullable Unit data2) {
        Intrinsics.checkNotNullParameter(initializer2, "initializer");
        KtDeclaration containingDeclaration = KtStubbedPsiUtil.getContainingDeclaration(initializer2);
        StringBuilder stringBuilder2 = new StringBuilder().append("initializer in ");
        Object object = containingDeclaration;
        if (object == null || (object = DebugTextUtilKt.getDebugText((KtElement)object)) == null) {
            object = "...";
        }
        return stringBuilder2.append((String)object).toString();
    }

    @Override
    @Nullable
    public String visitClassBody(@NotNull KtClassBody classBody, @Nullable Unit data2) {
        Intrinsics.checkNotNullParameter(classBody, "classBody");
        KtDeclaration containingDeclaration = KtStubbedPsiUtil.getContainingDeclaration(classBody);
        StringBuilder stringBuilder2 = new StringBuilder().append("class body for ");
        Object object = containingDeclaration;
        if (object == null || (object = DebugTextUtilKt.getDebugText((KtElement)object)) == null) {
            object = "...";
        }
        return stringBuilder2.append((String)object).toString();
    }

    @Override
    @Nullable
    public String visitPropertyAccessor(@NotNull KtPropertyAccessor accessor, @Nullable Unit data2) {
        Intrinsics.checkNotNullParameter(accessor, "accessor");
        KtProperty containingProperty = KtStubbedPsiUtil.getContainingDeclaration(accessor, KtProperty.class);
        String what = accessor.isGetter() ? "getter" : "setter";
        StringBuilder stringBuilder2 = new StringBuilder().append(what).append(" for ");
        Object object = containingProperty;
        if (object == null || (object = DebugTextUtilKt.getDebugText((KtElement)object)) == null) {
            object = "...";
        }
        return stringBuilder2.append((String)object).toString();
    }

    @Override
    @Nullable
    public String visitClass(@NotNull KtClass klass, @Nullable Unit data2) {
        Intrinsics.checkNotNullParameter(klass, "klass");
        return this.buildText((Function1<? super StringBuilder, Unit>)new Function1<StringBuilder, Unit>(klass){
            final /* synthetic */ KtClass $klass;
            {
                this.$klass = $klass;
                super(1);
            }

            public final void invoke(@NotNull StringBuilder $this$buildText) {
                Intrinsics.checkNotNullParameter($this$buildText, "$this$buildText");
                $this$buildText.append("STUB: ");
                DebugTextUtilKt.appendInn$default($this$buildText, this.$klass.getModifierList(), null, " ", 2, null);
                $this$buildText.append("class ");
                DebugTextUtilKt.appendInn$default($this$buildText, this.$klass.getNameAsName(), null, null, 6, null);
                DebugTextUtilKt.appendInn$default($this$buildText, this.$klass.getTypeParameterList(), null, null, 6, null);
                DebugTextUtilKt.access$appendInn($this$buildText, this.$klass.getPrimaryConstructorModifierList(), " ", " ");
                DebugTextUtilKt.appendInn$default($this$buildText, this.$klass.getPrimaryConstructorParameterList(), null, null, 6, null);
                DebugTextUtilKt.appendInn$default($this$buildText, this.$klass.getSuperTypeList(), " : ", null, 4, null);
            }
        });
    }

    @Override
    @Nullable
    public String visitNamedFunction(@NotNull KtNamedFunction function2, @Nullable Unit data2) {
        Intrinsics.checkNotNullParameter(function2, "function");
        return this.buildText((Function1<? super StringBuilder, Unit>)new Function1<StringBuilder, Unit>(function2){
            final /* synthetic */ KtNamedFunction $function;
            {
                this.$function = $function;
                super(1);
            }

            public final void invoke(@NotNull StringBuilder $this$buildText) {
                Intrinsics.checkNotNullParameter($this$buildText, "$this$buildText");
                $this$buildText.append("STUB: ");
                DebugTextUtilKt.appendInn$default($this$buildText, this.$function.getModifierList(), null, " ", 2, null);
                $this$buildText.append("fun ");
                KtTypeParameterList typeParameterList = this.$function.getTypeParameterList();
                if (this.$function.hasTypeParameterListBeforeFunctionName()) {
                    DebugTextUtilKt.appendInn$default($this$buildText, typeParameterList, null, " ", 2, null);
                }
                DebugTextUtilKt.appendInn$default($this$buildText, this.$function.getReceiverTypeReference(), null, ".", 2, null);
                DebugTextUtilKt.appendInn$default($this$buildText, this.$function.getNameAsName(), null, null, 6, null);
                if (!this.$function.hasTypeParameterListBeforeFunctionName()) {
                    DebugTextUtilKt.appendInn$default($this$buildText, typeParameterList, null, null, 6, null);
                }
                DebugTextUtilKt.appendInn$default($this$buildText, this.$function.getValueParameterList(), null, null, 6, null);
                DebugTextUtilKt.appendInn$default($this$buildText, this.$function.getTypeReference(), ": ", null, 4, null);
                DebugTextUtilKt.appendInn$default($this$buildText, this.$function.getTypeConstraintList(), " ", null, 4, null);
            }
        });
    }

    @Override
    @Nullable
    public String visitObjectDeclaration(@NotNull KtObjectDeclaration declaration, @Nullable Unit data2) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        return this.buildText((Function1<? super StringBuilder, Unit>)new Function1<StringBuilder, Unit>(declaration){
            final /* synthetic */ KtObjectDeclaration $declaration;
            {
                this.$declaration = $declaration;
                super(1);
            }

            public final void invoke(@NotNull StringBuilder $this$buildText) {
                Intrinsics.checkNotNullParameter($this$buildText, "$this$buildText");
                $this$buildText.append("STUB: ");
                DebugTextUtilKt.appendInn$default($this$buildText, this.$declaration.getModifierList(), null, " ", 2, null);
                $this$buildText.append("object ");
                DebugTextUtilKt.appendInn$default($this$buildText, this.$declaration.getNameAsName(), null, null, 6, null);
                DebugTextUtilKt.appendInn$default($this$buildText, this.$declaration.getSuperTypeList(), " : ", null, 4, null);
            }
        });
    }

    @Override
    @Nullable
    public String visitParameter(@NotNull KtParameter parameter2, @Nullable Unit data2) {
        Intrinsics.checkNotNullParameter(parameter2, "parameter");
        return this.buildText((Function1<? super StringBuilder, Unit>)new Function1<StringBuilder, Unit>(parameter2){
            final /* synthetic */ KtParameter $parameter;
            {
                this.$parameter = $parameter;
                super(1);
            }

            public final void invoke(@NotNull StringBuilder $this$buildText) {
                Intrinsics.checkNotNullParameter($this$buildText, "$this$buildText");
                if (this.$parameter.hasValOrVar()) {
                    if (this.$parameter.isMutable()) {
                        $this$buildText.append("var ");
                    } else {
                        $this$buildText.append("val ");
                    }
                }
                Name name2 = this.$parameter.getNameAsName();
                DebugTextUtilKt.appendInn$default($this$buildText, name2, null, null, 6, null);
                KtTypeReference typeReference = this.$parameter.getTypeReference();
                if (typeReference != null && name2 != null) {
                    $this$buildText.append(": ");
                }
                DebugTextUtilKt.appendInn$default($this$buildText, typeReference, null, null, 6, null);
            }
        });
    }

    @Override
    @Nullable
    public String visitProperty(@NotNull KtProperty property, @Nullable Unit data2) {
        Intrinsics.checkNotNullParameter(property, "property");
        return this.buildText((Function1<? super StringBuilder, Unit>)new Function1<StringBuilder, Unit>(property){
            final /* synthetic */ KtProperty $property;
            {
                this.$property = $property;
                super(1);
            }

            public final void invoke(@NotNull StringBuilder $this$buildText) {
                Intrinsics.checkNotNullParameter($this$buildText, "$this$buildText");
                $this$buildText.append("STUB: ");
                DebugTextUtilKt.appendInn$default($this$buildText, this.$property.getModifierList(), null, " ", 2, null);
                $this$buildText.append(this.$property.isVar() ? "var " : "val ");
                DebugTextUtilKt.appendInn$default($this$buildText, this.$property.getNameAsName(), null, null, 6, null);
                DebugTextUtilKt.appendInn$default($this$buildText, this.$property.getTypeReference(), ": ", null, 4, null);
            }
        });
    }

    @Override
    @Nullable
    public String visitTypeConstraint(@NotNull KtTypeConstraint constraint2, @Nullable Unit data2) {
        Intrinsics.checkNotNullParameter(constraint2, "constraint");
        return this.buildText((Function1<? super StringBuilder, Unit>)new Function1<StringBuilder, Unit>(constraint2){
            final /* synthetic */ KtTypeConstraint $constraint;
            {
                this.$constraint = $constraint;
                super(1);
            }

            public final void invoke(@NotNull StringBuilder $this$buildText) {
                Intrinsics.checkNotNullParameter($this$buildText, "$this$buildText");
                DebugTextUtilKt.appendInn$default($this$buildText, this.$constraint.getSubjectTypeParameterName(), null, null, 6, null);
                DebugTextUtilKt.appendInn$default($this$buildText, this.$constraint.getBoundTypeReference(), " : ", null, 4, null);
            }
        });
    }

    @Nullable
    public final String buildText(@NotNull Function1<? super StringBuilder, Unit> body2) {
        Intrinsics.checkNotNullParameter(body2, "body");
        StringBuilder sb = new StringBuilder();
        body2.invoke(sb);
        return sb.toString();
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final String renderChildren(@NotNull KtElementImplStub<?> element, @NotNull String separator, @NotNull String prefix, @NotNull String postfix) {
        String childrenTexts;
        String string2;
        Object object;
        Intrinsics.checkNotNullParameter(element, "element");
        Intrinsics.checkNotNullParameter(separator, "separator");
        Intrinsics.checkNotNullParameter(prefix, "prefix");
        Intrinsics.checkNotNullParameter(postfix, "postfix");
        Object t = element.getStub();
        if (t != null && (t = t.getChildrenStubs()) != null) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = (Iterable)t;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                String it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                StubElement it = (StubElement)element$iv$iv;
                boolean bl2 = false;
                StubElement stubElement = it;
                Object t2 = stubElement != null ? stubElement.getPsi() : null;
                KtElement ktElement = t2 instanceof KtElement ? (KtElement)t2 : null;
                if ((ktElement != null ? DebugTextUtilKt.getDebugText(ktElement) : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            object = (List)destination$iv$iv;
        } else {
            object = null;
        }
        if ((string2 = (childrenTexts = object)) == null || (string2 = CollectionsKt.joinToString$default((Iterable)((Object)string2), separator, prefix, postfix, 0, null, null, 56, null)) == null) {
            string2 = element.getText();
        }
        return string2;
    }

    public static /* synthetic */ String renderChildren$default(DebugTextBuildingVisitor debugTextBuildingVisitor, KtElementImplStub ktElementImplStub, String string2, String string3, String string4, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = "";
        }
        if ((n & 8) != 0) {
            string4 = "";
        }
        return debugTextBuildingVisitor.renderChildren(ktElementImplStub, string2, string3, string4);
    }

    @Nullable
    public final String render(@NotNull KtElementImplStub<?> element, KtElement ... relevantChildren) {
        Intrinsics.checkNotNullParameter(element, "element");
        Intrinsics.checkNotNullParameter(relevantChildren, "relevantChildren");
        if (element.getStub() == null) {
            return element.getText();
        }
        return CollectionsKt.joinToString$default(ArraysKt.filterNotNull(relevantChildren), "", "", "", 0, null, render.1.INSTANCE, 24, null);
    }

    static {
        Logger logger = Logger.getInstance(INSTANCE.getClass());
        Intrinsics.checkNotNullExpressionValue(logger, "getInstance(this::class.java)");
        LOG = logger;
    }
}

