/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.expression;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsCatch;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsIf;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNullLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsThrow;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.expression.PatternTranslator;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.general.Translation;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0000\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0004H\u0002J&\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u001bH\u0002R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0018\u0010\u000e\u001a\u00020\u000f*\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0011\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/js/translate/expression/CatchTranslator;", "Lorg/jetbrains/kotlin/js/translate/general/AbstractTranslator;", "catches", "", "Lorg/jetbrains/kotlin/psi/KtCatchClause;", "psi", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "(Ljava/util/List;Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;)V", "getCatches", "()Ljava/util/List;", "getPsi", "()Lcom/intellij/psi/PsiElement;", "isDynamic", "", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "(Lorg/jetbrains/kotlin/psi/KtTypeReference;)Z", "translate", "Lorg/jetbrains/kotlin/js/backend/ast/JsCatch;", "translateCatchBody", "Lorg/jetbrains/kotlin/js/backend/ast/JsBlock;", "catchClause", "translateCatches", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "initialCatchParameterRef", "Lorg/jetbrains/kotlin/js/backend/ast/JsNameRef;", "", "js.translator"})
@SourceDebugExtension(value={"SMAP\nCatchTranslator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CatchTranslator.kt\norg/jetbrains/kotlin/js/translate/expression/CatchTranslator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,142:1\n1#2:143\n*E\n"})
public final class CatchTranslator
extends AbstractTranslator {
    @NotNull
    private final List<KtCatchClause> catches;
    @NotNull
    private final PsiElement psi;

    public CatchTranslator(@NotNull List<? extends KtCatchClause> catches, @NotNull PsiElement psi, @NotNull TranslationContext context) {
        Intrinsics.checkNotNullParameter(catches, "catches");
        Intrinsics.checkNotNullParameter(psi, "psi");
        Intrinsics.checkNotNullParameter(context, "context");
        super(context);
        this.catches = catches;
        this.psi = psi;
    }

    @NotNull
    public final List<KtCatchClause> getCatches() {
        return this.catches;
    }

    @NotNull
    public final PsiElement getPsi() {
        return this.psi;
    }

    @Nullable
    public final JsCatch translate() {
        if (this.catches.isEmpty()) {
            return null;
        }
        KtCatchClause firstCatch = CollectionsKt.first(this.catches);
        KtParameter catchParameter = firstCatch.getCatchParameter();
        BindingContext bindingContext = this.bindingContext();
        KtParameter ktParameter = catchParameter;
        Intrinsics.checkNotNull(ktParameter);
        DeclarationDescriptor declarationDescriptor = BindingUtils.getDescriptorForElement(bindingContext, ktParameter);
        Intrinsics.checkNotNullExpressionValue(declarationDescriptor, "getDescriptorForElement(\u2026text(), catchParameter!!)");
        DeclarationDescriptor parameterDescriptor = declarationDescriptor;
        String string2 = this.context().getNameForDescriptor(parameterDescriptor).getIdent();
        Intrinsics.checkNotNullExpressionValue(string2, "context().getNameForDesc\u2026arameterDescriptor).ident");
        String parameterName = string2;
        JsCatch jsCatch = new JsCatch(this.context().scope(), parameterName);
        JsNameRef jsNameRef = jsCatch.getParameter().getName().makeRef();
        Intrinsics.checkNotNullExpressionValue(jsNameRef, "jsCatch.parameter.name.makeRef()");
        JsNameRef parameterRef = jsNameRef;
        TranslationContext translationContext = this.context().innerContextWithAliased(parameterDescriptor, parameterRef);
        Intrinsics.checkNotNullExpressionValue(translationContext, "context().innerContextWi\u2026Descriptor, parameterRef)");
        TranslationContext catchContext = translationContext;
        jsCatch.setBody(new JsBlock(this.translateCatches(catchContext, parameterRef, this.catches.iterator())));
        return jsCatch;
    }

    private final JsStatement translateCatches(TranslationContext context, JsNameRef initialCatchParameterRef, Iterator<? extends KtCatchClause> catches) {
        JsIf jsIf;
        JsNameRef jsNameRef;
        if (!catches.hasNext()) {
            JsThrow jsThrow;
            JsThrow $this$translateCatches_u24lambda_u240 = jsThrow = new JsThrow(initialCatchParameterRef);
            boolean bl = false;
            $this$translateCatches_u24lambda_u240.setSource(this.psi);
            return jsThrow;
        }
        TranslationContext nextContext = context;
        KtCatchClause ktCatchClause = catches.next();
        KtParameter ktParameter = ktCatchClause.getCatchParameter();
        Intrinsics.checkNotNull(ktParameter);
        KtParameter param = ktParameter;
        BindingContext bindingContext = this.bindingContext();
        KtParameter ktParameter2 = ktCatchClause.getCatchParameter();
        Intrinsics.checkNotNull(ktParameter2);
        DeclarationDescriptor declarationDescriptor = BindingUtils.getDescriptorForElement(bindingContext, ktParameter2);
        Intrinsics.checkNotNullExpressionValue(declarationDescriptor, "getDescriptorForElement(\u2026, catch.catchParameter!!)");
        DeclarationDescriptor parameterDescriptor = declarationDescriptor;
        JsName jsName = this.context().getNameForDescriptor(parameterDescriptor);
        Intrinsics.checkNotNullExpressionValue(jsName, "context().getNameForDesc\u2026ptor(parameterDescriptor)");
        JsName parameterName = jsName;
        KtTypeReference ktTypeReference = param.getTypeReference();
        Intrinsics.checkNotNull(ktTypeReference);
        KtTypeReference paramType = ktTypeReference;
        List additionalStatements2 = new ArrayList();
        if (!Intrinsics.areEqual(parameterName.getIdent(), initialCatchParameterRef.getIdent())) {
            JsNameRef ref;
            JsName jsName2 = JsScope.declareTemporaryName(parameterName.getIdent());
            Intrinsics.checkNotNullExpressionValue(jsName2, "declareTemporaryName(parameterName.ident)");
            JsName parameterAlias = jsName2;
            ((Collection)additionalStatements2).add(JsAstUtils.newVar(parameterAlias, initialCatchParameterRef));
            JsNameRef jsNameRef2 = JsAstUtils.pureFqn(parameterAlias, null);
            Intrinsics.checkNotNullExpressionValue(jsNameRef2, "pureFqn(parameterAlias, null)");
            jsNameRef = ref = jsNameRef2;
        } else {
            jsNameRef = initialCatchParameterRef;
        }
        JsNameRef parameterRef = jsNameRef;
        TranslationContext translationContext = nextContext.innerContextWithAliased(parameterDescriptor, parameterRef);
        Intrinsics.checkNotNullExpressionValue(translationContext, "nextContext.innerContext\u2026Descriptor, parameterRef)");
        nextContext = translationContext;
        JsBlock thenBlock = this.translateCatchBody(nextContext, ktCatchClause);
        thenBlock.getStatements().addAll(0, additionalStatements2);
        if (this.isDynamic(paramType)) {
            return thenBlock;
        }
        PatternTranslator $this$translateCatches_u24lambda_u241 = Translation.patternTranslator(nextContext);
        boolean bl = false;
        JsExpression jsExpression = $this$translateCatches_u24lambda_u241.translateIsCheck(initialCatchParameterRef, paramType);
        Intrinsics.checkNotNull(jsExpression);
        JsExpression typeCheck = jsExpression;
        JsStatement elseBlock = this.translateCatches(context, initialCatchParameterRef, catches);
        JsIf $this$translateCatches_u24lambda_u242 = jsIf = new JsIf(typeCheck.source(ktCatchClause), thenBlock, elseBlock);
        boolean bl2 = false;
        $this$translateCatches_u24lambda_u242.setSource(ktCatchClause);
        return jsIf;
    }

    private final JsBlock translateCatchBody(TranslationContext context, KtCatchClause catchClause) {
        KtExpression catchBody = catchClause.getCatchBody();
        JsStatement jsCatchBody = catchBody != null ? Translation.translateAsStatementAndMergeInBlockIfNeeded(catchBody, context) : JsAstUtils.asSyntheticStatement(new JsNullLiteral());
        JsBlock jsBlock = JsAstUtils.convertToBlock(jsCatchBody);
        Intrinsics.checkNotNullExpressionValue(jsBlock, "convertToBlock(jsCatchBody)");
        return jsBlock;
    }

    private final boolean isDynamic(KtTypeReference $this$isDynamic) {
        Object v = BindingContextUtils.getNotNull(this.bindingContext(), BindingContext.TYPE, $this$isDynamic);
        Intrinsics.checkNotNullExpressionValue(v, "getNotNull(bindingContex\u2026indingContext.TYPE, this)");
        return DynamicTypesKt.isDynamic((KotlinType)v);
    }
}

