/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.js.checkers.declaration;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.js.FirJsErrors;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.resolve.ScopeUtilsKt;
import org.jetbrains.kotlin.fir.scopes.FirScopeKt;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J,\u0010\f\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsMultipleInheritanceChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirClassChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkFunctionIfSubtypeOf", "functionToCheck", "Lorg/jetbrains/kotlin/name/Name;", "supertype", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "checkers.js"})
@SourceDebugExtension(value={"SMAP\nFirJsMultipleInheritanceChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJsMultipleInheritanceChecker.kt\norg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsMultipleInheritanceChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,64:1\n1747#2,3:65\n*S KotlinDebug\n*F\n+ 1 FirJsMultipleInheritanceChecker.kt\norg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsMultipleInheritanceChecker\n*L\n58#1:65,3\n*E\n"})
public final class FirJsMultipleInheritanceChecker
extends FirDeclarationChecker<FirClass> {
    @NotNull
    public static final FirJsMultipleInheritanceChecker INSTANCE = new FirJsMultipleInheritanceChecker();

    private FirJsMultipleInheritanceChecker() {
    }

    @Override
    public void check(@NotNull FirClass declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        this.checkFunctionIfSubtypeOf(declaration, OperatorNameConventions.GET, context.getSession().getBuiltinTypes().getCharSequenceType().getType(), context, reporter);
        this.checkFunctionIfSubtypeOf(declaration, StandardNames.NEXT_CHAR, context.getSession().getBuiltinTypes().getCharIteratorType().getType(), context, reporter);
    }

    private final void checkFunctionIfSubtypeOf(FirClass $this$checkFunctionIfSubtypeOf, Name functionToCheck, ConeKotlinType supertype2, CheckerContext context, DiagnosticReporter reporter) {
        if (!TypeUtilsKt.isSubtypeOf$default(ScopeUtilsKt.defaultType($this$checkFunctionIfSubtypeOf), supertype2, context.getSession(), false, 4, null)) {
            return;
        }
        FirTypeScope scope2 = FirHelpersKt.unsubstitutedScope($this$checkFunctionIfSubtypeOf, context);
        List<FirNamedFunctionSymbol> overridesWithSameName = FirScopeKt.getFunctions(scope2, functionToCheck);
        for (FirNamedFunctionSymbol function2 : overridesWithSameName) {
            boolean bl;
            block5: {
                List<FirFunctionSymbol<?>> overridden = FirHelpersKt.overriddenFunctions(function2, $this$checkFunctionIfSubtypeOf.getSymbol(), context, null);
                if (overridden.size() <= 1) continue;
                Iterable $this$any$iv = overridden;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FirFunctionSymbol it = (FirFunctionSymbol)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual(it.getCallableId().getClassId(), ConeTypeUtilsKt.getClassId(supertype2))) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)$this$checkFunctionIfSubtypeOf.getSource(), FirJsErrors.INSTANCE.getWRONG_MULTIPLE_INHERITANCE(), (Object)function2, (DiagnosticContext)context, null, 16, null);
        }
    }
}

