/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.utils;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.wasm.utils.WasmArrayInfo;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.wasm.ir.WasmImportDescriptor;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u001a\f\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u0002\u001a\f\u0010\u0003\u001a\u0004\u0018\u00010\u0001*\u00020\u0002\u001a\f\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u00020\u0002\u001a\f\u0010\u0006\u001a\u0004\u0018\u00010\u0007*\u00020\b\u001a\f\u0010\t\u001a\u0004\u0018\u00010\u0001*\u00020\u0002\u001a\n\u0010\n\u001a\u00020\u000b*\u00020\u0002\u001a\n\u0010\f\u001a\u00020\u000b*\u00020\u0002\u001a\n\u0010\r\u001a\u00020\u000b*\u00020\u0002\u001a\n\u0010\u000e\u001a\u00020\u000b*\u00020\u0002\u00a8\u0006\u000f"}, d2={"getJsFunAnnotation", "", "Lorg/jetbrains/kotlin/ir/declarations/IrAnnotationContainer;", "getJsPrimitiveType", "getWasmArrayAnnotation", "Lorg/jetbrains/kotlin/backend/wasm/utils/WasmArrayInfo;", "getWasmImportDescriptor", "Lorg/jetbrains/kotlin/wasm/ir/WasmImportDescriptor;", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "getWasmOpAnnotation", "hasExcludedFromCodegenAnnotation", "", "hasWasmAutoboxedAnnotation", "hasWasmNoOpCastAnnotation", "hasWasmPrimitiveConstructorAnnotation", "backend.wasm"})
public final class AnnotationsKt {
    public static final boolean hasExcludedFromCodegenAnnotation(@NotNull IrAnnotationContainer $this$hasExcludedFromCodegenAnnotation) {
        Intrinsics.checkNotNullParameter($this$hasExcludedFromCodegenAnnotation, "<this>");
        return IrUtilsKt.hasAnnotation($this$hasExcludedFromCodegenAnnotation, new FqName("kotlin.wasm.internal.ExcludedFromCodegen"));
    }

    @Nullable
    public static final WasmImportDescriptor getWasmImportDescriptor(@NotNull IrFunction $this$getWasmImportDescriptor) {
        Intrinsics.checkNotNullParameter($this$getWasmImportDescriptor, "<this>");
        IrConstructorCall irConstructorCall = IrUtilsKt.getAnnotation($this$getWasmImportDescriptor, new FqName("kotlin.wasm.WasmImport"));
        if (irConstructorCall == null) {
            return null;
        }
        IrConstructorCall annotation2 = irConstructorCall;
        IrExpression irExpression = annotation2.getValueArgument(0);
        Intrinsics.checkNotNull(irExpression, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrConst<kotlin.String>");
        String string2 = (String)((IrConst)irExpression).getValue();
        IrExpression irExpression2 = annotation2.getValueArgument(1);
        Object object = irExpression2 instanceof IrConst ? (IrConst)irExpression2 : null;
        if (object == null || (object = (String)((IrConst)object).getValue()) == null) {
            String string3 = $this$getWasmImportDescriptor.getName().asString();
            object = string3;
            Intrinsics.checkNotNullExpressionValue(string3, "this.name.asString()");
        }
        return new WasmImportDescriptor(string2, (String)object);
    }

    @Nullable
    public static final String getWasmOpAnnotation(@NotNull IrAnnotationContainer $this$getWasmOpAnnotation) {
        Intrinsics.checkNotNullParameter($this$getWasmOpAnnotation, "<this>");
        IrConstructorCall irConstructorCall = IrUtilsKt.getAnnotation($this$getWasmOpAnnotation, new FqName("kotlin.wasm.internal.WasmOp"));
        return irConstructorCall != null ? AnnotationUtilsKt.getSingleConstStringArgument(irConstructorCall) : null;
    }

    public static final boolean hasWasmNoOpCastAnnotation(@NotNull IrAnnotationContainer $this$hasWasmNoOpCastAnnotation) {
        Intrinsics.checkNotNullParameter($this$hasWasmNoOpCastAnnotation, "<this>");
        return IrUtilsKt.hasAnnotation($this$hasWasmNoOpCastAnnotation, new FqName("kotlin.wasm.internal.WasmNoOpCast"));
    }

    public static final boolean hasWasmAutoboxedAnnotation(@NotNull IrAnnotationContainer $this$hasWasmAutoboxedAnnotation) {
        Intrinsics.checkNotNullParameter($this$hasWasmAutoboxedAnnotation, "<this>");
        return IrUtilsKt.hasAnnotation($this$hasWasmAutoboxedAnnotation, new FqName("kotlin.wasm.internal.WasmAutoboxed"));
    }

    public static final boolean hasWasmPrimitiveConstructorAnnotation(@NotNull IrAnnotationContainer $this$hasWasmPrimitiveConstructorAnnotation) {
        Intrinsics.checkNotNullParameter($this$hasWasmPrimitiveConstructorAnnotation, "<this>");
        return IrUtilsKt.hasAnnotation($this$hasWasmPrimitiveConstructorAnnotation, new FqName("kotlin.wasm.internal.WasmPrimitiveConstructor"));
    }

    @Nullable
    public static final WasmArrayInfo getWasmArrayAnnotation(@NotNull IrAnnotationContainer $this$getWasmArrayAnnotation) {
        WasmArrayInfo wasmArrayInfo;
        Intrinsics.checkNotNullParameter($this$getWasmArrayAnnotation, "<this>");
        IrConstructorCall irConstructorCall = IrUtilsKt.getAnnotation($this$getWasmArrayAnnotation, new FqName("kotlin.wasm.internal.WasmArrayOf"));
        if (irConstructorCall != null) {
            IrConstructorCall it = irConstructorCall;
            boolean bl = false;
            IrExpression irExpression = it.getValueArgument(0);
            Intrinsics.checkNotNull(irExpression, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrClassReference");
            IrSymbolOwner irSymbolOwner = ((IrClassReference)irExpression).getSymbol().getOwner();
            Intrinsics.checkNotNull(irSymbolOwner, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
            IrClass irClass2 = (IrClass)irSymbolOwner;
            IrExpression irExpression2 = it.getValueArgument(1);
            Intrinsics.checkNotNull(irExpression2, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrConst<*>");
            Object t = ((IrConst)irExpression2).getValue();
            Intrinsics.checkNotNull(t, "null cannot be cast to non-null type kotlin.Boolean");
            wasmArrayInfo = new WasmArrayInfo(irClass2, (Boolean)t);
        } else {
            wasmArrayInfo = null;
        }
        return wasmArrayInfo;
    }

    @Nullable
    public static final String getJsFunAnnotation(@NotNull IrAnnotationContainer $this$getJsFunAnnotation) {
        Intrinsics.checkNotNullParameter($this$getJsFunAnnotation, "<this>");
        IrConstructorCall irConstructorCall = IrUtilsKt.getAnnotation($this$getJsFunAnnotation, new FqName("kotlin.JsFun"));
        return irConstructorCall != null ? AnnotationUtilsKt.getSingleConstStringArgument(irConstructorCall) : null;
    }

    @Nullable
    public static final String getJsPrimitiveType(@NotNull IrAnnotationContainer $this$getJsPrimitiveType) {
        Intrinsics.checkNotNullParameter($this$getJsPrimitiveType, "<this>");
        IrConstructorCall irConstructorCall = IrUtilsKt.getAnnotation($this$getJsPrimitiveType, new FqName("kotlin.wasm.internal.JsPrimitive"));
        return irConstructorCall != null ? AnnotationUtilsKt.getSingleConstStringArgument(irConstructorCall) : null;
    }
}

