/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.expressions.FirGetClassCall;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccess;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J,\u0010\f\u001a\u00020\u0006*\b\u0012\u0002\b\u0003\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirStandaloneQualifierChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirResolvedQualifier;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirResolvedQualifierChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reportErrorOn", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "checkers"})
public final class FirStandaloneQualifierChecker
extends FirExpressionChecker<FirResolvedQualifier> {
    @NotNull
    public static final FirStandaloneQualifierChecker INSTANCE = new FirStandaloneQualifierChecker();

    private FirStandaloneQualifierChecker() {
    }

    @Override
    public void check(@NotNull FirResolvedQualifier expression2, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        FirGetClassCall lastGetClass;
        block6: {
            block5: {
                FirQualifiedAccess lastQualifiedAccess;
                Intrinsics.checkNotNullParameter(expression2, "expression");
                Intrinsics.checkNotNullParameter(context, "context");
                Intrinsics.checkNotNullParameter(reporter, "reporter");
                FirStatement firStatement = CollectionsKt.lastOrNull(context.getQualifiedAccessOrAnnotationCalls());
                FirQualifiedAccess firQualifiedAccess = lastQualifiedAccess = firStatement instanceof FirQualifiedAccess ? (FirQualifiedAccess)firStatement : null;
                if ((firQualifiedAccess != null ? firQualifiedAccess.getExplicitReceiver() : null) == expression2) break block5;
                FirQualifiedAccess firQualifiedAccess2 = lastQualifiedAccess;
                if ((firQualifiedAccess2 != null ? firQualifiedAccess2.getDispatchReceiver() : null) != expression2) break block6;
            }
            return;
        }
        FirGetClassCall firGetClassCall = lastGetClass = CollectionsKt.lastOrNull(context.getGetClassCalls());
        if ((firGetClassCall != null ? firGetClassCall.getArgument() : null) == expression2) {
            return;
        }
        if (!FirTypeUtilsKt.isUnit(expression2.getTypeRef())) {
            return;
        }
        this.reportErrorOn((FirBasedSymbol)expression2.getSymbol(), expression2.getSource(), context, reporter);
    }

    private final void reportErrorOn(FirBasedSymbol<?> $this$reportErrorOn, KtSourceElement source, CheckerContext context, DiagnosticReporter reporter) {
        FirBasedSymbol<?> firBasedSymbol = $this$reportErrorOn;
        if (firBasedSymbol instanceof FirRegularClassSymbol) {
            if (((FirRegularClassSymbol)$this$reportErrorOn).getClassKind() == ClassKind.OBJECT) {
                return;
            }
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getNO_COMPANION_OBJECT(), $this$reportErrorOn, (DiagnosticContext)context, null, 16, null);
        } else if (firBasedSymbol instanceof FirTypeAliasSymbol) {
            FirRegularClassSymbol firRegularClassSymbol = DeclarationUtilsKt.fullyExpandedClass((FirClassLikeSymbol)$this$reportErrorOn, context.getSession());
            if (firRegularClassSymbol != null) {
                this.reportErrorOn(firRegularClassSymbol, source, context, reporter);
            }
        } else if (firBasedSymbol == null) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getEXPRESSION_EXPECTED_PACKAGE_FOUND(), (DiagnosticContext)context, null, 8, null);
        }
    }
}

