/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls;

import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirRendererKt;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRefsOwner;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.calls.CallInfo;
import org.jetbrains.kotlin.fir.resolve.calls.Candidate;
import org.jetbrains.kotlin.fir.resolve.calls.CheckerSink;
import org.jetbrains.kotlin.fir.resolve.calls.CreateFreshTypeVariableSubstitutorStageKt;
import org.jetbrains.kotlin.fir.resolve.calls.InapplicableCandidate;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionContext;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionDiagnostic;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionStage;
import org.jetbrains.kotlin.fir.resolve.calls.TypeArgumentMapping;
import org.jetbrains.kotlin.fir.resolve.inference.model.ConeExplicitTypeParameterConstraintPosition;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import org.jetbrains.kotlin.fir.symbols.FirPhaseManagerKt;
import org.jetbrains.kotlin.fir.types.ConeTypeVariable;
import org.jetbrains.kotlin.fir.types.FirPlaceholderProjection;
import org.jetbrains.kotlin.fir.types.FirStarProjection;
import org.jetbrains.kotlin.fir.types.FirTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeProjectionWithVariance;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.resolve.calls.inference.model.NewConstraintSystemImpl;
import org.jetbrains.kotlin.resolve.calls.inference.model.SimpleConstraintSystemConstraintPosition;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J1\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\r\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/CreateFreshTypeVariableSubstitutorStage;", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionStage;", "()V", "check", "", "candidate", "Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;", "callInfo", "Lorg/jetbrains/kotlin/fir/resolve/calls/CallInfo;", "sink", "Lorg/jetbrains/kotlin/fir/resolve/calls/CheckerSink;", "context", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;", "(Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;Lorg/jetbrains/kotlin/fir/resolve/calls/CallInfo;Lorg/jetbrains/kotlin/fir/resolve/calls/CheckerSink;Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "resolve"})
public final class CreateFreshTypeVariableSubstitutorStage
extends ResolutionStage {
    @NotNull
    public static final CreateFreshTypeVariableSubstitutorStage INSTANCE = new CreateFreshTypeVariableSubstitutorStage();

    private CreateFreshTypeVariableSubstitutorStage() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object check(@NotNull Candidate candidate2, @NotNull CallInfo callInfo, @NotNull CheckerSink sink, @NotNull ResolutionContext context, @NotNull Continuation<? super Unit> $completion) {
        Object declaration = candidate2.getSymbol().getFir();
        FirPhaseManagerKt.ensureResolved(candidate2.getSymbol(), FirResolvePhase.STATUS);
        if (!(declaration instanceof FirTypeParameterRefsOwner) || ((FirTypeParameterRefsOwner)declaration).getTypeParameters().isEmpty()) {
            candidate2.setSubstitutor(ConeSubstitutor.Empty.INSTANCE);
            candidate2.setFreshVariables(CollectionsKt.emptyList());
            return Unit.INSTANCE;
        }
        NewConstraintSystemImpl csBuilder = candidate2.getSystem().getBuilder();
        Pair pair = CreateFreshTypeVariableSubstitutorStageKt.access$createToFreshVariableSubstitutorAndAddInitialConstraints((FirTypeParameterRefsOwner)declaration, csBuilder, context.getSession());
        ConeSubstitutor substitutor2 = (ConeSubstitutor)pair.component1();
        List freshVariables = (List)pair.component2();
        candidate2.setSubstitutor(substitutor2);
        candidate2.setFreshVariables(freshVariables);
        if (csBuilder.getHasContradiction()) {
            void $this$yieldDiagnostic$iv;
            CheckerSink checkerSink = sink;
            ResolutionDiagnostic diagnostic$iv = InapplicableCandidate.INSTANCE;
            boolean $i$f$yieldDiagnostic = false;
            $this$yieldDiagnostic$iv.reportDiagnostic(diagnostic$iv);
            void $this$yieldIfNeed$iv$iv = $this$yieldDiagnostic$iv;
            boolean $i$f$yieldIfNeed = false;
            if ($this$yieldIfNeed$iv$iv.getNeedYielding()) {
                Object object = $this$yieldIfNeed$iv$iv.yield($completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
            }
            return Unit.INSTANCE;
        }
        if (Intrinsics.areEqual(candidate2.getTypeArgumentMapping(), TypeArgumentMapping.NoExplicitArguments.INSTANCE)) {
            return Unit.INSTANCE;
        }
        List<FirTypeParameterRef> typeParameters2 = ((FirTypeParameterRefsOwner)declaration).getTypeParameters();
        int n = typeParameters2.size();
        for (int index2 = 0; index2 < n; ++index2) {
            FirTypeParameterRef typeParameter = typeParameters2.get(index2);
            ConeTypeVariable freshVariable = (ConeTypeVariable)freshVariables.get(index2);
            FirTypeProjection typeArgument = candidate2.getTypeArgumentMapping().get(index2);
            if (typeArgument instanceof FirTypeProjectionWithVariance) {
                csBuilder.addEqualityConstraint(freshVariable.getDefaultType(), TypeExpansionUtilsKt.fullyExpandedType(FirTypeUtilsKt.getConeType(((FirTypeProjectionWithVariance)typeArgument).getTypeRef()), context.getSession()), new ConeExplicitTypeParameterConstraintPosition(typeArgument));
                continue;
            }
            if (typeArgument instanceof FirStarProjection) {
                KotlinTypeMarker kotlinTypeMarker = freshVariable.getDefaultType();
                Object object = CollectionsKt.firstOrNull(typeParameter.getSymbol().getResolvedBounds());
                if (object == null || (object = FirTypeUtilsKt.getConeType((FirTypeRef)object)) == null) {
                    object = context.getSession().getBuiltinTypes().getNullableAnyType().getType();
                }
                csBuilder.addEqualityConstraint(kotlinTypeMarker, (KotlinTypeMarker)object, SimpleConstraintSystemConstraintPosition.INSTANCE);
                continue;
            }
            boolean bl = typeArgument instanceof FirPlaceholderProjection;
            if (!_Assertions.ENABLED || bl) continue;
            boolean bl2 = false;
            String string2 = "Unexpected typeArgument: " + FirRendererKt.renderWithType$default(typeArgument, null, 1, null);
            throw new AssertionError((Object)string2);
        }
        return Unit.INSTANCE;
    }
}

